/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.internal.storage.reftree.RefTreeBatch;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

class RefTreeUpdate
extends RefUpdate {
    private final RefTreeDatabase refdb;
    private RevWalk rw;
    private RefTreeBatch batch;
    private Ref oldRef;

    RefTreeUpdate(RefTreeDatabase refdb, Ref ref2) {
        super(ref2);
        this.refdb = refdb;
        this.setCheckConflicting(false);
    }

    @Override
    protected RefDatabase getRefDatabase() {
        return this.refdb;
    }

    @Override
    protected Repository getRepository() {
        return this.refdb.getRepository();
    }

    @Override
    protected boolean tryLock(boolean deref2) throws IOException {
        this.rw = new RevWalk(this.getRepository());
        this.batch = new RefTreeBatch(this.refdb);
        this.batch.init(this.rw);
        this.oldRef = this.batch.exactRef(this.rw.getObjectReader(), this.getName());
        if (this.oldRef != null && this.oldRef.getObjectId() != null) {
            this.setOldObjectId(this.oldRef.getObjectId());
        } else if (this.oldRef == null && this.getExpectedOldObjectId() != null) {
            this.setOldObjectId(ObjectId.zeroId());
        }
        return true;
    }

    @Override
    protected void unlock() {
        this.batch = null;
        if (this.rw != null) {
            this.rw.close();
            this.rw = null;
        }
    }

    @Override
    protected RefUpdate.Result doUpdate(RefUpdate.Result desiredResult) throws IOException {
        return this.run(this.newRef(this.getName(), this.getNewObjectId()), desiredResult);
    }

    private Ref newRef(String name2, ObjectId id) throws MissingObjectException, IOException {
        RevObject o = this.rw.parseAny(id);
        if (o instanceof RevTag) {
            RevObject p = this.rw.peel(o);
            return new ObjectIdRef.PeeledTag(Ref.Storage.LOOSE, name2, id, p.copy());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.LOOSE, name2, id);
    }

    @Override
    protected RefUpdate.Result doDelete(RefUpdate.Result desiredResult) throws IOException {
        return this.run(null, desiredResult);
    }

    @Override
    protected RefUpdate.Result doLink(String target) throws IOException {
        ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
        SymbolicRef n = new SymbolicRef(this.getName(), dst);
        RefUpdate.Result desiredResult = this.getRef().getStorage() == Ref.Storage.NEW ? RefUpdate.Result.NEW : RefUpdate.Result.FORCED;
        return this.run(n, desiredResult);
    }

    private RefUpdate.Result run(@Nullable Ref newRef, RefUpdate.Result desiredResult) throws IOException {
        Command c = new Command(this.oldRef, newRef);
        this.batch.setRefLogIdent(this.getRefLogIdent());
        this.batch.setRefLogMessage(this.getRefLogMessage(), this.isRefLogIncludingResult());
        this.batch.execute(this.rw, Collections.singletonList(c));
        return RefTreeUpdate.translate(c.getResult(), desiredResult);
    }

    static RefUpdate.Result translate(ReceiveCommand.Result r, RefUpdate.Result desiredResult) {
        switch (r) {
            case OK: {
                return desiredResult;
            }
            case LOCK_FAILURE: {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            case NOT_ATTEMPTED: {
                return RefUpdate.Result.NOT_ATTEMPTED;
            }
            case REJECTED_MISSING_OBJECT: {
                return RefUpdate.Result.IO_FAILURE;
            }
            case REJECTED_CURRENT_BRANCH: {
                return RefUpdate.Result.REJECTED_CURRENT_BRANCH;
            }
        }
        return RefUpdate.Result.REJECTED;
    }
}

