/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.TypeCheckRewritingVisitor$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u000b0\u000b0\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u001c\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u001e\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020&0\u0015H\u0016J\u001c\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020'2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0018\u0010\u000e\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "localVars", "Ljava/util/Stack;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "scopes", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "isAssignmentToLocalVar", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Z", "isLocalVar", "needsAlias", "getNeedsAlias", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "expandArgumentForTwoInvocations", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "argument", "generateAlias", "getReplacement", "callee", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "calleeArguments", "", "getReplacementForAndPredicate", "p1", "p2", "getReplacementForOrNull", "calleeArgument", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
final class TypeCheckRewritingVisitor
extends JsVisitorWithContextImpl {
    private final Stack<JsScope> scopes = new Stack();
    private final Stack<Set<JsName>> localVars;

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.scopes.push(x.getScope());
        Set set = CollectionUtilsKt.IdentitySet();
        Stack<Set<JsName>> stack = this.localVars;
        Set $receiver = set;
        Collection collection = $receiver;
        List<JsParameter> list2 = x.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.parameters");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            JsName jsName = v1.getName();
            collection2.add(jsName);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        Set set2 = set;
        stack.push(set2);
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        JsName jsName = x.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"x.name");
        this.localVars.peek().add(jsName);
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.scopes.pop();
        this.localVars.pop();
        super.endVisit(x, ctx);
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<JsNode> ctx) {
        JsExpression replacement;
        JsInvocation callee;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        JsExpression jsExpression = x.getQualifier();
        if (!(jsExpression instanceof JsInvocation)) {
            jsExpression = null;
        }
        JsInvocation jsInvocation = callee = (JsInvocation)jsExpression;
        List<JsExpression> calleeArguments = jsInvocation != null ? jsInvocation.getArguments() : null;
        List<JsExpression> list2 = x.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.arguments");
        JsExpression argument = (JsExpression)CollectionsKt.firstOrNull(list2);
        if (callee != null && argument != null && calleeArguments != null && (replacement = this.getReplacement(callee, calleeArguments, argument)) != null) {
            ctx.replaceMe((JsNode)((JsExpression)this.accept((JsNode)replacement)).source(x.getSource()));
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsExpression getReplacement(JsInvocation callee, List<? extends JsExpression> calleeArguments, JsExpression argument) {
        TypeCheck typeCheck;
        TypeCheck typeCheck2 = typeCheck = MetadataProperties.getTypeCheck(callee);
        if (typeCheck2 == null) return null;
        switch (TypeCheckRewritingVisitor$WhenMappings.$EnumSwitchMapping$0[typeCheck2.ordinal()]) {
            case 1: {
                JsBinaryOperation jsBinaryOperation;
                if (calleeArguments.size() == 1) {
                    JsExpression jsExpression = calleeArguments.get(0);
                    if (jsExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsStringLiteral");
                    }
                    jsBinaryOperation = JsAstUtils.typeOfIs(argument, (JsStringLiteral)jsExpression);
                } else {
                    jsBinaryOperation = null;
                }
                JsExpression jsExpression = jsBinaryOperation;
                return jsExpression;
            }
            case 2: {
                if (calleeArguments.size() != 1) return null;
                JsExpression jsExpression = Namer.isInstanceOf(argument, calleeArguments.get(0));
                return jsExpression;
            }
            case 3: {
                if (calleeArguments.size() != 1) return null;
                JsExpression jsExpression = this.getReplacementForOrNull(argument, calleeArguments.get(0));
                return jsExpression;
            }
            case 4: {
                if (calleeArguments.size() != 2) return null;
                JsExpression jsExpression = this.getReplacementForAndPredicate(argument, calleeArguments.get(0), calleeArguments.get(1));
                return jsExpression;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression getReplacementForOrNull(JsExpression argument, JsExpression calleeArgument) {
        void nullCheckTarget;
        if (calleeArgument instanceof JsInvocation && MetadataProperties.getTypeCheck((JsInvocation)calleeArgument) == TypeCheck.OR_NULL) {
            return new JsInvocation(calleeArgument, argument);
        }
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression jsExpression = (JsExpression)pair.component1();
        JsExpression nextCheckTarget = (JsExpression)pair.component2();
        JsBinaryOperation jsBinaryOperation = TranslationUtils.isNullCheck((JsExpression)nullCheckTarget);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"TranslationUtils.isNullCheck(nullCheckTarget)");
        JsBinaryOperation isNull = jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.or(isNull, new JsInvocation(calleeArgument, nextCheckTarget));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation2, (String)"or(isNull, JsInvocation(\u2026gument, nextCheckTarget))");
        return jsBinaryOperation2;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression getReplacementForAndPredicate(JsExpression argument, JsExpression p1, JsExpression p2) {
        void arg1;
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression jsExpression = (JsExpression)pair.component1();
        JsExpression arg2 = (JsExpression)pair.component2();
        JsExpression first2 = (JsExpression)this.accept((JsNode)new JsInvocation(p1, new JsExpression[]{arg1}));
        JsExpression second = (JsExpression)this.accept((JsNode)new JsInvocation(p2, arg2));
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and(first2, second);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"JsAstUtils.and(first, second)");
        return jsBinaryOperation;
    }

    private final Pair<JsExpression, JsExpression> expandArgumentForTwoInvocations(JsExpression argument) {
        Pair pair;
        if (this.isAssignmentToLocalVar(argument)) {
            JsExpression jsExpression = argument;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation");
            }
            pair = new Pair((Object)argument, (Object)((JsBinaryOperation)jsExpression).getArg1());
        } else {
            pair = this.getNeedsAlias(argument) ? this.generateAlias(argument) : new Pair((Object)argument, (Object)argument);
        }
        return pair;
    }

    private final Pair<JsExpression, JsExpression> generateAlias(JsExpression argument) {
        JsName jsName = JsScope.declareTemporary();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"JsScope.declareTemporary()");
        JsName tmp = jsName;
        JsContext<JsStatement> jsContext = this.getLastStatementLevelContext();
        Intrinsics.checkExpressionValueIsNotNull(jsContext, (String)"lastStatementLevelContext");
        JsContext<JsStatement> statementContext = jsContext;
        statementContext.addPrevious((JsNode)JsAstUtils.newVar(tmp, null));
        return new Pair((Object)JsAstUtils.assignment(tmp.makeRef(), argument), (Object)tmp.makeRef());
    }

    private final boolean getNeedsAlias(@NotNull JsExpression $receiver) {
        JsExpression jsExpression = $receiver;
        return jsExpression instanceof JsLiteral.JsValueLiteral ? false : !this.isLocalVar($receiver);
    }

    private final boolean isLocalVar(@NotNull JsExpression $receiver) {
        Object it;
        Object object = this.localVars;
        return !object.isEmpty() && $receiver instanceof JsNameRef && (it = (object = ((JsNameRef)$receiver).getName())) != null && this.localVars.peek().contains(it);
    }

    private final boolean isAssignmentToLocalVar(@NotNull JsExpression $receiver) {
        Pair<JsName, JsExpression> it;
        Pair<JsName, JsExpression> pair = (Pair<JsName, JsExpression>)this.localVars;
        return !pair.isEmpty() && (it = (pair = JsAstUtils.decomposeAssignmentToVariable($receiver))) != null && this.localVars.peek().contains(it.getFirst());
    }

    public TypeCheckRewritingVisitor() {
        Stack<Set> $receiver;
        Stack<Set> stack = new Stack<Set>();
        TypeCheckRewritingVisitor typeCheckRewritingVisitor = this;
        Stack<Set> stack2 = $receiver = stack;
        Set set = new LinkedHashSet();
        stack2.push(set);
        Stack<Set> stack3 = stack;
        typeCheckRewritingVisitor.localVars = stack3;
    }
}

