/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.UncheckedException;

public class NestedBeanAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Nested.class;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return !visitor.visitOutputFilePropertiesOnly();
    }

    @Override
    public void visitPropertyValue(PropertyValue propertyValue, PropertyVisitor visitor, PropertySpecFactory specFactory, BeanPropertyContext context) {
        Object nested;
        try {
            nested = NestedBeanAnnotationHandler.unpackProvider(propertyValue.getValue());
        }
        catch (Exception e) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new InvalidPropertyValue(e)));
            return;
        }
        if (nested != null) {
            context.addNested(propertyValue.getPropertyName(), nested);
        } else if (!propertyValue.isOptional()) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new AbsentPropertyValue()));
        }
    }

    @Nullable
    private static Object unpackProvider(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).get();
        }
        return value;
    }

    private static class AbsentPropertyValue
    implements ValidatingValue {
        private AbsentPropertyValue() {
        }

        @Override
        @Nullable
        public Object call() {
            return null;
        }

        @Override
        public void attachProducer(Task producer) {
        }

        @Override
        public void maybeFinalizeValue() {
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            context.recordValidationMessage(String.format("No value has been specified for property '%s'.", propertyName));
        }
    }

    private static class InvalidPropertyValue
    implements ValidatingValue {
        private final Exception exception;

        public InvalidPropertyValue(Exception exception) {
            this.exception = exception;
        }

        @Override
        @Nullable
        public Object call() {
            return null;
        }

        @Override
        public void attachProducer(Task producer) {
        }

        @Override
        public void maybeFinalizeValue() {
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }
    }
}

