/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.CurrentTaskExecution;
import org.gradle.caching.internal.tasks.DebuggingTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.DefaultTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class TaskCacheKeyCalculator {
    private final boolean buildCacheDebugLogging;

    public TaskCacheKeyCalculator(boolean buildCacheDebugLogging) {
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    public TaskOutputCachingBuildCacheKey calculate(TaskInternal task, CurrentTaskExecution execution) {
        TaskOutputCachingBuildCacheKeyBuilder builder = new DefaultTaskOutputCachingBuildCacheKeyBuilder(task.getIdentityPath());
        if (this.buildCacheDebugLogging) {
            builder = new DebuggingTaskOutputCachingBuildCacheKeyBuilder(builder);
        }
        builder.appendTaskImplementation(execution.getTaskImplementation());
        builder.appendTaskActionImplementations((Collection<ImplementationSnapshot>)execution.getTaskActionImplementations());
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = execution.getInputProperties();
        for (Map.Entry entry : inputProperties.entrySet()) {
            Hasher hasher = Hashing.newHasher();
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
            if (hasher.isValid()) {
                HashCode hash = hasher.hash();
                builder.appendInputValuePropertyHash((String)entry.getKey(), hash);
                continue;
            }
            builder.inputPropertyNotCacheable((String)entry.getKey(), hasher.getInvalidReason());
        }
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFingerprints = execution.getInputFingerprints();
        for (Map.Entry entry : inputFingerprints.entrySet()) {
            builder.appendInputFilesProperty((String)entry.getKey(), (CurrentFileCollectionFingerprint)entry.getValue());
        }
        ImmutableSortedSet<String> immutableSortedSet = execution.getOutputPropertyNamesForCacheKey();
        for (String cacheableOutputPropertyName : immutableSortedSet) {
            builder.appendOutputPropertyName(cacheableOutputPropertyName);
        }
        return builder.build();
    }
}

