/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.util.CollectionUtils;

class DynamicAddDependencyMethods
implements MethodAccess {
    private ConfigurationContainer configurationContainer;
    private DependencyAdder dependencyAdder;

    DynamicAddDependencyMethods(ConfigurationContainer configurationContainer, DependencyAdder dependencyAdder) {
        this.configurationContainer = configurationContainer;
        this.dependencyAdder = dependencyAdder;
    }

    public boolean hasMethod(String name, Object ... arguments) {
        return arguments.length != 0 && this.configurationContainer.findByName(name) != null;
    }

    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        if (arguments.length == 0) {
            return DynamicInvokeResult.notFound();
        }
        Configuration configuration = (Configuration)this.configurationContainer.findByName(name);
        if (configuration == null) {
            return DynamicInvokeResult.notFound();
        }
        List normalizedArgs = CollectionUtils.flattenCollections((Object[])arguments);
        if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
            return DynamicInvokeResult.found(this.dependencyAdder.add(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1)));
        }
        if (normalizedArgs.size() == 1) {
            return DynamicInvokeResult.found(this.dependencyAdder.add(configuration, normalizedArgs.get(0), null));
        }
        for (Object arg : normalizedArgs) {
            this.dependencyAdder.add(configuration, arg, null);
        }
        return DynamicInvokeResult.found();
    }

    static interface DependencyAdder<T> {
        public T add(Configuration var1, Object var2, Closure var3);
    }
}

