/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Describables;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private final ComponentSelector requested;
    private ComponentSelectionDescriptorInternal selectionDescription;
    private ComponentSelector target;

    public DefaultDependencySubstitution(ComponentSelector requested, String reason) {
        this.requested = requested;
        this.target = requested;
        this.selectionDescription = reason != null ? VersionSelectionReasons.REQUESTED.withReason((Describable)Describables.of((Object)reason)) : VersionSelectionReasons.REQUESTED;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public void useTarget(Object notation) {
        this.useTarget(notation, VersionSelectionReasons.SELECTED_BY_RULE);
    }

    public void useTarget(Object notation, String reason) {
        this.useTarget(notation, new DefaultComponentSelectionDescriptor(ComponentSelectionCause.SELECTED_BY_RULE, (Describable)Describables.of((Object)reason)));
    }

    @Override
    public void useTarget(Object notation, ComponentSelectionDescriptor selectionDescription) {
        this.target = (ComponentSelector)ComponentSelectorParsers.parser().parseNotation(notation);
        this.selectionDescription = (ComponentSelectionDescriptorInternal)selectionDescription;
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    @Override
    public ComponentSelectionDescriptorInternal getSelectionDescription() {
        return this.selectionDescription;
    }

    @Override
    public ComponentSelector getTarget() {
        return this.target;
    }

    @Override
    public boolean isUpdated() {
        return this.selectionDescription.getCause() != ComponentSelectionCause.REQUESTED;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

