/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies;

import groovy.lang.Closure;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.dependencies.DependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.DefaultDependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.HtmlDependencyReporter;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.util.ClosureBackedAction;

public class HtmlDependencyReportTask
extends ConventionTask
implements Reporting<DependencyReportContainer> {
    private Set<Project> projects;
    private final DependencyReportContainer reports = (DependencyReportContainer)this.getObjectFactory().newInstance(DefaultDependencyReportContainer.class, new Object[]{this});

    public HtmlDependencyReportTask() {
        this.reports.getHtml().setEnabled(true);
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return false;
            }
        });
    }

    @Nested
    public DependencyReportContainer getReports() {
        return this.reports;
    }

    public DependencyReportContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public DependencyReportContainer reports(Action<? super DependencyReportContainer> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionParser getVersionParser() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        if (!this.reports.getHtml().isEnabled()) {
            this.setDidWork(false);
            return;
        }
        HtmlDependencyReporter reporter = new HtmlDependencyReporter(this.getVersionSelectorScheme(), this.getVersionComparator(), this.getVersionParser());
        reporter.render(this.getProjects(), this.reports.getHtml().getDestination());
        this.getProject().getLogger().lifecycle("See the report at: {}", new Object[]{new ConsoleRenderer().asClickableFileUrl(this.reports.getHtml().getEntryPoint())});
    }

    @Internal
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }
}

