/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacSlaterReader {
    private static String DS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String DC_LIST = "xx    yy    zz    xy    xz    yz";
    private static String FS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String FC_LIST = "xxx   yyy   zzz   yyx   xxy   xxz   zzx   zzy   yyz   xyz";

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.equals("[HEADER]")) {
            this.readHeader();
            return true;
        }
        if (this.line.equals("[ATOMS]")) {
            this.readAtoms();
            return false;
        }
        if (this.line.equals("[BONDS]")) {
            this.readBonds();
            return false;
        }
        if (!this.doReadMolecularOrbitals) {
            return true;
        }
        if (this.line.equals("[AO_ORDER]")) {
            this.readAtomicOrbitalOrder();
            return false;
        }
        if (this.line.equals("[GTO]")) {
            this.readGaussianBasis();
            return false;
        }
        if (this.line.equals("[STO]")) {
            this.readSlaterBasis();
            return false;
        }
        if (this.line.indexOf("[MO") == 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readMolecularOrbital();
            return false;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
        if (this.nOrbitals > 0) {
            this.setMOs("eV");
        }
        if (this.debugging) {
            Logger.debug(String.valueOf(this.orbitals.size()) + " molecular orbitals read");
        }
    }

    void readHeader() throws Exception {
        this.moData.put("isNormalized", Boolean.TRUE);
        while (this.rd() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] stringArray = this.getTokens();
            stringArray[0] = String.valueOf(stringArray[0].substring(0, 1).toLowerCase()) + stringArray[0].substring(1, stringArray[0].length());
            String string = "";
            int n = 1;
            while (n < stringArray.length) {
                string = String.valueOf(string) + (n == 1 ? "" : " ") + stringArray[n].toLowerCase();
                ++n;
            }
            this.moData.put(stringArray[0], string);
        }
    }

    void readAtoms() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            String string = stringArray[0];
            int n = this.parseIntStr(string);
            String string2 = this.setAtomCoordScaled(null, (String[])stringArray, (int)1, (float)0.5291772f).elementSymbol = n == Integer.MIN_VALUE ? string : WebMOReader.getElementSymbol(n);
        }
    }

    void readBonds() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            int n = this.parseIntStr(stringArray[0]);
            int n2 = this.parseIntStr(stringArray[1]);
            int n3 = this.parseIntStr(stringArray[2]);
            this.asc.addBond(new Bond(n - 1, n2 - 1, n3));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            String string = this.line.substring(9).trim().toLowerCase();
            boolean bl = false;
            switch (stringArray.length - 1) {
                case 3: 
                case 4: {
                    bl = true;
                    break;
                }
                case 5: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap("DS", string, 3, DS_LIST, 99);
                    break;
                }
                case 6: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap("DC", string, 4, DC_LIST, 2);
                    break;
                }
                case 7: {
                    bl = stringArray[0].equals("FOrbitals") && this.getDFMap("FS", string, 5, FS_LIST, 99);
                    break;
                }
                case 10: {
                    boolean bl2 = bl = stringArray[0].equals("FOrbitals") && this.getDFMap("FC", string, 6, FC_LIST, 3);
                }
            }
            if (bl) continue;
            Logger.error("atomic orbital order is unrecognized -- skipping reading of MOs due to line: " + this.line);
            this.orbitals = null;
        }
    }

    private boolean getLine() throws Exception {
        return this.rd() != null && (this.line.length() == 0 || this.line.charAt(0) != '[');
    }

    void readGaussianBasis() throws Exception {
        Object object;
        Lst<int[]> lst = new Lst<int[]>();
        Lst<float[]> lst2 = new Lst<float[]>();
        int n = 1;
        int n2 = 0;
        while (this.getLine()) {
            object = this.getTokens();
            if (((float[][])object).length == 0) continue;
            if (((float[][])object).length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] nArray = new int[4];
            n = this.parseIntStr((String)object[0]);
            object = PT.getTokens(this.rd());
            int n3 = this.parseIntStr((String)object[1]);
            nArray[0] = n;
            nArray[1] = BasisFunctionReader.getQuantumShellTagID((String)object[0]);
            nArray[2] = n2 + 1;
            nArray[3] = n3;
            int n4 = 0;
            while (n4 < n3) {
                String[] stringArray = PT.getTokens(this.rd());
                int n5 = stringArray.length;
                float[] fArray = new float[n5];
                int n6 = 0;
                while (n6 < n5) {
                    fArray[n6] = this.parseFloatStr(stringArray[n6]);
                    ++n6;
                }
                lst2.addLast(fArray);
                ++n2;
                ++n4;
            }
            lst.addLast(nArray);
        }
        object = AU.newFloat2(n2);
        int n7 = 0;
        while (n7 < n2) {
            object[n7] = (float[])lst2.get(n7);
            ++n7;
        }
        this.moData.put("shells", lst);
        this.moData.put("gaussians", object);
        if (this.debugging) {
            Logger.debug(String.valueOf(lst.size()) + " slater shells read");
            Logger.debug(String.valueOf(((float[][])object).length) + " gaussian primitives read");
        }
        this.asc.setCurrentModelInfo("moData", this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 7) continue;
            this.addSlater(this.parseIntStr(stringArray[0]), this.parseIntStr(stringArray[1]), this.parseIntStr(stringArray[2]), this.parseIntStr(stringArray[3]), this.parseIntStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]));
        }
        this.setSlaters(false, false);
    }

    void readMolecularOrbital() throws Exception {
        Object[] objectArray;
        if (this.orbitals == null) {
            Logger.error("MOLECULAR ORBITALS SKIPPED");
            while (this.getLine()) {
            }
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst<String> lst = new Lst<String>();
        float f = this.parseFloatStr(this.rd());
        float f2 = this.parseFloatStr(this.rd());
        while (this.getLine()) {
            objectArray = this.getTokens();
            if (objectArray.length == 0) continue;
            lst.addLast(objectArray[1]);
        }
        objectArray = new float[lst.size()];
        int n = lst.size();
        while (--n >= 0) {
            objectArray[n] = (String)this.parseFloatStr((String)lst.get(n));
        }
        hashtable.put("energy", Float.valueOf(f));
        hashtable.put("occupancy", Float.valueOf(f2));
        hashtable.put("coefficients", objectArray);
        this.orbitals.addLast(hashtable);
        ++this.nOrbitals;
        if (f2 > 0.0f) {
            this.moData.put("HOMO", this.nOrbitals);
        }
    }
}

