/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOSocket;
import naga.PacketReader;
import naga.PacketWriter;
import naga.ServerSocketObserver;
import naga.ServerSocketObserverAdapter;
import naga.SocketObserver;
import naga.SocketObserverAdapter;
import naga.packetreader.AsciiLinePacketReader;
import naga.packetwriter.RawPacketWriter;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;

public class JsonNioService
extends NIOService
implements JsonNioServer {
    protected String myName;
    protected boolean halt;
    protected boolean isPaused;
    protected long latestMoveTime;
    protected int port;
    private Thread thread;
    private Thread serverThread;
    private NIOSocket inSocket;
    protected NIOSocket outSocket;
    private NIOServerSocket serverSocket;
    Viewer vwr;
    private JsonNioClient client;
    private boolean wasSpinOn;
    private String contentPath = "./%ID%.json";
    private String terminatorMessage = "NEXT_SCRIPT";
    private String resetMessage = "RESET_SCRIPT";
    protected int version = 1;
    private int nFast;
    private float swipeCutoff = 100.0f;
    private int swipeCount = 2;
    private float swipeDelayMs = 3000.0f;
    private long previousMoveTime;
    private long swipeStartTime;
    private float swipeFactor = 30.0f;
    private boolean motionDisabled;
    private boolean contentDisabled;

    @Override
    public void scriptCallback(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("banner:")) {
            this.setBanner(string.substring(7).trim(), false);
        } else if (string.equals(this.terminatorMessage)) {
            this.sendMessage(null, "!script_terminated!", null);
        } else if (this.contentDisabled && string.equals(this.resetMessage)) {
            this.client.nioRunContent(null);
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void send(int n, String string) {
        try {
            if (n != this.port) {
                if (this.inSocket != null) {
                    this.inSocket.close();
                    if (this.outSocket != null) {
                        this.outSocket.close();
                    }
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.startService(n, this.client, this.vwr, this.myName, 1);
            }
            if (string.startsWith("Mouse:")) {
                string = "{\"type\":\"sync\", \"sync\":\"" + string.substring(6) + "\"}";
            }
            this.sendMessage(null, string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void startService(int n, JsonNioClient jsonNioClient, Viewer viewer, String string, int n2) throws IOException {
        this.version = n2;
        this.port = Math.abs(n);
        this.client = jsonNioClient;
        this.vwr = viewer;
        String string2 = this.myName = string == null ? "" : string;
        if (n < 0) {
            this.startServerService();
            return;
        }
        if (string != null) {
            String string3 = JsonNioService.getJmolValueAsString(viewer, "NIOcontentPath");
            if (string3 != "") {
                this.contentPath = string3;
            }
            if ((string3 = JsonNioService.getJmolValueAsString(viewer, "NIOterminatorMessage")) != "") {
                this.terminatorMessage = string3;
            }
            if ((string3 = JsonNioService.getJmolValueAsString(viewer, "NIOresetMessage")) != "") {
                this.resetMessage = string3;
            }
            this.setEnabled();
            Logger.info("NIOcontentPath=" + this.contentPath);
            Logger.info("NIOterminatorMessage=" + this.terminatorMessage);
            Logger.info("NIOresetMessage=" + this.resetMessage);
            Logger.info("NIOcontentDisabled=" + this.contentDisabled);
            Logger.info("NIOmotionDisabled=" + this.motionDisabled);
        }
        Logger.info("JsonNioService" + this.myName + " using port " + n);
        if (n != 0) {
            this.inSocket = this.openSocket("127.0.0.1", n);
            this.inSocket.setPacketReader((PacketReader)new AsciiLinePacketReader());
            this.inSocket.setPacketWriter((PacketWriter)RawPacketWriter.INSTANCE);
            this.inSocket.listen(new SocketObserver(){

                public void connectionOpened(NIOSocket nIOSocket) {
                    JsonNioService.this.initialize("out", nIOSocket);
                }

                public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                    JsonNioService.this.processMessage(byArray, null);
                }

                public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                    JsonNioService.this.halt = true;
                    Logger.info(String.valueOf(Thread.currentThread().getName()) + " inSocket connectionBroken");
                }

                public void packetSent(NIOSocket nIOSocket, Object object) {
                }
            });
            if (n2 == 1) {
                this.outSocket = this.openSocket("127.0.0.1", n);
                this.outSocket.setPacketReader((PacketReader)new AsciiLinePacketReader());
                this.outSocket.setPacketWriter((PacketWriter)RawPacketWriter.INSTANCE);
                this.outSocket.listen(new SocketObserver(){

                    public void connectionOpened(NIOSocket nIOSocket) {
                        JsonNioService.this.initialize("in", nIOSocket);
                    }

                    public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                        Logger.info("outpacketreceived");
                    }

                    public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                        JsonNioService.this.halt = true;
                        Logger.info(String.valueOf(Thread.currentThread().getName()) + " outSocket connectionBroken");
                    }

                    public void packetSent(NIOSocket nIOSocket, Object object) {
                    }
                });
            }
        }
        if (n != 0) {
            this.thread = new Thread((Runnable)new JsonNioThread(), "JsonNiosThread" + this.myName);
            this.thread.start();
        }
        if (n == 0 && this.contentDisabled) {
            jsonNioClient.nioRunContent(this);
        }
    }

    private void setEnabled() {
        this.contentDisabled = JsonNioService.getJmolValueAsString(this.vwr, "NIOcontentDisabled").equals("true");
        this.motionDisabled = JsonNioService.getJmolValueAsString(this.vwr, "NIOmotionDisabled").equals("true");
    }

    public static String getJmolValueAsString(Viewer viewer, String string) {
        return viewer == null ? "" : "" + viewer.getP(string);
    }

    @Override
    public void close() {
        Logger.info("JsonNioService" + this.myName + " close");
        try {
            this.halt = true;
            super.close();
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.client != null) {
            this.client.nioClosed(this);
        }
    }

    protected void initialize(String string, NIOSocket nIOSocket) {
        Logger.info("JsonNioService" + this.myName + " initialize " + string);
        JSONObject jSONObject = new JSONObject();
        if (this.version == 1) {
            jSONObject.put("magic", "JmolApp");
            jSONObject.put("role", string);
        } else {
            jSONObject.put("source", "Jmol");
            jSONObject.put("type", "login");
        }
        this.sendMessage(jSONObject, null, nIOSocket);
    }

    private void startServerService() {
        try {
            this.serverSocket = this.openServerSocket(this.port);
            this.serverSocket.listen((ServerSocketObserver)new ServerSocketObserverAdapter(){

                public void newConnection(NIOSocket nIOSocket) {
                    Logger.info(String.valueOf(Thread.currentThread().getName()) + " Received connection: " + nIOSocket);
                    nIOSocket.setPacketReader((PacketReader)new AsciiLinePacketReader());
                    nIOSocket.setPacketWriter((PacketWriter)RawPacketWriter.INSTANCE);
                    nIOSocket.listen((SocketObserver)new SocketObserverAdapter(){

                        public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                            JsonNioService.this.processMessage(byArray, nIOSocket);
                        }

                        public void connectionOpened(NIOSocket nIOSocket) {
                        }

                        public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                            Logger.info("JsonNioService" + (this).JsonNioService.this.myName + " server connection broken");
                            if (nIOSocket == (this).JsonNioService.this.outSocket) {
                                (this).JsonNioService.this.outSocket = null;
                            }
                        }
                    });
                }
            });
            this.serverSocket.setConnectionAcceptor(new ConnectionAcceptor(){

                public boolean acceptConnection(InetSocketAddress inetSocketAddress) {
                    boolean bl = inetSocketAddress.getAddress().isLoopbackAddress();
                    return bl;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = new Thread((Runnable)new JsonNioServerThread(), "JsonNioServerThread" + this.myName);
        this.serverThread.start();
    }

    protected void processMessage(byte[] byArray, NIOSocket nIOSocket) {
        try {
            String string = new String(byArray);
            Logger.info("JNIOS received " + string);
            if (this.vwr == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject(string);
            if (this.version == 1) {
                if (nIOSocket != null && jSONObject.has("magic") && jSONObject.getString("magic").equals("JmolApp") && jSONObject.getString("role").equals("out")) {
                    this.outSocket = nIOSocket;
                }
            } else {
                this.outSocket = this.inSocket;
            }
            if (!jSONObject.has("type")) {
                return;
            }
            this.processJSON(jSONObject, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void processJSON(JSONObject jSONObject, String string) throws Exception {
        if (jSONObject == null) {
            jSONObject = new JSONObject(string);
        }
        int n = "banner....command...content...move......quit......sync......touch.....".indexOf(jSONObject.getString("type"));
        this.setEnabled();
        switch (n) {
            case 0: {
                if (this.contentDisabled) break;
                this.setBanner((String)(jSONObject.has("text") ? jSONObject.getString("text") : (jSONObject.getString("visibility").equalsIgnoreCase("off") ? null : "")), false);
                break;
            }
            case 10: {
                if (this.contentDisabled) break;
                if (jSONObject.containsKey("var") && jSONObject.containsKey("data")) {
                    this.vwr.g.setUserVariable(jSONObject.get("var").toString(), SV.getVariable(jSONObject.get("data")));
                }
                this.sendScript(jSONObject.getString("command"));
                break;
            }
            case 20: {
                Object object;
                Object object2;
                if (this.contentDisabled) {
                    this.client.nioRunContent(this);
                    break;
                }
                String string2 = jSONObject.getString("id");
                String string3 = PT.rep(this.contentPath, "%ID%", string2).replace('\\', '/');
                File file = new File(string3);
                Logger.info("JsonNiosService Setting path to " + file.getAbsolutePath());
                n = string3.lastIndexOf(47);
                string3 = n >= 0 ? string3.substring(0, n) : ".";
                JSONObject jSONObject2 = null;
                try {
                    String string4;
                    object2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    object = SB.newN(8192);
                    while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                        ((SB)object).append(string4).appendC('\n');
                    }
                    ((BufferedReader)object2).close();
                    jSONObject2 = new JSONObject(((SB)object).toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                object2 = null;
                if (jSONObject2.has("scripts")) {
                    object = jSONObject2.getJSONArray("scripts");
                    int n2 = object.size();
                    while (--n2 >= 0) {
                        JSONObject jSONObject3 = (JSONObject)object.get(n2);
                        if (!jSONObject3.getString("startup").equals("yes")) continue;
                        object2 = jSONObject3.getString("filename");
                        break;
                    }
                    if (object2 == null) {
                        throw new Exception("scripts startup:yes not found");
                    }
                } else {
                    object2 = jSONObject2.getString("startup_script");
                }
                Logger.info("JsonNiosService startup_script=" + (String)object2);
                this.setBanner("", false);
                this.sendScript("exit");
                this.sendScript("zap;cd \"" + string3 + "\";script " + (String)object2);
                this.setBanner(jSONObject2.getString("banner").equals("off") ? null : jSONObject2.getString("banner_text"), true);
                break;
            }
            case 30: {
                n = "rotate....translate.zoom......".indexOf(jSONObject.getString("style"));
                if (this.motionDisabled) break;
                if (n != 0 && !this.isPaused) {
                    this.pauseScript(true);
                }
                long l = this.latestMoveTime = System.currentTimeMillis();
                switch (n) {
                    case 0: {
                        boolean bl;
                        float f = (float)jSONObject.getDouble("x");
                        float f2 = (float)jSONObject.getDouble("y");
                        float f3 = f * f + f2 * f2;
                        boolean bl2 = f3 > this.swipeCutoff;
                        boolean bl3 = bl = this.vwr.getBooleanProperty("isNavigating") || !this.vwr.getBooleanProperty("allowGestures");
                        if (bl || bl2 || (float)(l - this.swipeStartTime) > this.swipeDelayMs) {
                            string = null;
                            if (!bl) {
                                if (bl2) {
                                    if (++this.nFast > this.swipeCount) {
                                        this.swipeStartTime = l;
                                        string = "Mouse: spinXYBy " + (int)f + " " + (int)f2 + " " + Math.sqrt(f3) * (double)this.swipeFactor / (double)(l - this.previousMoveTime);
                                    }
                                } else if (this.nFast > 0) {
                                    this.nFast = 0;
                                    string = "Mouse: spinXYBy 0 0 0";
                                }
                            }
                            if (string == null) {
                                string = "Mouse: rotateXYBy " + f + " " + f2;
                            }
                            this.syncScript(string);
                        }
                        this.previousMoveTime = l;
                        break;
                    }
                    case 10: {
                        this.vwr.syncScript("Mouse: translateXYBy " + jSONObject.getString("x") + " " + jSONObject.getString("y"), "=", 0);
                        break;
                    }
                    case 20: {
                        float f = (float)(jSONObject.getDouble("scale") / (double)(this.vwr.tm.zmPct / 100.0f));
                        this.syncScript("Mouse: zoomByFactor " + f);
                    }
                }
                break;
            }
            case 40: {
                this.halt = true;
                Logger.info("JsonNiosService quitting");
                break;
            }
            case 50: {
                if (this.motionDisabled) break;
                this.syncScript("Mouse: " + jSONObject.getString("sync"));
                break;
            }
            case 60: {
                if (this.motionDisabled) break;
                this.vwr.acm.processMultitouchEvent(0, jSONObject.getInt("eventType"), jSONObject.getInt("touchID"), jSONObject.getInt("iData"), P3.new3((float)jSONObject.getDouble("x"), (float)jSONObject.getDouble("y"), (float)jSONObject.getDouble("z")), jSONObject.getLong("time"));
            }
        }
    }

    private void sendScript(String string) {
        Logger.info("JsonNiosService sendScript " + string);
        this.vwr.evalStringQuiet(string);
    }

    private void syncScript(String string) {
        Logger.info("JsonNiosService syncScript " + string);
        this.vwr.syncScript(string, "=", 0);
    }

    private void setBanner(String string, boolean bl) {
        if (string == null) {
            this.client.setBannerLabel(null);
        } else {
            if (bl) {
                string = "<center>" + string + "</center>";
            }
            this.client.setBannerLabel("<html>" + string + "</html>");
        }
    }

    protected void pauseScript(boolean bl) {
        String string;
        if (bl) {
            this.wasSpinOn = this.vwr.getBooleanProperty("spinOn");
            string = "pause; save orientation 'JsonNios-save'; spin off";
            this.isPaused = true;
        } else {
            string = "restore orientation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
            this.wasSpinOn = false;
        }
        this.isPaused = bl;
        this.sendScript(string);
    }

    private void sendMessage(JSONObject jSONObject, String string, NIOSocket nIOSocket) {
        if (nIOSocket == null && (nIOSocket = this.outSocket) == null) {
            return;
        }
        try {
            if (jSONObject != null) {
                string = jSONObject.toString();
            } else if (string != null && string.indexOf("{") != 0) {
                jSONObject = new JSONObject();
                if (string.equalsIgnoreCase("!script_terminated!")) {
                    jSONObject.put("type", "script");
                    jSONObject.put("event", "done");
                } else {
                    jSONObject.put("type", "command");
                    jSONObject.put("command", string);
                }
                string = jSONObject.toString();
            }
            string = String.valueOf(string) + "\r\n";
            Logger.info(String.valueOf(Thread.currentThread().getName()) + " sending " + string + " to " + nIOSocket);
            nIOSocket.write(string.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class JSONObject
    extends Hashtable<String, Object> {
        public JSONObject() {
        }

        JSONObject(String string) throws Exception {
            SV sV = JsonNioService.this.vwr.evaluateExpressionAsVariable(string);
            if (!(sV.value instanceof Map)) {
                throw new Exception("invalid JSON: " + string);
            }
            this.putAll((Map)sV.value);
        }

        public JSONObject(Map<String, Object> map) {
            this.putAll(map);
        }

        boolean has(String string) {
            return this.containsKey(string);
        }

        String getString(String string) throws Exception {
            return this.containsKey(string) ? this.get(string).toString() : null;
        }

        public List<JSONObject> getJSONArray(String string) throws Exception {
            if (!this.has(string)) {
                throw new Exception("JSON key not found:" + string);
            }
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            Lst<SV> lst = ((SV)this.get(string)).getList();
            int n = 0;
            while (n < lst.size()) {
                arrayList.add(new JSONObject((Map)((SV)lst.get((int)n)).value));
                ++n;
            }
            return arrayList;
        }

        public Object get(String string) {
            Object v = super.get(string);
            return v instanceof SV ? SV.oValue(v) : v;
        }

        public long getLong(String string) throws Exception {
            if (!this.has(string)) {
                throw new Exception("JSON key not found:" + string);
            }
            return Long.parseLong(this.get(string).toString());
        }

        public int getInt(String string) throws Exception {
            if (!this.has(string)) {
                throw new Exception("JSON key not found:" + string);
            }
            return Integer.parseInt(this.get(string).toString());
        }

        public double getDouble(String string) throws Exception {
            if (!this.has(string)) {
                throw new Exception("JSON key not found:" + string);
            }
            return Double.parseDouble(this.get(string).toString());
        }

        @Override
        public synchronized String toString() {
            SB sB = new SB();
            sB.append("{");
            String string = "";
            for (Map.Entry entry : this.entrySet()) {
                sB.append(string).append(PT.esc((String)entry.getKey())).append(":").append(Escape.e(entry.getValue()));
                string = ",";
            }
            return sB.append("}").toString();
        }
    }

    protected class JsonNioServerThread
    implements Runnable {
        protected JsonNioServerThread() {
        }

        @Override
        public void run() {
            Logger.info(String.valueOf(Thread.currentThread().getName()) + " JsonNioServerSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectBlocking();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JsonNioService.this.close();
        }
    }

    protected class JsonNioThread
    implements Runnable {
        protected JsonNioThread() {
        }

        @Override
        public void run() {
            Logger.info(String.valueOf(Thread.currentThread().getName()) + " JsonNioSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectNonBlocking();
                    long l = System.currentTimeMillis();
                    if (JsonNioService.this.isPaused && l - JsonNioService.this.latestMoveTime > 5000L) {
                        JsonNioService.this.pauseScript(false);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            JsonNioService.this.close();
        }
    }
}

