/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class Plane
implements PrimitiveList {
    private Point3 center = new Point3(0.0f, 0.0f, 0.0f);
    private Vector3 normal = new Vector3(0.0f, 1.0f, 0.0f);
    int k = 3;
    private float bnu = 0.0f;
    private float bnv = 0.0f;
    private float bnd = 0.0f;
    private float cnu = 0.0f;
    private float cnv = 0.0f;
    private float cnd = 0.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.center = parameterList.getPoint("center", this.center);
        Point3 point3 = parameterList.getPoint("point1", null);
        Point3 point32 = parameterList.getPoint("point2", null);
        if (point3 != null && point32 != null) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            Point3 point33 = this.center;
            Point3 point34 = point3;
            Point3 point35 = point32;
            Vector3 vector3 = this.normal = Vector3.cross(Point3.sub(point34, point33, new Vector3()), Point3.sub(point35, point33, new Vector3()), new Vector3()).normalize();
            this.k = Math.abs(vector3.x) > Math.abs(vector3.y) && Math.abs(vector3.x) > Math.abs(vector3.z) ? 0 : (Math.abs(vector3.y) > Math.abs(vector3.z) ? 1 : 2);
            switch (this.k) {
                case 0: {
                    f6 = point33.y;
                    f5 = point33.z;
                    f4 = point35.y - f6;
                    f3 = point35.z - f5;
                    f2 = point34.y - f6;
                    f = point34.z - f5;
                    break;
                }
                case 1: {
                    f6 = point33.z;
                    f5 = point33.x;
                    f4 = point35.z - f6;
                    f3 = point35.x - f5;
                    f2 = point34.z - f6;
                    f = point34.x - f5;
                    break;
                }
                default: {
                    f6 = point33.x;
                    f5 = point33.y;
                    f4 = point35.x - f6;
                    f3 = point35.y - f5;
                    f2 = point34.x - f6;
                    f = point34.y - f5;
                }
            }
            float f7 = f4 * f - f3 * f2;
            this.bnu = -f3 / f7;
            this.bnv = f4 / f7;
            this.bnd = (f3 * f6 - f4 * f5) / f7;
            this.cnu = f / f7;
            this.cnv = -f2 / f7;
            this.cnd = (f2 * f5 - f * f6) / f7;
        } else {
            this.normal = parameterList.getVector("normal", this.normal);
            this.k = 3;
            this.bnd = 0.0f;
            this.bnv = 0.0f;
            this.bnu = 0.0f;
            this.cnd = 0.0f;
            this.cnv = 0.0f;
            this.cnu = 0.0f;
        }
        return true;
    }

    public void prepareShadingState(ShadingState shadingState) {
        float f;
        float f2;
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Vector3 vector3 = shadingState.transformNormalObjectToWorld(this.normal);
        shadingState.getNormal().set(vector3);
        shadingState.getGeoNormal().set(vector3);
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        Point3 point3 = shadingState.transformWorldToObject(shadingState.getPoint());
        switch (this.k) {
            case 0: {
                f2 = point3.y;
                f = point3.z;
                break;
            }
            case 1: {
                f2 = point3.z;
                f = point3.x;
                break;
            }
            case 2: {
                f2 = point3.x;
                f = point3.y;
                break;
            }
            default: {
                f = 0.0f;
                f2 = 0.0f;
            }
        }
        shadingState.getUV().x = f2 * this.bnu + f * this.bnv + this.bnd;
        shadingState.getUV().y = f2 * this.cnu + f * this.cnv + this.cnd;
        shadingState.setBasis(OrthoNormalBasis.makeFromW(this.normal));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = this.normal.x * ray.dx + this.normal.y * ray.dy + this.normal.z * ray.dz;
        if ((double)f == 0.0) {
            return;
        }
        float f2 = ((this.center.x - ray.ox) * this.normal.x + (this.center.y - ray.oy) * this.normal.y + (this.center.z - ray.oz) * this.normal.z) / f;
        if (ray.isInside(f2)) {
            ray.setMax(f2);
            intersectionState.setIntersection(0);
        }
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        return null;
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

