/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ExtensionsClassLoader
extends ClassLoader {
    private final ProtectionDomain protectionDomain;
    private final String[] applicationPackages;
    private final Map extensionDlls = new HashMap();
    private JarFile[] extensionJars = null;

    public ExtensionsClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain, String[] stringArray, String[] stringArray2) {
        this(classLoader, protectionDomain, stringArray, new URL[0], stringArray2, null, null);
    }

    public ExtensionsClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain, String[] stringArray, URL[] uRLArray, String[] stringArray2, File file, String string) {
        this(classLoader, protectionDomain, stringArray, uRLArray, stringArray2, file, string, false);
    }

    public ExtensionsClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain, String[] stringArray, URL[] uRLArray, String[] stringArray2, File file, String string, boolean bl) {
        super(classLoader);
        String string2;
        String string3;
        this.protectionDomain = protectionDomain;
        this.applicationPackages = stringArray2;
        String string4 = string == null ? "" : string;
        String string5 = System.getProperty("os.name");
        if (string5.startsWith("Windows")) {
            string3 = ".dll";
            string2 = "";
        } else if (string5.startsWith("Mac OS X")) {
            string3 = ".jnilib";
            string2 = "lib";
        } else {
            string3 = ".so";
            string2 = "lib";
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = this.getResource(stringArray[i]);
            if (uRL == null) continue;
            arrayList.add(uRL);
        }
        if (uRLArray != null) {
            arrayList.addAll(Arrays.asList(uRLArray));
        }
        ArrayList<JarFile> arrayList2 = new ArrayList<JarFile>();
        for (int i = 0; i < arrayList.size(); ++i) {
            URL uRL = (URL)arrayList.get(i);
            try {
                Object object;
                Object object2;
                String string6;
                int n;
                long l;
                Object object3;
                String string7 = uRL.getFile();
                URLConnection uRLConnection = null;
                if (uRL.getProtocol().equals("jar")) {
                    URL uRL2 = new URL(string7.substring(0, string7.indexOf(33)));
                    object3 = uRL2.openConnection();
                    l = ((URLConnection)object3).getLastModified();
                    n = ((URLConnection)object3).getContentLength();
                    string6 = string7.substring(string7.indexOf(33) + 2);
                } else {
                    uRLConnection = uRL.openConnection();
                    l = uRLConnection.getLastModified();
                    n = uRLConnection.getContentLength();
                    string6 = string7;
                }
                int n2 = string6.lastIndexOf(47);
                boolean bl2 = string6.endsWith(".jar");
                if (bl2) {
                    object3 = null;
                } else {
                    if (!string6.endsWith(string3)) continue;
                    object3 = string6.substring(n2 + 1 + string2.length(), string6.length() - string3.length());
                }
                if (file != null && (!bl || bl2) && l != 0L && n != -1 && (file.exists() && file.isDirectory() || file.mkdirs())) {
                    try {
                        object2 = string4 + n + "-" + l / 1000L + "-" + string6.replace('/', '-');
                        object = new File(file, (String)object2);
                        if (!((File)object).exists() || ((File)object).lastModified() < l) {
                            if (uRLConnection == null) {
                                uRLConnection = uRL.openConnection();
                            }
                            this.copyInputStreamToFile(uRLConnection.getInputStream(), (File)object);
                        }
                        if (bl2) {
                            arrayList2.add(new JarFile(((File)object).toString(), false));
                            continue;
                        }
                        if (!string6.endsWith(string3)) continue;
                        this.extensionDlls.put(object3, ((File)object).toString());
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (uRLConnection == null) {
                    uRLConnection = uRL.openConnection();
                }
                object2 = uRLConnection.getInputStream();
                if (bl2) {
                    object = this.copyInputStreamToTmpFile((InputStream)object2, ".jar");
                    arrayList2.add(new JarFile((String)object, false));
                    continue;
                }
                if (!string6.endsWith(string3)) continue;
                object = this.copyInputStreamToTmpFile((InputStream)object2, string3);
                this.extensionDlls.put(object3, object);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't extract extension " + uRL, iOException);
            }
        }
        if (arrayList2.size() > 0) {
            this.extensionJars = arrayList2.toArray(new JarFile[arrayList2.size()]);
        }
    }

    private String copyInputStreamToTmpFile(InputStream inputStream, String string) throws IOException {
        File file = File.createTempFile("extension", string);
        file.deleteOnExit();
        this.copyInputStreamToFile(inputStream, file);
        return file.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInputStreamToFile(InputStream inputStream, File file) throws FileNotFoundException, IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Object object;
        Closeable closeable;
        String string2 = string.replace('.', '/') + ".class";
        InputStream inputStream = null;
        if (this.extensionJars != null) {
            for (int i = 0; i < this.extensionJars.length; ++i) {
                closeable = this.extensionJars[i];
                object = ((JarFile)closeable).getJarEntry(string2);
                if (object == null) continue;
                try {
                    inputStream = ((JarFile)closeable).getInputStream((ZipEntry)object);
                    continue;
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Couldn't read class " + string, iOException);
                }
            }
        }
        if (inputStream == null) {
            URL uRL = this.getResource(string2);
            if (uRL == null) {
                throw new ClassNotFoundException("Class " + string);
            }
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Couldn't read class " + string, iOException);
            }
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            closeable = new BufferedInputStream(inputStream);
            object = new byte[8192];
            while ((n = ((FilterInputStream)closeable).read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            ((BufferedInputStream)closeable).close();
            return this.defineClass(string, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), this.protectionDomain);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Class " + string, iOException);
        }
    }

    protected String findLibrary(String string) {
        return (String)this.extensionDlls.get(string);
    }

    protected URL findResource(String string) {
        if (this.extensionJars != null) {
            for (int i = 0; i < this.extensionJars.length; ++i) {
                JarFile jarFile = this.extensionJars[i];
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry == null) continue;
                try {
                    return new URL("jar:file:" + jarFile.getName() + "!/" + jarEntry.getName());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return super.findResource(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.extensionJars == null) {
            return super.loadClass(string, bl);
        }
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                for (int i = 0; i < this.applicationPackages.length; ++i) {
                    String string2 = this.applicationPackages[i];
                    int n = string2.length();
                    if ((n != 0 || string.indexOf(46) != 0) && (n <= 0 || !string.startsWith(string2))) continue;
                    clazz = this.findClass(string);
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = super.loadClass(string, bl);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

