/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.FileIterator;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveDeployment.LogPrefsDialog;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

class ShowLogFileDialog
extends JDialog {
    private final Root _root;
    private final FileIteratorFactory _factory;
    private int _maxLines;
    private int _maxSize;
    private int _initialLines;
    private int _maxReadSize;
    private int _period;
    private Action _play;
    private Action _pause;
    private Action _stop;
    private JRadioButtonMenuItem _playItem;
    private JRadioButtonMenuItem _pauseItem;
    private JRadioButtonMenuItem _stopItem;
    private JToggleButton _playButton;
    private JToggleButton _pauseButton;
    private JToggleButton _stopButton;
    private FIFOTextArea _textArea = new FIFOTextArea(20, 45);
    private ReaderThread _thread;
    private final Preferences _preferences;

    ShowLogFileDialog(Root root, FileIteratorFactory factory, int maxLines, int maxSize, int initialLines, int maxReadSize, int period) {
        super(root.getCoordinator().getMainFrame(), factory.getTitle() + " - IceGrid GUI", false);
        this._maxLines = maxLines;
        this._maxSize = maxSize;
        this._initialLines = initialLines;
        this._maxReadSize = maxReadSize;
        this._period = period;
        this._factory = factory;
        this._root = root;
        this._preferences = Coordinator.getPreferences().node("LiveDeployment");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowLogFileDialog.this.close(true);
            }
        });
        this._pause = new AbstractAction("Pause"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowLogFileDialog.this.pause();
            }
        };
        this._play = new AbstractAction("Play"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowLogFileDialog.this.play();
            }
        };
        this._stop = new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowLogFileDialog.this.stopReading();
            }
        };
        this.setJMenuBar(new MenuBar());
        this.getContentPane().add((Component)new ToolBar(), "First");
        JScrollPane scrollPane = new JScrollPane(this._textArea, 20, 31);
        this.getContentPane().add(scrollPane);
        this.setResizable(true);
        this.pack();
        Utils.restoreWindowBounds(this, this._preferences, "LogFileDialog", this._root.getCoordinator().getMainFrame());
        this.play();
    }

    void pause() {
        this._thread.pause();
        this._pauseItem.setSelected(true);
        this._pauseButton.setSelected(true);
    }

    void stopReading() {
        if (this._thread != null) {
            this._thread.terminate();
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._thread = null;
            this._stopItem.setSelected(true);
            this._stopButton.setSelected(true);
            this._pause.setEnabled(false);
        }
    }

    void play() {
        if (this._thread != null) {
            this._thread.play();
            this._playItem.setSelected(true);
            this._playButton.setSelected(true);
            this._pause.setEnabled(true);
        } else {
            this._thread = new ReaderThread();
            this._thread.start();
        }
    }

    int getMaxLines() {
        return this._maxLines;
    }

    int getMaxSize() {
        return this._maxSize;
    }

    int getInitialLines() {
        return this._initialLines;
    }

    int getMaxReadSize() {
        return this._maxReadSize;
    }

    int getPeriod() {
        return this._period;
    }

    void setPrefs(int maxLines, int maxSize, int initialLines, int maxReadSize, int period) {
        if (maxLines < 50) {
            maxLines = 50;
        }
        this._maxLines = maxLines;
        if (maxSize < 1000) {
            maxSize = 1000;
        }
        this._maxSize = maxSize;
        this._initialLines = initialLines;
        if (maxReadSize < 100) {
            maxReadSize = 100;
        } else if (maxReadSize + 512 > this._root.getMessageSizeMax()) {
            maxReadSize = this._root.getMessageSizeMax() - 512;
        }
        this._maxReadSize = maxReadSize;
        if (period < 200) {
            period = 200;
        } else if (period > 5000) {
            period = 5000;
        }
        this._period = period;
        if (this._thread != null) {
            this._thread.setPrefs();
        }
        this._root.setLogPrefs(this._maxLines, this._maxSize, this._initialLines, this._maxReadSize, this._period);
    }

    void close(boolean notifyRoot) {
        this.stopReading();
        if (notifyRoot) {
            this._root.removeShowLogFileDialog(this._factory.getTitle());
        }
        Utils.storeWindowBounds(this, this._preferences.node("LogFileDialog"));
        this.dispose();
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            ShowLogFileDialog.this._pauseButton = new JToggleButton(ShowLogFileDialog.this._pause);
            ShowLogFileDialog.this._pauseButton.setText(null);
            ShowLogFileDialog.this._pauseButton.setIcon(Utils.getIcon("/icons/16x16/pause.png"));
            this.add(ShowLogFileDialog.this._pauseButton);
            ShowLogFileDialog.this._playButton = new JToggleButton(ShowLogFileDialog.this._play);
            ShowLogFileDialog.this._playButton.setText(null);
            ShowLogFileDialog.this._playButton.setIcon(Utils.getIcon("/icons/16x16/start.png"));
            this.add(ShowLogFileDialog.this._playButton);
            ShowLogFileDialog.this._stopButton = new JToggleButton(ShowLogFileDialog.this._stop);
            ShowLogFileDialog.this._stopButton.setText(null);
            ShowLogFileDialog.this._stopButton.setIcon(Utils.getIcon("/icons/16x16/stop.png"));
            this.add(ShowLogFileDialog.this._stopButton);
            ButtonGroup bg = new ButtonGroup();
            bg.add(ShowLogFileDialog.this._pauseButton);
            bg.add(ShowLogFileDialog.this._playButton);
            bg.add(ShowLogFileDialog.this._stopButton);
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            this.add(fileMenu);
            ButtonGroup bg = new ButtonGroup();
            ShowLogFileDialog.this._pauseItem = new JRadioButtonMenuItem(ShowLogFileDialog.this._pause);
            fileMenu.add(ShowLogFileDialog.this._pauseItem);
            bg.add(ShowLogFileDialog.this._pauseItem);
            ShowLogFileDialog.this._playItem = new JRadioButtonMenuItem(ShowLogFileDialog.this._play);
            fileMenu.add(ShowLogFileDialog.this._playItem);
            bg.add(ShowLogFileDialog.this._playItem);
            ShowLogFileDialog.this._stopItem = new JRadioButtonMenuItem(ShowLogFileDialog.this._stop);
            fileMenu.add(ShowLogFileDialog.this._stopItem);
            bg.add(ShowLogFileDialog.this._stopItem);
            fileMenu.addSeparator();
            AbstractAction save = new AbstractAction("Save As..."){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser fileChooser = ShowLogFileDialog.this._root.getCoordinator().getSaveLogFileChooser();
                    fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), ShowLogFileDialog.this._factory.getDefaultFilename()));
                    File file = null;
                    while (file == null && (result = fileChooser.showSaveDialog(ShowLogFileDialog.this)) == 0) {
                        file = fileChooser.getSelectedFile();
                        if (file == null) continue;
                        if (!file.exists() && file.getName().indexOf(46) == -1) {
                            file = new File(file.getAbsolutePath() + ".log");
                        }
                        OutputStreamWriter os = null;
                        try {
                            os = new OutputStreamWriter(new FileOutputStream(file));
                            String txt = ShowLogFileDialog.this._textArea.getText();
                            if (txt == null) {
                                txt = "";
                            }
                            os.write(txt, 0, txt.length());
                        }
                        catch (IOException io) {
                            JOptionPane.showMessageDialog(ShowLogFileDialog.this, io.toString(), "Cannot write file", 0);
                        }
                        finally {
                            if (os == null) continue;
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
            save.putValue("ShortDescription", "Save As...");
            fileMenu.add(save);
            fileMenu.addSeparator();
            fileMenu.add(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowLogFileDialog.this.close(true);
                }
            });
            JMenu editMenu = new JMenu("Edit");
            editMenu.setMnemonic(69);
            this.add(editMenu);
            AbstractAction copy = new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowLogFileDialog.this._textArea.copy();
                }
            };
            copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_MASK));
            copy.putValue("ShortDescription", "Copy");
            editMenu.add(copy);
            editMenu.addSeparator();
            AbstractAction selectAll = new AbstractAction("Select All"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowLogFileDialog.this._textArea.grabFocus();
                    ShowLogFileDialog.this._textArea.selectAll();
                }
            };
            selectAll.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MENU_MASK));
            selectAll.putValue("ShortDescription", "Select All");
            editMenu.add(selectAll);
            editMenu.addSeparator();
            editMenu.add(new AbstractAction("Preferences..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new LogPrefsDialog(ShowLogFileDialog.this);
                }
            });
        }
    }

    private class ReaderThread
    extends Thread {
        private FileIteratorPrx _p;
        private boolean _done = false;
        private boolean _paused = false;
        private int _threadMaxLines;
        private int _threadMaxSize;
        private int _threadInitialLines;
        private int _threadMaxReadSize;
        private int _threadPeriod;

        ReaderThread() {
            this._threadMaxLines = ShowLogFileDialog.this._maxLines;
            this._threadMaxSize = ShowLogFileDialog.this._maxSize;
            this._threadInitialLines = ShowLogFileDialog.this._initialLines;
            this._threadMaxReadSize = ShowLogFileDialog.this._maxReadSize;
            this._threadPeriod = ShowLogFileDialog.this._period;
            ShowLogFileDialog.this._playButton.setSelected(true);
            ShowLogFileDialog.this._playItem.setSelected(true);
            ShowLogFileDialog.this._pause.setEnabled(true);
        }

        private void openError(String message) {
            SwingUtilities.invokeLater(() -> {
                if (ShowLogFileDialog.this._textArea.getText() == null || ShowLogFileDialog.this._textArea.getText().length() == 0) {
                    ShowLogFileDialog.this.close(true);
                } else {
                    ShowLogFileDialog.this.stopReading();
                }
                JOptionPane.showMessageDialog(ShowLogFileDialog.this, message, ShowLogFileDialog.this._factory.getTitle() + ": cannot open file", 0);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int initialLines;
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                initialLines = this._threadInitialLines;
            }
            try {
                this._p = ShowLogFileDialog.this._factory.open(initialLines);
            }
            catch (UserException e) {
                this.openError(e.toString());
                return;
            }
            catch (LocalException e) {
                this.openError(e.toString());
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (ShowLogFileDialog.this.isVisible()) {
                    ShowLogFileDialog.this._textArea.setText(null);
                } else {
                    ShowLogFileDialog.this.setVisible(true);
                }
            });
            boolean firstRun = true;
            block19: while (true) {
                ReaderThread readerThread2 = this;
                synchronized (readerThread2) {
                    if (!this._done) {
                        if (this._paused) {
                            while (this._paused && !this._done) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        } else if (!firstRun) {
                            try {
                                this.wait(this._threadPeriod);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            firstRun = false;
                        }
                    }
                    if (this._done) {
                        this.cleanupIterator();
                        return;
                    }
                }
                boolean eofEncountered = false;
                while (true) {
                    int maxReadSize;
                    int maxSize;
                    int maxLines;
                    if (eofEncountered) continue block19;
                    ReaderThread readerThread3 = this;
                    synchronized (readerThread3) {
                        if (this._done || this._paused) {
                            continue block19;
                        }
                        maxLines = this._threadMaxLines;
                        maxSize = this._threadMaxSize;
                        maxReadSize = this._threadMaxReadSize;
                    }
                    FileIterator.ReadResult r = null;
                    try {
                        r = this._p.read(maxReadSize);
                        eofEncountered = r.returnValue;
                    }
                    catch (FileNotAvailableException e) {
                        ShowLogFileDialog.this._textArea.appendLines(new String[]{"---------------------------", "IceGrid GUI caught: " + e.toString(), "---------------------------"}, maxLines, maxSize);
                        SwingUtilities.invokeLater(() -> ShowLogFileDialog.this.stopReading());
                        this.cleanupIterator();
                        return;
                    }
                    catch (LocalException e) {
                        ShowLogFileDialog.this._textArea.appendLines(new String[]{"---------------------------", "IceGrid GUI caught: " + e.toString(), "---------------------------"}, maxLines, maxSize);
                        SwingUtilities.invokeLater(() -> ShowLogFileDialog.this.stopReading());
                        return;
                    }
                    ShowLogFileDialog.this._textArea.appendLines(r.lines, maxLines, maxSize);
                }
                break;
            }
        }

        private void cleanupIterator() {
            try {
                this._p.destroy();
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }

        synchronized void pause() {
            if (!this._paused) {
                this._paused = true;
                this.notify();
            }
        }

        synchronized void terminate() {
            if (!this._done) {
                this._done = true;
                this.notify();
            }
        }

        synchronized void play() {
            if (this._paused) {
                this._paused = false;
                this.notify();
            }
        }

        synchronized void setPrefs() {
            this._threadMaxLines = ShowLogFileDialog.this._maxLines;
            this._threadMaxSize = ShowLogFileDialog.this._maxSize;
            this._threadInitialLines = ShowLogFileDialog.this._initialLines;
            this._threadMaxReadSize = ShowLogFileDialog.this._maxReadSize;
            this._threadPeriod = ShowLogFileDialog.this._period;
        }
    }

    private class FIFOTextArea
    extends JTextArea {
        FIFOTextArea(int rows, int colums) {
            super(rows, colums);
            this.setEditable(false);
            this.setLineWrap(true);
        }

        void appendLines(String[] lines, int maxLines, int maxSize) {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < lines.length; ++i) {
                    if (i + 1 != lines.length) {
                        this.append(lines[i] + "\n");
                    } else {
                        this.append(lines[i]);
                    }
                    this.removeLines(maxLines, maxSize);
                }
            });
        }

        void removeLines(int maxLines, int maxSize) {
            Document doc = this.getDocument();
            Element rootElt = doc.getDefaultRootElement();
            for (int lineCount = this.getLineCount(); lineCount > 1 && (doc.getLength() > maxSize || lineCount > maxLines); --lineCount) {
                Element firstLine = rootElt.getElement(0);
                try {
                    doc.remove(0, firstLine.getEndOffset());
                    continue;
                }
                catch (BadLocationException ble) {
                    assert (false);
                    continue;
                }
            }
            this.setCaretPosition(doc.getLength());
        }
    }

    static interface FileIteratorFactory {
        public FileIteratorPrx open(int var1) throws UserException;

        public String getTitle();

        public String getDefaultFilename();
    }
}

