############################################################################
##
#W  uea.gd                  QuaGroup                          Willem de Graaf
##
##
##  Declarations for universal enveloping algebras corresponding to 
##  quantized enveloping algebras.
##

##############################################################################
##
#A  UEA( <L> )
##
##  Universal enveloping algebra of <L>, generated by the generators of a 
##  Kostant lattice.
##
DeclareAttribute( "UEA", IsLieAlgebra );

##############################################################################
##
#C  IsQUEAtoUEAmap( <map> )
##
##  for maps from U_q to U...
##
DeclareCategory( "IsQUEAtoUEAmap", IsAlgebraGeneralMapping and IsTotal and 
                                      IsSingleValued );

##############################################################################
##
#A  QUEAToUEAMap( <L> )
##
##  Is the (canonical) map from U_q to U.
##
DeclareAttribute( "QUEAToUEAMap", IsLieAlgebra );

##############################################################################
##
#A  UnderlyingLieAlgebra( <U> )
##
##  For a universal enveloping algebra, this gives the corresponding Lie
##  algebra.
##
DeclareAttribute( "UderlyingLieAlgebra", IsMagmaRingModuloRelations );
