/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.UseTable;
import org.jmol.export.__RayTracerExporter;
import org.jmol.util.GData;
import org.jmol.viewer.Viewer;

public class _TachyonExporter
extends __RayTracerExporter {
    String lighting;
    String phong;
    UseTable textures = new UseTable(" ");
    private String textureCode;

    public _TachyonExporter() {
        this.commentChar = "# ";
    }

    @Override
    boolean initializeOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.getLightingInfo();
        return this.initOutput(viewer, d, gData, map);
    }

    private void getLightingInfo() {
        this.lighting = " AMBIENT " + _TachyonExporter.round((float)this.gdata.getAmbientPercent() / 100.0f) + " DIFFUSE " + _TachyonExporter.round((float)this.gdata.getDiffusePercent() / 100.0f) + " SPECULAR " + _TachyonExporter.round((float)this.gdata.getSpecularPercent() / 100.0f);
        this.phong = " Phong Plastic 0.5 Phong_size " + this.gdata.getSpecularExponent();
    }

    @Override
    protected void outputHeader() {
        this.initVars();
        this.output("# ******************************************************\n");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("#\n");
        this.output("# This script was generated on " + this.getExportDate() + "\n");
        this.output("#\n");
        this.output("# Requires Tachyon version 0.98.7 or newer\n");
        this.output("#\n");
        this.output("# Default tachyon rendering command for this scene:\n");
        this.output("#   tachyon  -aasamples 12 %s -format TARGA -o %s.tga\n");
        this.output("#\n");
        this.output("# ******************************************************\n");
        this.output("\n");
        this.output(this.getJmolPerspective());
        this.output("\n");
        this.output("Begin_Scene\n");
        this.output("Resolution " + this.screenWidth + " " + this.screenHeight + "\n");
        this.output("Shader_Mode Medium\n");
        this.output("  Trans_VMD\n");
        this.output("  Fog_VMD\n");
        this.output("End_Shader_Mode\n");
        this.output("Camera\n");
        this.output("  Zoom 3.0\n");
        this.output("  Aspectratio 1\n");
        this.output("  Antialiasing 12\n");
        this.output("  Raydepth 8\n");
        this.output("  Center " + this.triad(this.screenWidth / 2, this.screenHeight / 2, 0.0f) + "\n");
        this.output("  Viewdir 0 0 1\n");
        this.output("  Updir   0 1 0\n");
        this.output("End_Camera\n");
        this.output("Directional_Light Direction " + _TachyonExporter.round(this.lightSource) + " Color 1 1 1\n");
        this.output("\n");
        this.output("Background " + this.rgbFractionalFromColix(this.backgroundColix) + "\n");
        this.output("\n");
    }

    @Override
    protected void outputFooter() {
        this.output("End_Scene\n");
    }

    @Override
    protected void output(T3 t3) {
        this.output(this.triad(t3));
    }

    private String triad(float f, float f2, float f3) {
        return String.valueOf((int)f) + " " + (int)(-f2) + " " + (int)f3;
    }

    private String triad(T3 t3) {
        if (Float.isNaN(t3.x)) {
            return "0 0 0";
        }
        return this.triad(t3.x, t3.y, t3.z);
    }

    private void outputTextureCode() {
        this.output(this.textureCode);
        this.output("\n");
    }

    private void outputTexture(short s, boolean bl) {
        this.outputTexture2(this.rgbFractionalFromColix(s), _TachyonExporter.opacityFractionalFromColix(s), bl);
    }

    private void outputTexture(int n, boolean bl) {
        this.outputTexture2(this.rgbFractionalFromArgb(n), _TachyonExporter.opacityFractionalFromArgb(n), bl);
    }

    private void outputTexture2(String string, String string2, boolean bl) {
        String string3 = this.textureCode = bl ? this.textures.getDef("t" + string + string2) : null;
        if (bl && this.textureCode.startsWith(" ")) {
            return;
        }
        SB sB = new SB();
        sB.append(this.lighting);
        sB.append(" Opacity " + string2);
        sB.append(this.phong);
        sB.append(" Color " + string);
        sB.append(" TexFunc 0\n");
        if (!bl) {
            this.textureCode = "Texture " + sB;
            return;
        }
        this.output("TexDef " + this.textureCode);
        this.output(sB.toString());
        this.textureCode = " " + this.textureCode;
    }

    @Override
    protected void outputCircle(int n, int n2, int n3, float f, short s, boolean bl) {
        this.tempV1.set(0.0f, 0.0f, -1.0f);
        this.outputRing(n, n2, n3, this.tempV1, f, s, bl);
    }

    private void outputRing(int n, int n2, int n3, V3 v3, float f, short s, boolean bl) {
        this.outputTexture(s, true);
        this.output("Ring Center ");
        this.output(this.triad(n, n2, n3));
        this.output(" Normal " + this.triad(v3));
        this.output(" Inner " + _TachyonExporter.round(bl ? 0.0 : (double)f * 0.95));
        this.output(" Outer " + _TachyonExporter.round(f));
        this.outputTextureCode();
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s, boolean bl) {
        this.tm.unTransformPoint(p3, this.tempP1);
        this.tm.unTransformPoint(p32, this.tempP2);
        f = this.vwr.tm.unscaleToScreen(p3.z, f);
        M3 m3 = this.getRotationMatrix(this.tempP1, this.tempP2, f);
        this.export3D.drawSurface(_TachyonExporter.getConeMesh(this.tempP1, m3, s), s);
    }

    @Override
    protected void outputCylinder(P3 p3, P3 p32, float f, short s, boolean bl) {
        this.outputTexture(s, true);
        this.output("FCylinder Base ");
        this.output(this.triad(p3));
        this.output(" Apex ");
        this.output(this.triad(p32));
        this.output(" Rad " + _TachyonExporter.round(f));
        this.outputTextureCode();
        if (bl && f > 1.0f) {
            this.tempV1.sub2(p3, p32);
            this.outputRing((int)p3.x, (int)p3.y, (int)p3.z, this.tempV1, f, s, true);
            this.tempV1.scale(-1.0f);
            this.outputRing((int)p32.x, (int)p32.y, (int)p32.z, this.tempV1, f, s, true);
        }
    }

    @Override
    protected void fillConicalCylinder(P3 p3, P3 p32, int n, short s, byte by) {
        int n2 = (int)this.vwr.tm.scaleToScreen((int)((p3.z + p32.z) / 2.0f), n);
        this.fillCylinderScreenMad(s, by, n2, p3, p32);
    }

    @Override
    protected void outputCylinderConical(P3 p3, P3 p32, float f, float f2, short s) {
    }

    @Override
    protected void outputEllipsoid(P3 p3, float f, double[] dArray, short s) {
        this.tm.transformPt3f(p3, this.tempP1);
        this.outputSphere(this.tempP1.x, this.tempP1.y, this.tempP1.z, f, s);
    }

    @Override
    protected void outputSurface(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        int n5;
        if (sArray2 != null) {
            int n6;
            boolean bl = bS == null;
            int n7 = n6 = bl ? n2 - 1 : bS.nextSetBit(0);
            while (n7 >= 0) {
                _TachyonExporter.setTempVertex(t3Array[nArray[n7][0]], p3, this.tempP1);
                _TachyonExporter.setTempVertex(t3Array[nArray[n7][1]], p3, this.tempP2);
                _TachyonExporter.setTempVertex(t3Array[nArray[n7][2]], p3, this.tempP3);
                this.tm.transformPt3f(this.tempP1, this.tempP1);
                this.tm.transformPt3f(this.tempP2, this.tempP2);
                this.tm.transformPt3f(this.tempP3, this.tempP3);
                this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, s);
                int n8 = n7 = bl ? n7 - 1 : bS.nextSetBit(n7 + 1);
            }
            return;
        }
        this.outputTexture(sArray == null ? s : sArray[0], false);
        this.output("VertexArray  Numverts " + n + "\nCoords\n");
        int n9 = 0;
        while (n9 < n) {
            this.outputVertex(t3Array[n9], p3);
            ++n9;
        }
        this.output("\nNormals\n");
        n9 = 0;
        while (n9 < n) {
            _TachyonExporter.setTempVertex(t3Array[n9], p3, this.tempP1);
            this.output(String.valueOf(this.triad(this.getScreenNormal(this.tempP1, t3Array2[n9], 10.0f))) + "\n");
            ++n9;
        }
        String string = sArray == null ? this.rgbFractionalFromColix(s) : null;
        this.output("\nColors\n");
        int n10 = 0;
        while (n10 < n) {
            this.output(String.valueOf(sArray == null ? string : this.rgbFractionalFromColix(sArray[n10])) + "\n");
            ++n10;
        }
        this.outputTextureCode();
        this.output("\nTriMesh " + n3 + "\n");
        n10 = bS == null ? 1 : 0;
        int n11 = n5 = n10 != 0 ? n2 - 1 : bS.nextSetBit(0);
        while (n11 >= 0) {
            this.output(String.valueOf(nArray[n11][0]) + " " + nArray[n11][1] + " " + nArray[n11][2] + "\n");
            if (n4 == 4 && nArray[n11].length == 4) {
                this.output(String.valueOf(nArray[n11][0]) + " " + nArray[n11][2] + " " + nArray[n11][3] + "\n");
            }
            int n12 = n11 = n10 != 0 ? n11 - 1 : bS.nextSetBit(n11 + 1);
        }
        this.output("\nEnd_VertexArray\n");
    }

    @Override
    protected void outputSphere(float f, float f2, float f3, float f4, short s) {
        this.outputTexture(s, true);
        this.output("Sphere Center ");
        this.output(this.triad(f, f2, f3));
        this.output(" Rad " + _TachyonExporter.round(f4));
        this.outputTextureCode();
    }

    @Override
    protected void outputTextPixel(int n, int n2, int n3, int n4) {
        this.outputTexture(n4, true);
        this.output("Sphere Center ");
        this.output(this.triad(n, n2, n3));
        this.output(" Rad 1");
        this.outputTextureCode();
    }

    @Override
    protected void outputTriangle(T3 t3, T3 t32, T3 t33, short s) {
        this.outputTexture(s, true);
        this.output("TRI");
        this.output(" V0 " + this.triad(t3));
        this.output(" V1 " + this.triad(t32));
        this.output(" V2 " + this.triad(t33));
        this.outputTextureCode();
    }
}

