/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dipole {
    String thisID = "";
    public short mad;
    public short colix = 0;
    short type;
    public P3 origin;
    public P3 center;
    public V3 vector;
    String dipoleInfo = "";
    public float dipoleValue;
    boolean isUserValue;
    public float offsetSide;
    public float offsetAngstroms;
    public P3 offsetPt;
    int offsetPercent;
    public int visibilityFlags;
    int modelIndex;
    boolean visible;
    public boolean noCross;
    boolean haveAtoms;
    boolean isValid;
    public Atom[] atoms = new Atom[2];
    P3[] coords = new P3[2];
    public Bond bond;
    public BS bsMolecule;
    public Lst<Object> lstDipoles;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole init(int modelIndex, String thisID, String dipoleInfo, short colix, short mad, boolean visible) {
        this.modelIndex = modelIndex;
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.colix = colix;
        this.mad = mad;
        this.visible = visible;
        this.type = 0;
        return this;
    }

    void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colix = C.getColixTranslucent3((short)this.colix, (boolean)isTranslucent, (float)translucentLevel);
    }

    void set(Dipole d) {
        this.thisID = d.thisID;
        this.dipoleInfo = d.dipoleInfo;
        this.dipoleValue = d.dipoleValue;
        this.mad = d.mad;
        this.lstDipoles = d.lstDipoles;
        if (this.lstDipoles != null) {
            this.isValid = true;
        }
        this.offsetAngstroms = d.offsetAngstroms;
        this.offsetPercent = d.offsetPercent;
        this.offsetSide = d.offsetSide;
        this.vector = V3.newV((T3)d.vector);
        this.origin = P3.newP((T3)d.origin);
        if (d.offsetPt != null) {
            this.origin.add((T3)d.offsetPt);
            this.offsetPt = P3.newP((T3)d.offsetPt);
        }
        this.bsMolecule = d.bsMolecule;
        boolean bl = this.haveAtoms = d.atoms[0] != null;
        if (this.haveAtoms) {
            this.atoms[0] = d.atoms[0];
            this.atoms[1] = d.atoms[1];
            this.centerDipole();
        } else {
            this.center = null;
        }
    }

    private void set2(P3 pt1, P3 pt2) {
        this.coords[0] = P3.newP((T3)pt1);
        this.coords[1] = P3.newP((T3)pt2);
        boolean bl = this.isValid = this.coords[0].distance((T3)this.coords[1]) > 0.1f;
        if (this.dipoleValue < 0.0f) {
            this.origin = P3.newP((T3)pt2);
            this.vector = V3.newV((T3)pt1);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = P3.newP((T3)pt1);
            this.vector = V3.newV((T3)pt2);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub((T3)this.origin);
        if (this.dipoleValue == 0.0f) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void setValue(float value) {
        float d = this.dipoleValue;
        this.dipoleValue = value;
        if (value == 0.0f) {
            this.isValid = false;
        }
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (d * this.dipoleValue < 0.0f) {
            this.origin.sub((T3)this.vector);
        }
    }

    void set2Value(P3 pt1, P3 pt2, float value) {
        this.dipoleValue = value;
        this.atoms[0] = null;
        this.set2(pt1, pt2);
    }

    void setPtVector(P3 pt1, V3 dipole) {
        this.setValue(dipole.length());
        P3 pt2 = P3.newP((T3)pt1);
        pt2.add((T3)dipole);
        this.set2(pt1, pt2);
        this.type = (short)5;
    }

    void set2AtomValue(Atom atom1, Atom atom2, float value) {
        this.setValue(value);
        this.set2((P3)atom1, (P3)atom2);
        this.offsetSide = 0.4f;
        this.mad = (short)10;
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.haveAtoms = true;
        this.centerDipole();
    }

    void centerDipole() {
        boolean bl = this.isValid = this.atoms[0] != this.atoms[1] && this.dipoleValue != 0.0f;
        if (!this.isValid) {
            return;
        }
        float f = this.atoms[0].distance((T3)this.atoms[1]) / (2.0f * this.dipoleValue) - 0.5f;
        this.origin.scaleAdd2(f, (T3)this.vector, (T3)this.atoms[0]);
        this.center = new P3();
        this.center.scaleAdd2(0.5f, (T3)this.vector, (T3)this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }

    public String getShapeState() {
        if (!this.isValid) {
            return "";
        }
        SB s = new SB();
        s.append("dipole ID ").append(this.thisID);
        if (this.lstDipoles != null) {
            s.append(" all ").append(Escape.eBS((BS)this.bsMolecule));
        } else if (this.haveAtoms) {
            s.append(" ({").appendI(this.atoms[0].i).append("}) ({").appendI(this.atoms[1].i).append("})");
        } else {
            if (this.coords[0] == null) {
                return "";
            }
            s.append(" ").append(Escape.eP((T3)this.coords[0])).append(" ").append(Escape.eP((T3)this.coords[1]));
        }
        if (this.isUserValue) {
            s.append(" value ").appendF(this.dipoleValue);
        }
        if (this.mad != 10) {
            s.append(" width ").appendF((float)this.mad / 1000.0f);
        }
        if (this.offsetAngstroms != 0.0f) {
            s.append(" offset ").appendF(this.offsetAngstroms);
        } else if (this.offsetPercent != 0) {
            s.append(" offset ").appendI(this.offsetPercent);
        }
        if (this.offsetSide != 0.4f) {
            s.append(" offsetSide ").appendF(this.offsetSide);
        }
        if (this.offsetPt != null) {
            s.append(" offset ").append(Escape.eP((T3)this.offsetPt));
        }
        if (this.noCross) {
            s.append(" nocross");
        }
        if (!this.visible) {
            s.append(" off");
        }
        s.append(";\n");
        return s.toString();
    }

    public void setOffsetPt(P3 pt) {
        if (this.offsetPt != null) {
            this.origin.sub((T3)this.offsetPt);
        }
        this.offsetPt = pt;
        this.origin.add((T3)pt);
    }
}

