/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;

public class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();
    private ExecutionEnvironmentProfileProvider profileProvider = ExecutionEnvironmentProfileProvider.getInstance();

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean accept(Resource res) {
        if (res == null || res.getName() == null || res.getName().trim().equals("")) {
            return false;
        }
        return res.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        Manifest m = new Manifest(res.openStream());
        BundleInfo bundleInfo = ManifestParser.parseManifest(m);
        try {
            bundleInfo.addArtifact(new BundleArtifact(false, new URI(res.getName()), null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", e);
        }
        return BundleInfoAdapter.toModuleDescriptor(this, null, bundleInfo, m, this.profileProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(md, destFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, boolean validate) throws ParseException, IOException {
        URLResource resource = new URLResource(descriptorURL);
        return this.parseDescriptor(ivySettings, descriptorURL, resource, validate);
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId mrid, Resource res) {
        return DefaultArtifact.newIvyArtifact(mrid, new Date(res.getLastModified()));
    }

    public String toString() {
        return "manifest parser";
    }
}

