/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NioImageBuffer;

class ImageComponent2DRetained
extends ImageComponentRetained {
    ImageComponent2DRetained() {
    }

    void set(NioImageBuffer nioImageBuffer) {
        int n = nioImageBuffer.getWidth();
        int n2 = nioImageBuffer.getHeight();
        if (!this.byReference) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D7"));
        }
        if (!this.yUp) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D8"));
        }
        if (n != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n2 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.geomLock.getLock();
        this.setImageClass(nioImageBuffer);
        this.setRefImage(nioImageBuffer, 0);
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(nioImageBuffer);
        if (this.imageTypeIsSupported) {
            this.imageData = this.createNioImageBufferDataObject(nioImageBuffer);
        } else {
            this.imageData = this.createNioImageBufferDataObject(null);
            this.copyUnsupportedNioImageToImageData(nioImageBuffer, 0, 0, 0, 0, n, n2, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(RenderedImage renderedImage) {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        if (n != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n2 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        this.setImageClass(renderedImage);
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(renderedImage, 0);
        }
        this.abgrSupported = true;
        this.imageTypeIsSupported = this.isImageTypeSupported(renderedImage);
        if (this.imageTypeIsSupported) {
            if (this.byReference && this.yUp) {
                this.imageData = renderedImage instanceof BufferedImage ? this.createRenderedImageDataObject(renderedImage) : null;
            } else {
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(renderedImage, 0, this.imageData);
            }
        } else {
            this.imageData = this.createRenderedImageDataObject(null);
            this.copyUnsupportedImageToImageData(renderedImage, 0, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void setSubImage(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isSubImageTypeEqual(renderedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n3, n4, n5, n6, 0, n, n2, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n3, n4, n5, n6, 0, n, n2, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n3, n4, n5, n6, 0, n, n2, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n3, n4, n5, n6, 0, n, n2, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n5;
            imageComponentUpdateInfo.y = n6;
            imageComponentUpdateInfo.z = 0;
            imageComponentUpdateInfo.width = n;
            imageComponentUpdateInfo.height = n2;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    RenderedImage getImage() {
        if (this.isByReference()) {
            return (RenderedImage)this.getRefImage(0);
        }
        if (this.imageData != null) {
            return this.imageData.createBufferedImage(0);
        }
        return null;
    }

    NioImageBuffer getNioImage() {
        if (this.getImageClass() != ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D9"));
        }
        assert (this.byReference);
        return (NioImageBuffer)this.getRefImage(0);
    }

    void updateData(ImageComponent2D.Updater updater, int n, int n2, int n3, int n4) {
        Object object;
        this.geomLock.getLock();
        updater.updateData((ImageComponent2D)this.source, n, n2, n3, n4);
        Object object2 = this.getRefImage(0);
        assert (object2 != null);
        assert (this.imageData != null);
        if (!this.imageData.isDataByRef()) {
            if (this.imageTypeIsSupported) {
                assert (!(object2 instanceof NioImageBuffer));
                if (object2 instanceof BufferedImage) {
                    this.copyImageLineByLine((BufferedImage)object2, n, n2, n, n2, 0, n3, n4, this.imageData);
                } else {
                    object = (RenderedImage)object2;
                    this.copySupportedImageToImageData((RenderedImage)object, n + object.getMinX(), n2 + object.getMinY(), n, n2, 0, n3, n4, this.imageData);
                }
            } else if (object2 instanceof BufferedImage) {
                this.copyUnsupportedImageToImageData((BufferedImage)object2, n, n2, n, n2, 0, n3, n4, this.imageData);
            } else if (object2 instanceof RenderedImage) {
                object = (RenderedImage)object2;
                this.copyUnsupportedImageToImageData((RenderedImage)object, n + object.getMinX(), n2 + object.getMinY(), n, n2, 0, n3, n4, this.imageData);
            } else if (object2 instanceof NioImageBuffer) {
                this.copyUnsupportedNioImageToImageData((NioImageBuffer)object2, n, n2, n, n2, n3, n4, this.imageData);
            } else assert (false);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            object = new ImageComponentUpdateInfo();
            ((ImageComponentUpdateInfo)object).x = n;
            ((ImageComponentUpdateInfo)object).y = n2;
            ((ImageComponentUpdateInfo)object).z = 0;
            ((ImageComponentUpdateInfo)object).width = n3;
            ((ImageComponentUpdateInfo)object).height = n4;
            this.sendMessage(2, object);
        }
    }

    void clearLive(int n) {
        super.clearLive(n);
    }
}

