#ifndef _EFL_UI_POPUP_ALERT_EO_H_
#define _EFL_UI_POPUP_ALERT_EO_H_

#ifndef _EFL_UI_POPUP_ALERT_EO_CLASS_TYPE
#define _EFL_UI_POPUP_ALERT_EO_CLASS_TYPE

typedef Eo Efl_Ui_Popup_Alert;

#endif

#ifndef _EFL_UI_POPUP_ALERT_EO_TYPES
#define _EFL_UI_POPUP_ALERT_EO_TYPES

/** Defines the type of the alert button.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_POPUP_ALERT_BUTTON_POSITIVE = 0, /**< Button having positive meaning.
                                           * e.g. "Yes" */
  EFL_UI_POPUP_ALERT_BUTTON_NEGATIVE, /**< Button having negative meaning. e.g.
                                       * "No" */
  EFL_UI_POPUP_ALERT_BUTTON_USER /**< Button having user-defined meaning. e.g.
                                  * "Cancel" */
} Efl_Ui_Popup_Alert_Button;

/** Information of clicked event
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Popup_Alert_Button_Clicked_Event
{
  Efl_Ui_Popup_Alert_Button button_type; /**< Clicked button type */
} Efl_Ui_Popup_Alert_Button_Clicked_Event;


#endif
/** EFL UI Popup Alert class
 *
 * @ingroup Efl_Ui_Popup_Alert
 */
#define EFL_UI_POPUP_ALERT_CLASS efl_ui_popup_alert_class_get()

EWAPI const Efl_Class *efl_ui_popup_alert_class_get(void);

/**
 * @brief Set popup buttons.
 *
 * @param[in] obj The object.
 * @param[in] type Alert popup button type
 * @param[in] text Alert string on button
 *
 * @ingroup Efl_Ui_Popup_Alert
 */
EOAPI void efl_ui_popup_alert_button_set(Eo *obj, Efl_Ui_Popup_Alert_Button type, const char *text);

EWAPI extern const Efl_Event_Description _EFL_UI_POPUP_ALERT_EVENT_BUTTON_CLICKED;

/** Called when alert popup was clicked
 * @return Efl_Ui_Popup_Alert_Button_Clicked_Event
 *
 * @ingroup Efl_Ui_Popup_Alert
 */
#define EFL_UI_POPUP_ALERT_EVENT_BUTTON_CLICKED (&(_EFL_UI_POPUP_ALERT_EVENT_BUTTON_CLICKED))

#endif
