/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.preferences.LsofParameterType;
import net.sourceforge.glsof.common.preferences.PathCommandDialog;
import net.sourceforge.glsof.common.utils.GBC;
import net.sourceforge.glsof.common.utils.GCheckBox;

class DirectoryCommandDialog
extends PathCommandDialog {
    protected JCheckBox _fullDescentTreeButton;
    protected JCheckBox _linksButton;
    protected JCheckBox _mountPointsButton;

    public DirectoryCommandDialog(LsofParameterType type) {
        super(type);
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        parent.setLayout(new GridBagLayout());
        super.createDialogArea(parent);
        this._fullDescentTreeButton = GCheckBox.createCheckBox(Messages.NLS("Full_descent_tree"), this.getTip("_full_descent_tree"));
        parent.add((Component)this._fullDescentTreeButton, new GBC().gridx(1).gridy(1).anchor(17).gridwidth(2).insets(new Insets(5, 5, 5, 5)).get());
        this._mountPointsButton = GCheckBox.createCheckBox(Messages.NLS("Follow_file_system_mount_points"), this.getTip("_mount_points"));
        parent.add((Component)this._mountPointsButton, new GBC().gridx(1).gridy(2).anchor(17).gridwidth(2).insets(new Insets(5, 5, 5, 5)).get());
        this._linksButton = GCheckBox.createCheckBox(Messages.NLS("Follow_symbolic_links"), this.getTip("_symbolic_links"));
        parent.add((Component)this._linksButton, new GBC().gridx(1).gridy(3).anchor(17).gridwidth(2).insets(new Insets(5, 5, 5, 5)).get());
    }

    @Override
    public void copyValuesInTheMask(Filter filter) {
        List<String> values = filter.getValues();
        this._directory.setText(values.get(0));
        this._fullDescentTreeButton.setSelected(Boolean.valueOf(values.get(1)));
        this._mountPointsButton.setSelected(Boolean.valueOf(values.get(2)));
        this._linksButton.setSelected(Boolean.valueOf(values.get(3)));
    }

    @Override
    protected List<String> getModelFilterValuesFromTheMask() {
        return Arrays.asList(this._directory.getText().trim(), String.valueOf(this._fullDescentTreeButton.isSelected()), String.valueOf(this._mountPointsButton.isSelected()), String.valueOf(this._linksButton.isSelected()));
    }
}

