/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools.ico.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.jnlp.tools.ico.impl.IcoException;
import net.sourceforge.jnlp.tools.ico.impl.IcoHeader;
import net.sourceforge.jnlp.tools.ico.impl.IcoHeaderEntry;

public class ImageInputStreamIco {
    private final IcoHeader header;
    private final List<BufferedImage> images;

    public IcoHeader getHeader() {
        return this.header;
    }

    public BufferedImage getImage(int i) {
        return this.images.get(i);
    }

    public ImageInputStreamIco(ImageInputStream src) throws IOException, IcoException {
        this.header = new IcoHeader(src);
        this.images = new ArrayList<BufferedImage>(this.header.countOfIcons);
        for (IcoHeaderEntry e : this.header.entries) {
            BufferedImage image = ImageInputStreamIco.readImage(e, src);
            this.images.add(image);
        }
    }

    public List<BufferedImage> getImages() {
        return Collections.unmodifiableList(this.images);
    }

    private static void readMask(IcoHeaderEntry e, ImageInputStream src1) throws IOException {
    }

    private static BufferedImage readImage(IcoHeaderEntry e, ImageInputStream src1) throws IOException {
        BufferedImage image;
        byte[] img = new byte[e.getSizeInBytes()];
        if (src1.getStreamPosition() != (long)e.getFileOffset()) {
            // empty if block
        }
        src1.readFully(img);
        try {
            image = ImageInputStreamIco.parse(img, e);
        }
        catch (EOFException ex) {
            if (e.getColorCount() != 0) {
                e.setColorCount(0);
                image = ImageInputStreamIco.parse(img, e);
            }
            throw ex;
        }
        return image;
    }

    private static BufferedImage parse(byte[] img, IcoHeaderEntry e) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(img);
        BufferedImage image = null;
        try {
            image = ImageIO.read(bis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null) {
            ImageInputStreamIco.fixSizesInHeader(e, image);
            return image;
        }
        img = ImageInputStreamIco.prefixByFakeHeader(img, e);
        bis = new ByteArrayInputStream(img);
        image = ImageIO.read(bis);
        return image;
    }

    private static void fixSizesInHeader(IcoHeaderEntry e, BufferedImage image) {
        if (e.getWidth() == 0) {
            e.setWidth(image.getWidth());
        }
        if (e.getHeight() == 0) {
            e.setHeight(image.getHeight());
        }
    }

    private static byte[] prefixByFakeHeader(byte[] origArray, IcoHeaderEntry e) {
        int fakingArray = 14;
        byte[] img = new byte[fakingArray + e.getSizeInBytes()];
        for (int i = 0; i < origArray.length; ++i) {
            byte p;
            img[i + 14] = p = origArray[i];
        }
        int size = e.getSizeInBytes() + fakingArray;
        img[0] = 66;
        img[1] = 77;
        img[2] = (byte)(size & 0xFF);
        img[3] = (byte)(size >> 8 & 0xFF);
        img[4] = (byte)(size >> 16 & 0xFF);
        img[5] = (byte)(size >> 24 & 0xFF);
        img[6] = 0;
        img[7] = 0;
        img[8] = 0;
        img[9] = 0;
        int ofset = fakingArray + 40 + 4 * e.getColorCount();
        img[10] = (byte)(ofset & 0xFF);
        img[11] = (byte)(ofset >> 8 & 0xFF);
        img[12] = (byte)(ofset >> 16 & 0xFF);
        img[13] = (byte)(ofset >> 24 & 0xFF);
        int tmpHeight = e.getHeight();
        img[fakingArray + 4 + 4] = (byte)(tmpHeight & 0xFF);
        img[fakingArray + 4 + 4 + 1] = (byte)(tmpHeight >> 8 & 0xFF);
        img[fakingArray + 4 + 4 + 2] = (byte)(tmpHeight >> 16 & 0xFF);
        img[fakingArray + 4 + 4 + 3] = (byte)(tmpHeight >> 24 & 0xFF);
        return img;
    }
}

