/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import gnu.mail.providers.imap.IMAPBodyPart;
import gnu.mail.providers.imap.IMAPMessage;
import gnu.mail.providers.imap.IMAPMultipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public class IMAPMultipartDataSource
implements MultipartDataSource {
    protected IMAPMultipart multipart;

    protected IMAPMultipartDataSource(IMAPMultipart multipart) {
        this.multipart = multipart;
    }

    public String getName() {
        try {
            return this.multipart.getParent().getDescription();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getContentType() {
        try {
            return this.multipart.getParent().getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            Part part = this.multipart.getParent();
            if (part instanceof IMAPBodyPart) {
                return ((IMAPBodyPart)part).getContentStream();
            }
            if (part instanceof IMAPMessage) {
                return ((IMAPMessage)part).getContentStream();
            }
            throw new IOException("Internal error in part structure");
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new ProtocolException("IMAP multiparts are read-only");
    }

    public BodyPart getBodyPart(int index) throws MessagingException {
        return this.multipart.getBodyPart(index);
    }

    public int getCount() {
        try {
            return this.multipart.getCount();
        }
        catch (MessagingException e) {
            return 0;
        }
    }
}

