/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;

public abstract class Store
extends Service {
    private ArrayList storeListeners = null;
    private ArrayList folderListeners = null;

    protected Store(Session session, URLName url) {
        super(session, url);
    }

    public abstract Folder getDefaultFolder() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract Folder getFolder(URLName var1) throws MessagingException;

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Folder[] folders = new Folder[]{this.getDefaultFolder()};
        return folders;
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        return new Folder[0];
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return new Folder[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoreListener(StoreListener l) {
        if (this.storeListeners == null) {
            this.storeListeners = new ArrayList();
        }
        ArrayList arrayList = this.storeListeners;
        synchronized (arrayList) {
            this.storeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoreListener(StoreListener l) {
        if (this.storeListeners != null) {
            ArrayList arrayList = this.storeListeners;
            synchronized (arrayList) {
                this.storeListeners.remove(l);
            }
        }
    }

    protected void notifyStoreListeners(int type, String message) {
        StoreEvent event = new StoreEvent(this, type, message);
        this.fireNotification(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNotification(StoreEvent event) {
        if (this.storeListeners != null) {
            StoreListener[] l = null;
            ArrayList arrayList = this.storeListeners;
            synchronized (arrayList) {
                l = new StoreListener[this.storeListeners.size()];
                this.storeListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].notification(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolderListener(FolderListener l) {
        if (this.folderListeners == null) {
            this.folderListeners = new ArrayList();
        }
        ArrayList arrayList = this.folderListeners;
        synchronized (arrayList) {
            this.folderListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderListener(FolderListener l) {
        if (this.folderListeners != null) {
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                this.folderListeners.remove(l);
            }
        }
    }

    protected void notifyFolderListeners(int type, Folder folder) {
        FolderEvent event = new FolderEvent(this, folder, type);
        switch (type) {
            case 1: {
                this.fireFolderCreated(event);
                break;
            }
            case 2: {
                this.fireFolderDeleted(event);
            }
        }
    }

    protected void notifyFolderRenamedListeners(Folder oldFolder, Folder newFolder) {
        FolderEvent event = new FolderEvent(this, oldFolder, newFolder, 3);
        this.fireFolderRenamed(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderCreated(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderCreated(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderDeleted(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderDeleted(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderRenamed(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderRenamed(event);
            }
        }
    }
}

