/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class BasicAttributes
implements Attributes {
    private boolean ignoreCase = false;
    transient Hashtable<String, Attribute> attrs = new Hashtable(11);
    private static final long serialVersionUID = 4980164073184639448L;

    public BasicAttributes() {
    }

    public BasicAttributes(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public BasicAttributes(String attrID, Object val) {
        this();
        this.put(new BasicAttribute(attrID, val));
    }

    public BasicAttributes(String attrID, Object val, boolean ignoreCase) {
        this(ignoreCase);
        this.put(new BasicAttribute(attrID, val));
    }

    @Override
    public Object clone() {
        BasicAttributes attrset;
        try {
            attrset = (BasicAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            attrset = new BasicAttributes(this.ignoreCase);
        }
        attrset.attrs = (Hashtable)this.attrs.clone();
        return attrset;
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public int size() {
        return this.attrs.size();
    }

    @Override
    public Attribute get(String attrID) {
        Attribute attr = this.attrs.get(this.ignoreCase ? attrID.toLowerCase(Locale.ENGLISH) : attrID);
        return attr;
    }

    public NamingEnumeration<Attribute> getAll() {
        return new AttrEnumImpl();
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        return new IDEnumImpl();
    }

    @Override
    public Attribute put(String attrID, Object val) {
        return this.put(new BasicAttribute(attrID, val));
    }

    @Override
    public Attribute put(Attribute attr) {
        String id = attr.getID();
        if (this.ignoreCase) {
            id = id.toLowerCase(Locale.ENGLISH);
        }
        return this.attrs.put(id, attr);
    }

    @Override
    public Attribute remove(String attrID) {
        String id = this.ignoreCase ? attrID.toLowerCase(Locale.ENGLISH) : attrID;
        return this.attrs.remove(id);
    }

    public String toString() {
        if (this.attrs.size() == 0) {
            return "No attributes";
        }
        return this.attrs.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Attributes) {
            Attributes target = (Attributes)obj;
            if (this.ignoreCase != target.isCaseIgnored()) {
                return false;
            }
            if (this.size() == target.size()) {
                try {
                    NamingEnumeration<? extends Attribute> theirs = target.getAll();
                    while (theirs.hasMore()) {
                        Attribute mine;
                        Attribute their = theirs.next();
                        if (their.equals(mine = this.get(their.getID()))) continue;
                        return false;
                    }
                }
                catch (NamingException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.ignoreCase ? 1 : 0;
        try {
            NamingEnumeration<Attribute> all = this.getAll();
            while (all.hasMore()) {
                hash += all.next().hashCode();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.attrs.size());
        Enumeration<Attribute> attrEnum = this.attrs.elements();
        while (attrEnum.hasMoreElements()) {
            s.writeObject(attrEnum.nextElement());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int n = s.readInt();
        Hashtable hashtable = this.attrs = n >= 1 ? new Hashtable(1 + (int)((float)Math.min(768, n) / 0.75f)) : new Hashtable(2);
        while (--n >= 0) {
            this.put((Attribute)s.readObject());
        }
    }

    class IDEnumImpl
    implements NamingEnumeration<String> {
        Enumeration<Attribute> elements;

        public IDEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        @Override
        public String nextElement() {
            Attribute attr = this.elements.nextElement();
            return attr.getID();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public String next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() throws NamingException {
            this.elements = null;
        }
    }

    class AttrEnumImpl
    implements NamingEnumeration<Attribute> {
        Enumeration<Attribute> elements;

        public AttrEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        @Override
        public Attribute nextElement() {
            return this.elements.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Attribute next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() throws NamingException {
            this.elements = null;
        }
    }
}

