/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.controller.SessionController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Messages;

public class Session {
    private static final SessionController session = SessionController.getInstance();
    private static final LanguageController messages = LanguageController.getInstance();

    public void insert(String key, Object value) {
        session.put(key, value);
    }

    public void remove(String key) throws AraraException {
        if (!session.contains(key)) {
            throw new AraraException(messages.getMessage(Messages.ERROR_SESSION_REMOVE_UNKNOWN_KEY, key));
        }
        session.remove(key);
    }

    public boolean exists(String key) {
        return session.contains(key);
    }

    public void forget() {
        session.clear();
    }

    public Object obtain(String key) throws AraraException {
        if (session.contains(key)) {
            return session.get(key);
        }
        throw new AraraException(messages.getMessage(Messages.ERROR_SESSION_OBTAIN_UNKNOWN_KEY, key));
    }
}

