/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.DefaultResponseControlFactory;
import com.sun.jndi.ldap.EventSupport;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapBindingEnumeration;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapNameParser;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapSchemaCtx;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ManageReferralControl;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ext.StartTlsResponseImpl;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.dir.HierMemDirCtx;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.UnsolicitedNotificationListener;
import javax.naming.spi.DirectoryManager;

public final class LdapCtx
extends ComponentDirContext
implements EventDirContext,
LdapContext {
    private static final boolean debug = false;
    private static final boolean HARD_CLOSE = true;
    private static final boolean SOFT_CLOSE = false;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String DEFAULT_HOST = "localhost";
    private static final boolean DEFAULT_DELETE_RDN = true;
    private static final boolean DEFAULT_TYPES_ONLY = false;
    private static final int DEFAULT_DEREF_ALIASES = 3;
    private static final int DEFAULT_LDAP_VERSION = 32;
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_REFERRAL_MODE = 3;
    private static final char DEFAULT_REF_SEPARATOR = '#';
    static final String DEFAULT_SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final int DEFAULT_REFERRAL_LIMIT = 10;
    private static final String STARTTLS_REQ_OID = "1.3.6.1.4.1.1466.20037";
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"objectClasses", "attributeTypes", "matchingRules", "ldapSyntaxes"};
    private static final String VERSION = "java.naming.ldap.version";
    private static final String BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private static final String DELETE_RDN = "java.naming.ldap.deleteRDN";
    private static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    private static final String TYPES_ONLY = "java.naming.ldap.typesOnly";
    private static final String REF_SEPARATOR = "java.naming.ldap.ref.separator";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    static final String BIND_CONTROLS = "java.naming.ldap.control.connect";
    private static final String REFERRAL_LIMIT = "java.naming.ldap.referral.limit";
    private static final String TRACE_BER = "com.sun.jndi.ldap.trace.ber";
    private static final String NETSCAPE_SCHEMA_BUG = "com.sun.jndi.ldap.netscape.schemaBugs";
    private static final String OLD_NETSCAPE_SCHEMA_BUG = "com.sun.naming.netscape.schemaBugs";
    private static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String ENABLE_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String DOMAIN_NAME = "com.sun.jndi.ldap.domainname";
    private static final String WAIT_FOR_REPLY = "com.sun.jndi.ldap.search.waitForReply";
    private static final String REPLY_QUEUE_SIZE = "com.sun.jndi.ldap.search.replyQueueSize";
    private static final NameParser parser = new LdapNameParser();
    private static final ControlFactory myResponseControlFactory = new DefaultResponseControlFactory();
    private static final Control manageReferralControl = new ManageReferralControl(false);
    private static final HierMemDirCtx EMPTY_SCHEMA = new HierMemDirCtx();
    int port_number;
    String hostname = null;
    LdapClient clnt = null;
    Hashtable<String, Object> envprops = null;
    int handleReferrals = 3;
    boolean hasLdapsScheme = false;
    String currentDN;
    Name currentParsedDN;
    Vector<Control> respCtls = null;
    Control[] reqCtls = null;
    private OutputStream trace = null;
    private boolean netscapeSchemaBug = false;
    private Control[] bindCtls = null;
    private int referralHopLimit = 10;
    private Hashtable<String, DirContext> schemaTrees = null;
    private int batchSize = 1;
    private boolean deleteRDN = true;
    private boolean typesOnly = false;
    private int derefAliases = 3;
    private char addrEncodingSeparator = (char)35;
    private Hashtable<String, Boolean> binaryAttrs = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private boolean waitForReply = true;
    private int replyQueueSize = -1;
    private boolean useSsl = false;
    private boolean useDefaultPortNumber = false;
    private boolean parentIsLdapCtx = false;
    private int hopCount = 1;
    private String url = null;
    private EventSupport eventSupport;
    private boolean unsolicited = false;
    private boolean sharable = true;
    private int enumCount = 0;
    private boolean closeRequested = false;

    public LdapCtx(String dn, String host, int port_number, Hashtable<?, ?> props, boolean useSsl) throws NamingException {
        this.useSsl = this.hasLdapsScheme = useSsl;
        if (props != null) {
            this.envprops = (Hashtable)props.clone();
            if ("ssl".equals(this.envprops.get("java.naming.security.protocol"))) {
                this.useSsl = true;
            }
            this.trace = (OutputStream)this.envprops.get(TRACE_BER);
            if (props.get(NETSCAPE_SCHEMA_BUG) != null || props.get(OLD_NETSCAPE_SCHEMA_BUG) != null) {
                this.netscapeSchemaBug = true;
            }
        }
        this.currentDN = dn != null ? dn : "";
        this.currentParsedDN = parser.parse(this.currentDN);
        String string = this.hostname = host != null && host.length() > 0 ? host : DEFAULT_HOST;
        if (this.hostname.charAt(0) == '[') {
            this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
        }
        if (port_number > 0) {
            this.port_number = port_number;
        } else {
            this.port_number = this.useSsl ? 636 : 389;
            this.useDefaultPortNumber = true;
        }
        this.schemaTrees = new Hashtable(11, 0.75f);
        this.initEnv();
        try {
            this.connect(false);
        }
        catch (NamingException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    LdapCtx(LdapCtx existing, String newDN) throws NamingException {
        this.useSsl = existing.useSsl;
        this.hasLdapsScheme = existing.hasLdapsScheme;
        this.useDefaultPortNumber = existing.useDefaultPortNumber;
        this.hostname = existing.hostname;
        this.port_number = existing.port_number;
        this.currentDN = newDN;
        this.currentParsedDN = existing.currentDN == this.currentDN ? existing.currentParsedDN : parser.parse(this.currentDN);
        this.envprops = existing.envprops;
        this.schemaTrees = existing.schemaTrees;
        this.clnt = existing.clnt;
        this.clnt.incRefCount();
        this.parentIsLdapCtx = newDN == null || newDN.equals(existing.currentDN) ? existing.parentIsLdapCtx : true;
        this.trace = existing.trace;
        this.netscapeSchemaBug = existing.netscapeSchemaBug;
        this.initEnv();
    }

    @Override
    public LdapContext newInstance(Control[] reqCtls) throws NamingException {
        LdapCtx clone = new LdapCtx(this, this.currentDN);
        clone.setRequestControls(reqCtls);
        return clone;
    }

    @Override
    protected void c_bind(Name name, Object obj, Continuation cont) throws NamingException {
        this.c_bind(name, obj, null, cont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_bind(Name name, Object obj, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        inputAttrs = attrs;
        try {
            this.ensureOpen();
            if (obj == null) {
                if (attrs == null) {
                    throw new IllegalArgumentException("cannot bind null object with no attributes");
                }
            } else {
                attrs = Obj.determineBindAttrs(this.addrEncodingSeparator, obj, attrs, false, name, this, this.envprops);
            }
            newDN = this.fullyQualifiedName(name);
            attrs = LdapCtx.addRdnAttributes(newDN, attrs, inputAttrs != attrs);
            entry = new LdapEntry(newDN, attrs);
            answer = this.clnt.add(entry, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.bind(name, obj, inputAttrs);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    @Override
    protected void c_rebind(Name name, Object obj, Continuation cont) throws NamingException {
        this.c_rebind(name, obj, null, cont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_rebind(Name name, Object obj, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        inputAttrs = attrs;
        try {
            origAttrs = null;
            try {
                origAttrs = this.c_getAttributes(name, null, cont);
            }
            catch (NameNotFoundException var7_11) {
                // empty catch block
            }
            if (origAttrs == null) {
                this.c_bind(name, obj, attrs, cont);
                return;
            }
            if (attrs == null && obj instanceof DirContext) {
                attrs = ((DirContext)obj).getAttributes("");
            }
            keepAttrs = (Attributes)origAttrs.clone();
            if (attrs == null) {
                origObjectClass = origAttrs.get(Obj.JAVA_ATTRIBUTES[0]);
                if (origObjectClass != null) {
                    origObjectClass = (Attribute)origObjectClass.clone();
                    for (i = 0; i < Obj.JAVA_OBJECT_CLASSES.length; ++i) {
                        origObjectClass.remove(Obj.JAVA_OBJECT_CLASSES_LOWER[i]);
                        origObjectClass.remove(Obj.JAVA_OBJECT_CLASSES[i]);
                    }
                    origAttrs.put(origObjectClass);
                }
                for (i = 1; i < Obj.JAVA_ATTRIBUTES.length; ++i) {
                    origAttrs.remove(Obj.JAVA_ATTRIBUTES[i]);
                }
                attrs = origAttrs;
            }
            if (obj != null) {
                attrs = Obj.determineBindAttrs(this.addrEncodingSeparator, obj, attrs, inputAttrs != attrs, name, this, this.envprops);
            }
            newDN = this.fullyQualifiedName(name);
            answer = this.clnt.delete(newDN, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
                return;
            }
            addEx = null;
            try {
                attrs = LdapCtx.addRdnAttributes(newDN, attrs, inputAttrs != attrs);
                entry = new LdapEntry(newDN, attrs);
                answer = this.clnt.add(entry, this.reqCtls);
                if (answer.resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, answer.resControls);
                }
            }
            catch (IOException | NamingException ae) {
                addEx = ae;
            }
            if (addEx != null && !(addEx instanceof LdapReferralException) || answer.status != 0) {
                answer2 = this.clnt.add(new LdapEntry(newDN, keepAttrs), this.reqCtls);
                if (answer2.resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, answer2.resControls);
                }
                if (addEx == null) {
                    this.processReturnCode(answer, name);
                }
            }
            if (addEx instanceof NamingException) {
                throw (NamingException)addEx;
            }
            if (addEx instanceof IOException) {
                throw (IOException)addEx;
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.rebind(name, obj, inputAttrs);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_unbind(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            this.ensureOpen();
            fname = this.fullyQualifiedName(name);
            answer = this.clnt.delete(fname, this.reqCtls);
            this.respCtls = answer.resControls;
            this.adjustDeleteStatus(fname, answer);
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.unbind(name);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_rename(Name oldName, Name newName, Continuation cont) throws NamingException {
        newRDN = null;
        newSuperior = null;
        cont.setError((Object)this, oldName);
        try {
            this.ensureOpen();
            if (oldName.isEmpty()) {
                oldParent = LdapCtx.parser.parse("");
            } else {
                oldParsed = LdapCtx.parser.parse(oldName.get(0));
                oldParent = oldParsed.getPrefix(oldParsed.size() - 1);
            }
            newParsed = newName instanceof CompositeName != false ? LdapCtx.parser.parse(newName.get(0)) : newName;
            newParent = newParsed.getPrefix(newParsed.size() - 1);
            if (!oldParent.equals(newParent)) {
                if (!this.clnt.isLdapv3) {
                    throw new InvalidNameException("LDAPv2 doesn't support changing the parent as a result of a rename");
                }
                newSuperior = this.fullyQualifiedName(newParent.toString());
            }
            newRDN = newParsed.get(newParsed.size() - 1);
            answer = this.clnt.moddn(this.fullyQualifiedName(oldName), newRDN, this.deleteRDN, newSuperior, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, oldName);
            }
        }
        catch (LdapReferralException e) {
            e.setNewRdn(newRDN);
            if (newSuperior != null) {
                pre = new PartialResultException("Cannot continue referral processing when newSuperior is nonempty: " + newSuperior);
                pre.setRootCause(cont.fillInException(e));
                throw cont.fillInException(pre);
            }
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.rename(oldName, newName);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    @Override
    protected Context c_createSubcontext(Name name, Continuation cont) throws NamingException {
        return this.c_createSubcontext(name, null, cont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected DirContext c_createSubcontext(Name name, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        inputAttrs = attrs;
        try {
            this.ensureOpen();
            if (attrs == null) {
                oc = new BasicAttribute(Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_OBJECT_CLASSES[0]);
                oc.add("top");
                attrs = new BasicAttributes(true);
                attrs.put(oc);
            }
            newDN = this.fullyQualifiedName(name);
            attrs = LdapCtx.addRdnAttributes(newDN, attrs, inputAttrs != attrs);
            entry = new LdapEntry(newDN, attrs);
            answer = this.clnt.add(entry, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
                return null;
            }
            return new LdapCtx(this, newDN);
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    answer = refCtx.createSubcontext(name, inputAttrs);
                    return answer;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_destroySubcontext(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            this.ensureOpen();
            fname = this.fullyQualifiedName(name);
            answer = this.clnt.delete(fname, this.reqCtls);
            this.respCtls = answer.resControls;
            this.adjustDeleteStatus(fname, answer);
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.destroySubcontext(name);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    private static Attributes addRdnAttributes(String dn, Attributes attrs, boolean directUpdate) throws NamingException {
        if (dn.equals("")) {
            return attrs;
        }
        List<Rdn> rdnList = new LdapName(dn).getRdns();
        Rdn rdn = rdnList.get(rdnList.size() - 1);
        Attributes nameAttrs = rdn.toAttributes();
        NamingEnumeration<? extends Attribute> enum_ = nameAttrs.getAll();
        while (enum_.hasMore()) {
            Attribute nameAttr = enum_.next();
            if (attrs.get(nameAttr.getID()) != null || !attrs.isCaseIgnored() && LdapCtx.containsIgnoreCase(attrs.getIDs(), nameAttr.getID())) continue;
            if (!directUpdate) {
                attrs = (Attributes)attrs.clone();
                directUpdate = true;
            }
            attrs.put(nameAttr);
        }
        return attrs;
    }

    private static boolean containsIgnoreCase(NamingEnumeration<String> enumStr, String str) throws NamingException {
        while (enumStr.hasMore()) {
            String strEntry = enumStr.next();
            if (!strEntry.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private void adjustDeleteStatus(String fname, LdapResult answer) {
        if (answer.status == 32 && answer.matchedDN != null) {
            try {
                Name orig = parser.parse(fname);
                Name matched = parser.parse(answer.matchedDN);
                if (orig.size() - matched.size() == 1) {
                    answer.status = 0;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private static <T> Vector<T> appendVector(Vector<T> v1, Vector<T> v2) {
        if (v1 == null) {
            v1 = v2;
        } else {
            for (int i = 0; i < v2.size(); ++i) {
                v1.addElement(v2.elementAt(i));
            }
        }
        return v1;
    }

    @Override
    protected Object c_lookupLink(Name name, Continuation cont) throws NamingException {
        return this.c_lookup(name, cont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Object c_lookup(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        obj = null;
        try {
            cons = new SearchControls();
            cons.setSearchScope(0);
            cons.setReturningAttributes(null);
            cons.setReturningObjFlag(true);
            answer = this.doSearchOnce(name, "(objectClass=*)", cons, true);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
            if (answer.entries == null || answer.entries.size() != 1) {
                attrs /* !! */  = new BasicAttributes(true);
            } else {
                entry = answer.entries.elementAt(0);
                attrs /* !! */  = entry.attributes;
                entryCtls = entry.respCtls;
                if (entryCtls != null) {
                    LdapCtx.appendVector(this.respCtls, entryCtls);
                }
            }
            if (attrs /* !! */ .get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                obj = Obj.decodeObject(attrs /* !! */ );
            }
            if (obj == null) {
                obj = new LdapCtx(this, this.fullyQualifiedName(name));
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    entry = refCtx.lookup(name);
                    return entry;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
        try {
            return DirectoryManager.getObjectInstance(obj, name, this, this.envprops, attrs /* !! */ );
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
        catch (Exception e) {
            e2 = new NamingException("problem generating object using object factory");
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected NamingEnumeration<NameClassPair> c_list(Name name, Continuation cont) throws NamingException {
        cons = new SearchControls();
        classAttrs = new String[]{Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_ATTRIBUTES[2]};
        cons.setReturningAttributes(classAttrs);
        cons.setReturningObjFlag(true);
        cont.setError((Object)this, name);
        answer = null;
        try {
            answer = this.doSearch(name, "(objectClass=*)", cons, true, true);
            if (answer.status != 0 || answer.referrals != null) {
                this.processReturnCode(answer, name);
            }
            return new LdapNamingEnumeration(this, answer, name, cont);
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var8_15 = refCtx.list(name);
                    return var8_15;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException e) {
            res = new LdapNamingEnumeration(this, answer, name, cont);
            res.setNamingException((LimitExceededException)cont.fillInException(e));
            return res;
        }
        catch (PartialResultException e) {
            res = new LdapNamingEnumeration(this, answer, name, cont);
            res.setNamingException((PartialResultException)cont.fillInException(e));
            return res;
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected NamingEnumeration<Binding> c_listBindings(Name name, Continuation cont) throws NamingException {
        cons = new SearchControls();
        cons.setReturningAttributes(null);
        cons.setReturningObjFlag(true);
        cont.setError((Object)this, name);
        answer = null;
        try {
            answer = this.doSearch(name, "(objectClass=*)", cons, true, true);
            if (answer.status != 0 || answer.referrals != null) {
                this.processReturnCode(answer, name);
            }
            return new LdapBindingEnumeration(this, answer, name, cont);
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_14 = refCtx.listBindings(name);
                    return var7_14;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException e) {
            res = new LdapBindingEnumeration(this, answer, name, cont);
            res.setNamingException(cont.fillInException(e));
            return res;
        }
        catch (PartialResultException e) {
            res = new LdapBindingEnumeration(this, answer, name, cont);
            res.setNamingException(cont.fillInException(e));
            return res;
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    @Override
    protected NameParser c_getNameParser(Name name, Continuation cont) throws NamingException {
        cont.setSuccess();
        return parser;
    }

    @Override
    public String getNameInNamespace() {
        return this.currentDN;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name instanceof LdapName && prefix instanceof LdapName) {
            Name result = (Name)prefix.clone();
            result.addAll(name);
            return new CompositeName().add(result.toString());
        }
        if (!(name instanceof CompositeName)) {
            name = new CompositeName().add(name.toString());
        }
        if (!(prefix instanceof CompositeName)) {
            prefix = new CompositeName().add(prefix.toString());
        }
        int prefixLast = prefix.size() - 1;
        if (name.isEmpty() || prefix.isEmpty() || name.get(0).equals("") || prefix.get(prefixLast).equals("")) {
            return super.composeName(name, prefix);
        }
        Name result = (Name)prefix.clone();
        result.addAll(name);
        if (this.parentIsLdapCtx) {
            String ldapComp = LdapCtx.concatNames(result.get(prefixLast + 1), result.get(prefixLast));
            result.remove(prefixLast + 1);
            result.remove(prefixLast);
            result.add(prefixLast, ldapComp);
        }
        return result;
    }

    private String fullyQualifiedName(Name rel) {
        return rel.isEmpty() ? this.currentDN : this.fullyQualifiedName(rel.get(0));
    }

    private String fullyQualifiedName(String rel) {
        return LdapCtx.concatNames(rel, this.currentDN);
    }

    private static String concatNames(String lesser, String greater) {
        if (lesser == null || lesser.equals("")) {
            return greater;
        }
        if (greater == null || greater.equals("")) {
            return lesser;
        }
        return lesser + "," + greater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Attributes c_getAttributes(Name name, String[] attrIds, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        cons = new SearchControls();
        cons.setSearchScope(0);
        cons.setReturningAttributes(attrIds);
        try {
            answer = this.doSearchOnce(name, "(objectClass=*)", cons, true);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
            if (answer.entries == null || answer.entries.size() != 1) {
                return new BasicAttributes(true);
            }
            entry = answer.entries.elementAt(0);
            entryCtls = entry.respCtls;
            if (entryCtls != null) {
                LdapCtx.appendVector(this.respCtls, entryCtls);
            }
            this.setParents(entry.attributes, (Name)name.clone());
            return entry.attributes;
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    entryCtls = refCtx.getAttributes(name, attrIds);
                    return entryCtls;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_modifyAttributes(Name name, int mod_op, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (attrs == null || attrs.size() == 0) {
                return;
            }
            newDN = this.fullyQualifiedName(name);
            jmod_op = LdapCtx.convertToLdapModCode(mod_op);
            jmods = new int[attrs.size()];
            jattrs = new Attribute[attrs.size()];
            ae = attrs.getAll();
            for (i = 0; i < jmods.length && ae.hasMore(); ++i) {
                jmods[i] = jmod_op;
                jattrs[i] = ae.next();
            }
            answer = this.clnt.modify(newDN, jmods, jattrs, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
                return;
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.modifyAttributes(name, mod_op, attrs);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_modifyAttributes(Name name, ModificationItem[] mods, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (mods == null || mods.length == 0) {
                return;
            }
            newDN = this.fullyQualifiedName(name);
            jmods = new int[mods.length];
            jattrs = new Attribute[mods.length];
            for (i = 0; i < jmods.length; ++i) {
                mod = mods[i];
                jmods[i] = LdapCtx.convertToLdapModCode(mod.getModificationOp());
                jattrs[i] = mod.getAttribute();
            }
            answer = this.clnt.modify(newDN, jmods, jattrs, this.reqCtls);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, name);
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    refCtx.modifyAttributes(name, mods);
                    return;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    private static int convertToLdapModCode(int mod_op) {
        switch (mod_op) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid modification code");
    }

    @Override
    protected DirContext c_getSchema(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            return this.getSchemaTree(name);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    @Override
    protected DirContext c_getSchemaClassDefinition(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        try {
            Attribute objectClassAttr = this.c_getAttributes(name, new String[]{"objectclass"}, cont).get("objectclass");
            if (objectClassAttr == null || objectClassAttr.size() == 0) {
                return EMPTY_SCHEMA;
            }
            Context ocSchema = (Context)this.c_getSchema(name, cont).lookup("ClassDefinition");
            HierMemDirCtx objectClassCtx = new HierMemDirCtx();
            NamingEnumeration<?> objectClasses = objectClassAttr.getAll();
            while (objectClasses.hasMoreElements()) {
                String objectClassName = (String)objectClasses.nextElement();
                DirContext objectClassDef = (DirContext)ocSchema.lookup(objectClassName);
                objectClassCtx.bind(objectClassName, (Object)objectClassDef);
            }
            objectClassCtx.setReadOnly(new SchemaViolationException("Cannot update schema object"));
            return objectClassCtx;
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    private DirContext getSchemaTree(Name name) throws NamingException {
        String subschemasubentry = this.getSchemaEntry(name, true);
        DirContext schemaTree = this.schemaTrees.get(subschemasubentry);
        if (schemaTree == null) {
            schemaTree = this.buildSchemaTree(subschemasubentry);
            this.schemaTrees.put(subschemasubentry, schemaTree);
        }
        return schemaTree;
    }

    private DirContext buildSchemaTree(String subschemasubentry) throws NamingException {
        SearchControls constraints = new SearchControls(0, 0L, 0, SCHEMA_ATTRIBUTES, true, false);
        Name sse = new CompositeName().add(subschemasubentry);
        NamingEnumeration<SearchResult> results = this.searchAux(sse, "(objectClass=subschema)", constraints, false, true, new Continuation());
        if (!results.hasMore()) {
            throw new OperationNotSupportedException("Cannot get read subschemasubentry: " + subschemasubentry);
        }
        SearchResult result = results.next();
        results.close();
        Object obj = result.getObject();
        if (!(obj instanceof LdapCtx)) {
            throw new NamingException("Cannot get schema object as DirContext: " + subschemasubentry);
        }
        return LdapSchemaCtx.createSchemaTree(this.envprops, subschemasubentry, (LdapCtx)obj, result.getAttributes(), this.netscapeSchemaBug);
    }

    private String getSchemaEntry(Name name, boolean relative) throws NamingException {
        NamingEnumeration<SearchResult> results;
        SearchControls constraints = new SearchControls(0, 0L, 0, new String[]{"subschemasubentry"}, false, false);
        try {
            results = this.searchAux(name, "objectclass=*", constraints, relative, true, new Continuation());
        }
        catch (NamingException ne) {
            if (!this.clnt.isLdapv3 && this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot get schema information from server");
            }
            throw ne;
        }
        if (!results.hasMoreElements()) {
            throw new ConfigurationException("Requesting schema of nonexistent entry: " + name);
        }
        SearchResult result = results.next();
        results.close();
        Attribute schemaEntryAttr = result.getAttributes().get("subschemasubentry");
        if (schemaEntryAttr == null || schemaEntryAttr.size() < 0) {
            if (this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot read subschemasubentry of root DSE");
            }
            return this.getSchemaEntry(new CompositeName(), false);
        }
        return (String)schemaEntryAttr.get();
    }

    void setParents(Attributes attrs, Name name) throws NamingException {
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMore()) {
            ((LdapAttribute)ae.next()).setParent(this, name);
        }
    }

    String getURL() {
        if (this.url == null) {
            this.url = LdapURL.toUrlString(this.hostname, this.port_number, this.currentDN, this.hasLdapsScheme);
        }
        return this.url;
    }

    protected NamingEnumeration<SearchResult> c_search(Name name, Attributes matchingAttributes, Continuation cont) throws NamingException {
        return this.c_search(name, matchingAttributes, null, cont);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, Attributes matchingAttributes, String[] attributesToReturn, Continuation cont) throws NamingException {
        String filter;
        SearchControls cons = new SearchControls();
        cons.setReturningAttributes(attributesToReturn);
        try {
            filter = SearchFilter.format(matchingAttributes);
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
        return this.c_search(name, filter, cons, cont);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, String filter, SearchControls cons, Continuation cont) throws NamingException {
        return this.searchAux(name, filter, LdapCtx.cloneSearchControls(cons), true, this.waitForReply, cont);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons, Continuation cont) throws NamingException {
        String strfilter;
        try {
            strfilter = SearchFilter.format(filterExpr, filterArgs);
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
        return this.c_search(name, strfilter, cons, cont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    NamingEnumeration<SearchResult> searchAux(Name name, String filter, SearchControls cons, boolean relative, boolean waitForReply, Continuation cont) throws NamingException {
        answer = null;
        tokens = new String[2];
        if (cons == null) {
            cons = new SearchControls();
        }
        reqAttrs = cons.getReturningAttributes();
        if (cons.getReturningObjFlag() && reqAttrs != null) {
            hasWildcard = false;
            for (i = reqAttrs.length - 1; i >= 0; --i) {
                if (!reqAttrs[i].equals("*")) continue;
                hasWildcard = true;
                break;
            }
            if (!hasWildcard) {
                totalAttrs = new String[reqAttrs.length + Obj.JAVA_ATTRIBUTES.length];
                System.arraycopy(reqAttrs, 0, totalAttrs, 0, reqAttrs.length);
                System.arraycopy(Obj.JAVA_ATTRIBUTES, 0, totalAttrs, reqAttrs.length, Obj.JAVA_ATTRIBUTES.length);
                cons.setReturningAttributes(totalAttrs);
            }
        }
        args = new SearchArgs(name, filter, cons, reqAttrs);
        cont.setError((Object)this, name);
        try {
            if (LdapCtx.searchToCompare(filter, cons, tokens)) {
                answer = this.compare(name, tokens[0], tokens[1]);
                if (!answer.compareToSearchResult(this.fullyQualifiedName(name))) {
                    this.processReturnCode(answer, name);
                }
            } else {
                answer = this.doSearch(name, filter, cons, relative, waitForReply);
                this.processReturnCode(answer, name);
            }
            return new LdapSearchEnumeration(this, answer, this.fullyQualifiedName(name), args, cont);
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw cont.fillInException(e);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var13_25 = refCtx.search(name, filter, cons);
                    return var13_25;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException e) {
            res = new LdapSearchEnumeration(this, answer, this.fullyQualifiedName(name), args, cont);
            res.setNamingException(e);
            return res;
        }
        catch (PartialResultException e) {
            res = new LdapSearchEnumeration(this, answer, this.fullyQualifiedName(name), args, cont);
            res.setNamingException(e);
            return res;
        }
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw cont.fillInException(e2);
        }
        catch (NamingException e) {
            throw cont.fillInException(e);
        }
    }

    LdapResult getSearchReply(LdapClient eClnt, LdapResult res) throws NamingException {
        if (this.clnt != eClnt) {
            throw new CommunicationException("Context's connection changed; unable to continue enumeration");
        }
        try {
            return eClnt.getSearchReply(this.batchSize, res, this.binaryAttrs);
        }
        catch (IOException e) {
            CommunicationException e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw e2;
        }
    }

    private LdapResult doSearchOnce(Name name, String filter, SearchControls cons, boolean relative) throws NamingException {
        int savedBatchSize = this.batchSize;
        this.batchSize = 2;
        LdapResult answer = this.doSearch(name, filter, cons, relative, true);
        this.batchSize = savedBatchSize;
        return answer;
    }

    private LdapResult doSearch(Name name, String filter, SearchControls cons, boolean relative, boolean waitForReply) throws NamingException {
        this.ensureOpen();
        try {
            int scope;
            switch (cons.getSearchScope()) {
                case 0: {
                    scope = 0;
                    break;
                }
                default: {
                    scope = 1;
                    break;
                }
                case 2: {
                    scope = 2;
                }
            }
            String[] retattrs = cons.getReturningAttributes();
            if (retattrs != null && retattrs.length == 0) {
                retattrs = new String[]{"1.1"};
            }
            String nm = relative ? this.fullyQualifiedName(name) : (name.isEmpty() ? "" : name.get(0));
            int msecLimit = cons.getTimeLimit();
            int secLimit = 0;
            if (msecLimit > 0) {
                secLimit = msecLimit / 1000 + 1;
            }
            LdapResult answer = this.clnt.search(nm, scope, this.derefAliases, (int)cons.getCountLimit(), secLimit, cons.getReturningObjFlag() ? false : this.typesOnly, retattrs, filter, this.batchSize, this.reqCtls, this.binaryAttrs, waitForReply, this.replyQueueSize);
            this.respCtls = answer.resControls;
            return answer;
        }
        catch (IOException e) {
            CommunicationException e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw e2;
        }
    }

    private static boolean searchToCompare(String filter, SearchControls cons, String[] tokens) {
        if (cons.getSearchScope() != 0) {
            return false;
        }
        String[] attrs = cons.getReturningAttributes();
        if (attrs == null || attrs.length != 0) {
            return false;
        }
        return LdapCtx.filterToAssertion(filter, tokens);
    }

    private static boolean filterToAssertion(String filter, String[] tokens) {
        StringTokenizer assertionTokenizer = new StringTokenizer(filter, "=");
        if (assertionTokenizer.countTokens() != 2) {
            return false;
        }
        tokens[0] = assertionTokenizer.nextToken();
        tokens[1] = assertionTokenizer.nextToken();
        if (tokens[1].indexOf(42) != -1) {
            return false;
        }
        boolean hasParens = false;
        int len = tokens[1].length();
        if (tokens[0].charAt(0) == '(' && tokens[1].charAt(len - 1) == ')') {
            hasParens = true;
        } else if (tokens[0].charAt(0) == '(' || tokens[1].charAt(len - 1) == ')') {
            return false;
        }
        StringTokenizer illegalCharsTokenizer = new StringTokenizer(tokens[0], "()&|!=~><*", true);
        if (illegalCharsTokenizer.countTokens() != (hasParens ? 2 : 1)) {
            return false;
        }
        illegalCharsTokenizer = new StringTokenizer(tokens[1], "()&|!=~><*", true);
        if (illegalCharsTokenizer.countTokens() != (hasParens ? 2 : 1)) {
            return false;
        }
        if (hasParens) {
            tokens[0] = tokens[0].substring(1);
            tokens[1] = tokens[1].substring(0, len - 1);
        }
        return true;
    }

    private LdapResult compare(Name name, String type, String value) throws IOException, NamingException {
        this.ensureOpen();
        String nm = this.fullyQualifiedName(name);
        LdapResult answer = this.clnt.compare(nm, type, value, this.reqCtls);
        this.respCtls = answer.resControls;
        return answer;
    }

    private static SearchControls cloneSearchControls(SearchControls cons) {
        if (cons == null) {
            return null;
        }
        String[] retAttrs = cons.getReturningAttributes();
        if (retAttrs != null) {
            String[] attrs = new String[retAttrs.length];
            System.arraycopy(retAttrs, 0, attrs, 0, retAttrs.length);
            retAttrs = attrs;
        }
        return new SearchControls(cons.getSearchScope(), cons.getCountLimit(), cons.getTimeLimit(), retAttrs, cons.getReturningObjFlag(), cons.getDerefLinkFlag());
    }

    protected Hashtable<String, Object> p_getEnvironment() {
        return this.envprops;
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.envprops == null ? new Hashtable<String, Object>(5, 0.75f) : (Hashtable)this.envprops.clone();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.envprops == null || this.envprops.get(propName) == null) {
            return null;
        }
        switch (propName) {
            case "java.naming.ldap.ref.separator": {
                this.addrEncodingSeparator = (char)35;
                break;
            }
            case "java.naming.ldap.typesOnly": {
                this.typesOnly = false;
                break;
            }
            case "java.naming.ldap.deleteRDN": {
                this.deleteRDN = true;
                break;
            }
            case "java.naming.ldap.derefAliases": {
                this.derefAliases = 3;
                break;
            }
            case "java.naming.batchsize": {
                this.batchSize = 1;
                break;
            }
            case "java.naming.ldap.referral.limit": {
                this.referralHopLimit = 10;
                break;
            }
            case "java.naming.referral": {
                this.setReferralMode(null, true);
                break;
            }
            case "java.naming.ldap.attributes.binary": {
                this.setBinaryAttributes(null);
                break;
            }
            case "com.sun.jndi.ldap.connect.timeout": {
                this.connectTimeout = -1;
                break;
            }
            case "com.sun.jndi.ldap.read.timeout": {
                this.readTimeout = -1;
                break;
            }
            case "com.sun.jndi.ldap.search.waitForReply": {
                this.waitForReply = true;
                break;
            }
            case "com.sun.jndi.ldap.search.replyQueueSize": {
                this.replyQueueSize = -1;
                break;
            }
            case "java.naming.security.protocol": {
                this.closeConnection(false);
                if (!this.useSsl || this.hasLdapsScheme) break;
                this.useSsl = false;
                this.url = null;
                if (!this.useDefaultPortNumber) break;
                this.port_number = 389;
                break;
            }
            case "java.naming.ldap.version": 
            case "java.naming.ldap.factory.socket": {
                this.closeConnection(false);
                break;
            }
            case "java.naming.security.authentication": 
            case "java.naming.security.principal": 
            case "java.naming.security.credentials": {
                this.sharable = false;
            }
        }
        this.envprops = (Hashtable)this.envprops.clone();
        return this.envprops.remove(propName);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (propVal == null) {
            return this.removeFromEnvironment(propName);
        }
        switch (propName) {
            case "java.naming.ldap.ref.separator": {
                this.setRefSeparator((String)propVal);
                break;
            }
            case "java.naming.ldap.typesOnly": {
                this.setTypesOnly((String)propVal);
                break;
            }
            case "java.naming.ldap.deleteRDN": {
                this.setDeleteRDN((String)propVal);
                break;
            }
            case "java.naming.ldap.derefAliases": {
                this.setDerefAliases((String)propVal);
                break;
            }
            case "java.naming.batchsize": {
                this.setBatchSize((String)propVal);
                break;
            }
            case "java.naming.ldap.referral.limit": {
                this.setReferralLimit((String)propVal);
                break;
            }
            case "java.naming.referral": {
                this.setReferralMode((String)propVal, true);
                break;
            }
            case "java.naming.ldap.attributes.binary": {
                this.setBinaryAttributes((String)propVal);
                break;
            }
            case "com.sun.jndi.ldap.connect.timeout": {
                this.setConnectTimeout((String)propVal);
                break;
            }
            case "com.sun.jndi.ldap.read.timeout": {
                this.setReadTimeout((String)propVal);
                break;
            }
            case "com.sun.jndi.ldap.search.waitForReply": {
                this.setWaitForReply((String)propVal);
                break;
            }
            case "com.sun.jndi.ldap.search.replyQueueSize": {
                this.setReplyQueueSize((String)propVal);
                break;
            }
            case "java.naming.security.protocol": {
                this.closeConnection(false);
                if (!"ssl".equals(propVal)) break;
                this.useSsl = true;
                this.url = null;
                if (!this.useDefaultPortNumber) break;
                this.port_number = 636;
                break;
            }
            case "java.naming.ldap.version": 
            case "java.naming.ldap.factory.socket": {
                this.closeConnection(false);
                break;
            }
            case "java.naming.security.authentication": 
            case "java.naming.security.principal": 
            case "java.naming.security.credentials": {
                this.sharable = false;
            }
        }
        this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        return this.envprops.put(propName, propVal);
    }

    void setProviderUrl(String providerUrl) {
        if (this.envprops != null) {
            this.envprops.put("java.naming.provider.url", providerUrl);
        }
    }

    void setDomainName(String domainName) {
        if (this.envprops != null) {
            this.envprops.put(DOMAIN_NAME, domainName);
        }
    }

    private void initEnv() throws NamingException {
        if (this.envprops == null) {
            this.setReferralMode(null, false);
            return;
        }
        this.setBatchSize((String)this.envprops.get("java.naming.batchsize"));
        this.setRefSeparator((String)this.envprops.get(REF_SEPARATOR));
        this.setDeleteRDN((String)this.envprops.get(DELETE_RDN));
        this.setTypesOnly((String)this.envprops.get(TYPES_ONLY));
        this.setDerefAliases((String)this.envprops.get(DEREF_ALIASES));
        this.setReferralLimit((String)this.envprops.get(REFERRAL_LIMIT));
        this.setBinaryAttributes((String)this.envprops.get(BINARY_ATTRIBUTES));
        this.bindCtls = LdapCtx.cloneControls((Control[])this.envprops.get(BIND_CONTROLS));
        this.setReferralMode((String)this.envprops.get("java.naming.referral"), false);
        this.setConnectTimeout((String)this.envprops.get(CONNECT_TIMEOUT));
        this.setReadTimeout((String)this.envprops.get(READ_TIMEOUT));
        this.setWaitForReply((String)this.envprops.get(WAIT_FOR_REPLY));
        this.setReplyQueueSize((String)this.envprops.get(REPLY_QUEUE_SIZE));
    }

    private void setDeleteRDN(String deleteRDNProp) {
        this.deleteRDN = deleteRDNProp == null || !deleteRDNProp.equalsIgnoreCase("false");
    }

    private void setTypesOnly(String typesOnlyProp) {
        this.typesOnly = typesOnlyProp != null && typesOnlyProp.equalsIgnoreCase("true");
    }

    private void setBatchSize(String batchSizeProp) {
        this.batchSize = batchSizeProp != null ? Integer.parseInt(batchSizeProp) : 1;
    }

    private void setReferralMode(String ref, boolean update) {
        if (ref != null) {
            switch (ref) {
                case "follow-scheme": {
                    this.handleReferrals = 4;
                    break;
                }
                case "follow": {
                    this.handleReferrals = 1;
                    break;
                }
                case "throw": {
                    this.handleReferrals = 2;
                    break;
                }
                case "ignore": {
                    this.handleReferrals = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value for java.naming.referral property.");
                }
            }
        } else {
            this.handleReferrals = 3;
        }
        if (this.handleReferrals == 3) {
            this.reqCtls = LdapCtx.addControl(this.reqCtls, manageReferralControl);
        } else if (update) {
            this.reqCtls = LdapCtx.removeControl(this.reqCtls, manageReferralControl);
        }
    }

    private void setDerefAliases(String deref) {
        if (deref != null) {
            switch (deref) {
                case "never": {
                    this.derefAliases = 0;
                    break;
                }
                case "searching": {
                    this.derefAliases = 1;
                    break;
                }
                case "finding": {
                    this.derefAliases = 2;
                    break;
                }
                case "always": {
                    this.derefAliases = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases property.");
                }
            }
        } else {
            this.derefAliases = 3;
        }
    }

    private void setRefSeparator(String sepStr) throws NamingException {
        this.addrEncodingSeparator = sepStr != null && sepStr.length() > 0 ? sepStr.charAt(0) : (char)35;
    }

    private void setReferralLimit(String referralLimitProp) {
        if (referralLimitProp != null) {
            this.referralHopLimit = Integer.parseInt(referralLimitProp);
            if (this.referralHopLimit == 0) {
                this.referralHopLimit = Integer.MAX_VALUE;
            }
        } else {
            this.referralHopLimit = 10;
        }
    }

    void setHopCount(int hopCount) {
        this.hopCount = hopCount;
    }

    private void setConnectTimeout(String connectTimeoutProp) {
        this.connectTimeout = connectTimeoutProp != null ? Integer.parseInt(connectTimeoutProp) : -1;
    }

    private void setReplyQueueSize(String replyQueueSizeProp) {
        if (replyQueueSizeProp != null) {
            this.replyQueueSize = Integer.parseInt(replyQueueSizeProp);
            if (this.replyQueueSize <= 0) {
                this.replyQueueSize = -1;
            }
        } else {
            this.replyQueueSize = -1;
        }
    }

    private void setWaitForReply(String waitForReplyProp) {
        this.waitForReply = waitForReplyProp == null || !waitForReplyProp.equalsIgnoreCase("false");
    }

    private void setReadTimeout(String readTimeoutProp) {
        this.readTimeout = readTimeoutProp != null ? Integer.parseInt(readTimeoutProp) : -1;
    }

    private static Vector<Vector<String>> extractURLs(String refString) {
        Vector<String> referral;
        int separator = 0;
        int urlCount = 0;
        while ((separator = refString.indexOf(10, separator)) >= 0) {
            ++separator;
            ++urlCount;
        }
        Vector<Vector<String>> referrals = new Vector<Vector<String>>(urlCount);
        boolean i = false;
        separator = refString.indexOf(10);
        int iURL = separator + 1;
        while ((separator = refString.indexOf(10, iURL)) >= 0) {
            referral = new Vector<String>(1);
            referral.addElement(refString.substring(iURL, separator));
            referrals.addElement(referral);
            iURL = separator + 1;
        }
        referral = new Vector(1);
        referral.addElement(refString.substring(iURL));
        referrals.addElement(referral);
        return referrals;
    }

    private void setBinaryAttributes(String attrIds) {
        if (attrIds == null) {
            this.binaryAttrs = null;
        } else {
            this.binaryAttrs = new Hashtable(11, 0.75f);
            StringTokenizer tokens = new StringTokenizer(attrIds.toLowerCase(Locale.ENGLISH), " ");
            while (tokens.hasMoreTokens()) {
                this.binaryAttrs.put(tokens.nextToken(), Boolean.TRUE);
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws NamingException {
        if (this.eventSupport != null) {
            this.eventSupport.cleanup();
            this.removeUnsolicited();
        }
        if (this.enumCount > 0) {
            this.closeRequested = true;
            return;
        }
        this.closeConnection(false);
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        Hashtable<Object, Object> hashtable = this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        if (connCtls == null) {
            this.envprops.remove(BIND_CONTROLS);
            this.bindCtls = null;
        } else {
            this.bindCtls = LdapCtx.cloneControls(connCtls);
            this.envprops.put(BIND_CONTROLS, this.bindCtls);
        }
        this.sharable = false;
        this.ensureOpen();
    }

    private void ensureOpen() throws NamingException {
        this.ensureOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen(boolean startTLS) throws NamingException {
        block8: {
            try {
                if (this.clnt == null) {
                    this.schemaTrees = new Hashtable(11, 0.75f);
                    this.connect(startTLS);
                    break block8;
                }
                if (this.sharable && !startTLS) break block8;
                LdapClient ldapClient = this.clnt;
                synchronized (ldapClient) {
                    if (!this.clnt.isLdapv3 || this.clnt.referenceCount > 1 || this.clnt.usingSaslStreams()) {
                        this.closeConnection(false);
                    }
                }
                this.schemaTrees = new Hashtable(11, 0.75f);
                this.connect(startTLS);
            }
            finally {
                this.sharable = true;
            }
        }
    }

    private void connect(boolean startTLS) throws NamingException {
        String user = null;
        Object passwd = null;
        String secProtocol = null;
        String socketFactory = null;
        String authMechanism = null;
        String ver = null;
        boolean usePool = false;
        if (this.envprops != null) {
            user = (String)this.envprops.get("java.naming.security.principal");
            passwd = this.envprops.get("java.naming.security.credentials");
            ver = (String)this.envprops.get(VERSION);
            secProtocol = this.useSsl ? "ssl" : (String)this.envprops.get("java.naming.security.protocol");
            socketFactory = (String)this.envprops.get(SOCKET_FACTORY);
            authMechanism = (String)this.envprops.get("java.naming.security.authentication");
            usePool = "true".equalsIgnoreCase((String)this.envprops.get(ENABLE_POOL));
        }
        if (socketFactory == null) {
            String string = socketFactory = "ssl".equals(secProtocol) ? DEFAULT_SSL_FACTORY : null;
        }
        if (authMechanism == null) {
            authMechanism = user == null ? "none" : "simple";
        }
        try {
            int ldapVersion;
            boolean initial;
            boolean bl = initial = this.clnt == null;
            if (initial) {
                ldapVersion = ver != null ? Integer.parseInt(ver) : 32;
                this.clnt = LdapClient.getInstance(usePool, this.hostname, this.port_number, socketFactory, this.connectTimeout, this.readTimeout, this.trace, ldapVersion, authMechanism, this.bindCtls, secProtocol, user, passwd, this.envprops);
                if (this.clnt.authenticateCalled()) {
                    return;
                }
            } else {
                if (this.sharable && startTLS) {
                    return;
                }
                ldapVersion = 3;
            }
            LdapResult answer = this.clnt.authenticate(initial, user, passwd, ldapVersion, authMechanism, this.bindCtls, this.envprops);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                if (initial) {
                    this.closeConnection(true);
                }
                this.processReturnCode(answer);
            }
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw e;
            }
            Throwable saved_ex = null;
            while (true) {
                String referral;
                if ((referral = e.getNextReferral()) == null) {
                    if (saved_ex != null) {
                        throw (NamingException)saved_ex.fillInStackTrace();
                    }
                    throw new NamingException("Internal error processing referral during connection");
                }
                LdapURL url = new LdapURL(referral);
                this.hostname = url.getHost();
                if (this.hostname != null && this.hostname.charAt(0) == '[') {
                    this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
                }
                this.port_number = url.getPort();
                try {
                    this.connect(startTLS);
                }
                catch (NamingException ne) {
                    saved_ex = ne;
                    continue;
                }
                break;
            }
        }
    }

    private void closeConnection(boolean hardclose) {
        this.removeUnsolicited();
        if (this.clnt != null) {
            this.clnt.close(this.reqCtls, hardclose);
            this.clnt = null;
        }
    }

    synchronized void incEnumCount() {
        ++this.enumCount;
    }

    synchronized void decEnumCount() {
        --this.enumCount;
        if (this.enumCount == 0 && this.closeRequested) {
            try {
                this.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected void processReturnCode(LdapResult answer) throws NamingException {
        this.processReturnCode(answer, null, this, null, this.envprops, null);
    }

    void processReturnCode(LdapResult answer, Name remainName) throws NamingException {
        this.processReturnCode(answer, new CompositeName().add(this.currentDN), this, remainName, this.envprops, this.fullyQualifiedName(remainName));
    }

    protected void processReturnCode(LdapResult res, Name resolvedName, Object resolvedObj, Name remainName, Hashtable<?, ?> envprops, String fullDN) throws NamingException {
        NamingException e;
        String msg = LdapClient.getErrorMessage(res.status, res.errorMessage);
        LdapReferralException r = null;
        switch (res.status) {
            case 0: {
                if (res.referrals != null) {
                    msg = "Unprocessed Continuation Reference(s)";
                    if (this.handleReferrals == 3) {
                        e = new PartialResultException(msg);
                        break;
                    }
                    int contRefCount = res.referrals.size();
                    LdapReferralException head = null;
                    LdapReferralException ptr = null;
                    msg = "Continuation Reference";
                    for (int i = 0; i < contRefCount; ++i) {
                        r = new LdapReferralException(resolvedName, resolvedObj, remainName, msg, envprops, fullDN, this.handleReferrals, this.reqCtls);
                        r.setReferralInfo(res.referrals.elementAt(i), true);
                        if (this.hopCount > 1) {
                            r.setHopCount(this.hopCount);
                        }
                        if (head == null) {
                            head = ptr = r;
                            continue;
                        }
                        ptr.nextReferralEx = r;
                        ptr = r;
                    }
                    res.referrals = null;
                    if (res.refEx == null) {
                        res.refEx = head;
                    } else {
                        ptr = res.refEx;
                        while (ptr.nextReferralEx != null) {
                            ptr = ptr.nextReferralEx;
                        }
                        ptr.nextReferralEx = head;
                    }
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException lee = new LimitExceededException("Referral limit exceeded");
                        lee.setRootCause(r);
                        throw lee;
                    }
                }
                return;
            }
            case 10: {
                Vector<Object> refs;
                if (this.handleReferrals == 3) {
                    e = new PartialResultException(msg);
                    break;
                }
                r = new LdapReferralException(resolvedName, resolvedObj, remainName, msg, envprops, fullDN, this.handleReferrals, this.reqCtls);
                if (res.referrals == null) {
                    refs = null;
                } else if (this.handleReferrals == 4) {
                    refs = new Vector();
                    for (String s : res.referrals.elementAt(0)) {
                        if (!s.startsWith("ldap:")) continue;
                        refs.add(s);
                    }
                    if (refs.isEmpty()) {
                        refs = null;
                    }
                } else {
                    refs = res.referrals.elementAt(0);
                }
                r.setReferralInfo(refs, false);
                if (this.hopCount > 1) {
                    r.setHopCount(this.hopCount);
                }
                if (this.hopCount > this.referralHopLimit) {
                    LimitExceededException lee = new LimitExceededException("Referral limit exceeded");
                    lee.setRootCause(r);
                    e = lee;
                    break;
                }
                e = r;
                break;
            }
            case 9: {
                if (this.handleReferrals == 3) {
                    e = new PartialResultException(msg);
                    break;
                }
                if (res.errorMessage == null || res.errorMessage.equals("")) {
                    e = new PartialResultException(msg);
                    break;
                }
                res.referrals = LdapCtx.extractURLs(res.errorMessage);
                r = new LdapReferralException(resolvedName, resolvedObj, remainName, msg, envprops, fullDN, this.handleReferrals, this.reqCtls);
                if (this.hopCount > 1) {
                    r.setHopCount(this.hopCount);
                }
                if ((res.entries == null || res.entries.isEmpty()) && res.referrals != null && res.referrals.size() == 1) {
                    r.setReferralInfo(res.referrals, false);
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException lee = new LimitExceededException("Referral limit exceeded");
                        lee.setRootCause(r);
                        e = lee;
                        break;
                    }
                    e = r;
                    break;
                }
                r.setReferralInfo(res.referrals, true);
                res.refEx = r;
                return;
            }
            case 34: 
            case 64: {
                if (remainName != null) {
                    e = new InvalidNameException(remainName.toString() + ": " + msg);
                    break;
                }
                e = new InvalidNameException(msg);
                break;
            }
            default: {
                e = LdapCtx.mapErrorCode(res.status, res.errorMessage);
            }
        }
        e.setResolvedName(resolvedName);
        e.setResolvedObj(resolvedObj);
        e.setRemainingName(remainName);
        throw e;
    }

    public static NamingException mapErrorCode(int errorCode, String errorMessage) {
        if (errorCode == 0) {
            return null;
        }
        NamingException e = null;
        String message = LdapClient.getErrorMessage(errorCode, errorMessage);
        switch (errorCode) {
            case 36: {
                e = new NamingException(message);
                break;
            }
            case 33: {
                e = new NamingException(message);
                break;
            }
            case 20: {
                e = new AttributeInUseException(message);
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 48: {
                e = new AuthenticationNotSupportedException(message);
                break;
            }
            case 68: {
                e = new NameAlreadyBoundException(message);
                break;
            }
            case 14: 
            case 49: {
                e = new AuthenticationException(message);
                break;
            }
            case 18: {
                e = new InvalidSearchFilterException(message);
                break;
            }
            case 50: {
                e = new NoPermissionException(message);
                break;
            }
            case 19: 
            case 21: {
                e = new InvalidAttributeValueException(message);
                break;
            }
            case 54: {
                e = new NamingException(message);
                break;
            }
            case 16: {
                e = new NoSuchAttributeException(message);
                break;
            }
            case 32: {
                e = new NameNotFoundException(message);
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                e = new SchemaViolationException(message);
                break;
            }
            case 66: {
                e = new ContextNotEmptyException(message);
                break;
            }
            case 1: {
                e = new NamingException(message);
                break;
            }
            case 80: {
                e = new NamingException(message);
                break;
            }
            case 2: {
                e = new CommunicationException(message);
                break;
            }
            case 4: {
                e = new SizeLimitExceededException(message);
                break;
            }
            case 3: {
                e = new TimeLimitExceededException(message);
                break;
            }
            case 12: {
                e = new OperationNotSupportedException(message);
                break;
            }
            case 51: 
            case 52: {
                e = new ServiceUnavailableException(message);
                break;
            }
            case 17: {
                e = new InvalidAttributeIdentifierException(message);
                break;
            }
            case 53: {
                e = new OperationNotSupportedException(message);
                break;
            }
            case 5: 
            case 6: 
            case 35: {
                e = new NamingException(message);
                break;
            }
            case 11: {
                e = new LimitExceededException(message);
                break;
            }
            case 10: {
                e = new NamingException(message);
                break;
            }
            case 9: {
                e = new NamingException(message);
                break;
            }
            case 34: 
            case 64: {
                e = new InvalidNameException(message);
                break;
            }
            default: {
                e = new NamingException(message);
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        startTLS = request.getID().equals("1.3.6.1.4.1.1466.20037");
        this.ensureOpen(startTLS);
        try {
            answer = this.clnt.extendedOp(request.getID(), request.getEncodedValue(), this.reqCtls, startTLS);
            this.respCtls = answer.resControls;
            if (answer.status != 0) {
                this.processReturnCode(answer, new CompositeName());
            }
            if ((er = request.createExtendedResponse(answer.extensionId, answer.extensionValue, 0, len = answer.extensionValue == null ? 0 : answer.extensionValue.length)) instanceof StartTlsResponseImpl) {
                domainName = (String)(this.envprops != null ? this.envprops.get("com.sun.jndi.ldap.domainname") : null);
                ((StartTlsResponseImpl)er).setConnection(this.clnt.conn, domainName);
            }
            return er;
        }
        catch (LdapReferralException e) {
            if (this.handleReferrals == 2) {
                throw e;
            }
            while (true) lbl-1000:
            // 3 sources

            {
                refCtx = (LdapReferralContext)e.getReferralContext(this.envprops, this.bindCtls);
                try {
                    er = refCtx.extendedOperation(request);
                    return er;
                }
                catch (LdapReferralException re) {
                    e = re;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException e) {
            e2 = new CommunicationException(e.getMessage());
            e2.setRootCause(e);
            throw e2;
        }
    }

    @Override
    public void setRequestControls(Control[] reqCtls) throws NamingException {
        this.reqCtls = this.handleReferrals == 3 ? LdapCtx.addControl(reqCtls, manageReferralControl) : LdapCtx.cloneControls(reqCtls);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return LdapCtx.cloneControls(this.reqCtls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return LdapCtx.cloneControls(this.bindCtls);
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.respCtls != null ? this.convertControls(this.respCtls) : null;
    }

    Control[] convertControls(Vector<Control> ctls) throws NamingException {
        int count = ctls.size();
        if (count == 0) {
            return null;
        }
        Control[] controls = new Control[count];
        for (int i = 0; i < count; ++i) {
            controls[i] = myResponseControlFactory.getControlInstance(ctls.elementAt(i));
            if (controls[i] != null) continue;
            controls[i] = ControlFactory.getControlInstance(ctls.elementAt(i), this, this.envprops);
        }
        return controls;
    }

    private static Control[] addControl(Control[] prevCtls, Control addition) {
        if (prevCtls == null) {
            return new Control[]{addition};
        }
        int found = LdapCtx.findControl(prevCtls, addition);
        if (found != -1) {
            return prevCtls;
        }
        Control[] newCtls = new Control[prevCtls.length + 1];
        System.arraycopy(prevCtls, 0, newCtls, 0, prevCtls.length);
        newCtls[prevCtls.length] = addition;
        return newCtls;
    }

    private static int findControl(Control[] ctls, Control target) {
        for (int i = 0; i < ctls.length; ++i) {
            if (ctls[i] != target) continue;
            return i;
        }
        return -1;
    }

    private static Control[] removeControl(Control[] prevCtls, Control target) {
        if (prevCtls == null) {
            return null;
        }
        int found = LdapCtx.findControl(prevCtls, target);
        if (found == -1) {
            return prevCtls;
        }
        Control[] newCtls = new Control[prevCtls.length - 1];
        System.arraycopy(prevCtls, 0, newCtls, 0, found);
        System.arraycopy(prevCtls, found + 1, newCtls, found, prevCtls.length - found - 1);
        return newCtls;
    }

    private static Control[] cloneControls(Control[] ctls) {
        if (ctls == null) {
            return null;
        }
        Control[] copiedCtls = new Control[ctls.length];
        System.arraycopy(ctls, 0, copiedCtls, 0, ctls.length);
        return copiedCtls;
    }

    @Override
    public void addNamingListener(Name nm, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(nm), scope, l);
    }

    @Override
    public void addNamingListener(String nm, int scope, NamingListener l) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(nm)), scope, l);
        if (l instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.removeNamingListener(l);
        if (l instanceof UnsolicitedNotificationListener && !this.eventSupport.hasUnsolicited()) {
            this.removeUnsolicited();
        }
    }

    @Override
    public void addNamingListener(String nm, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(nm)), filter, LdapCtx.cloneSearchControls(ctls), l);
        if (l instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    @Override
    public void addNamingListener(Name nm, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(nm), filter, ctls, l);
    }

    @Override
    public void addNamingListener(Name nm, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(nm), filter, filterArgs, ctls, l);
    }

    @Override
    public void addNamingListener(String nm, String filterExpr, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        String strfilter = SearchFilter.format(filterExpr, filterArgs);
        this.addNamingListener(LdapCtx.getTargetName(new CompositeName(nm)), strfilter, ctls, l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    private static String getTargetName(Name nm) throws NamingException {
        if (nm instanceof CompositeName) {
            if (nm.size() > 1) {
                throw new InvalidNameException("Target cannot span multiple namespaces: " + nm);
            }
            if (nm.isEmpty()) {
                return "";
            }
            return nm.get(0);
        }
        return nm.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnsolicited() throws NamingException {
        this.ensureOpen();
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            this.clnt.addUnsolicited(this);
            this.unsolicited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnsolicited() {
        if (this.eventSupport == null) {
            return;
        }
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited && this.clnt != null) {
                this.clnt.removeUnsolicited(this);
            }
            this.unsolicited = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireUnsolicited(Object obj) {
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited) {
                this.eventSupport.fireUnsolicited(obj);
                if (obj instanceof NamingException) {
                    this.unsolicited = false;
                }
            }
        }
    }

    static {
        EMPTY_SCHEMA.setReadOnly(new SchemaViolationException("Cannot update schema object"));
    }

    static final class SearchArgs {
        Name name;
        String filter;
        SearchControls cons;
        String[] reqAttrs;

        SearchArgs(Name name, String filter, SearchControls cons, String[] ra) {
            this.name = name;
            this.filter = filter;
            this.cons = cons;
            this.reqAttrs = ra;
        }
    }
}

