/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.BatchCompilerRequestor;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    private static final String ANNOTATION_SOURCE_CLASSPATH = "CLASSPATH";
    boolean enableJavadocOn;
    boolean warnJavadocOn;
    boolean warnAllJavadocOn;
    public Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    protected List<String> annotationPaths;
    protected boolean annotationsFromClasspath;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public CompilationProgress progress;
    public String destinationPath;
    public String[] destinationPaths;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public String[] classNames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    private boolean primaryNullAnnotationsSeen = false;
    public long lineCount0;
    public String log;
    public Logger logger;
    public int maxProblems;
    public Map<String, String> options;
    public char[][] ignoreOptionalProblemsFromFolders;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int currentRepetition;
    public int maxRepetition;
    public boolean showProgress = false;
    public long startTime;
    public ArrayList pendingErrors;
    public boolean systemExitWhenFinished = true;
    public static final int TIMING_DISABLED = 0;
    public static final int TIMING_ENABLED = 1;
    public static final int TIMING_DETAILED = 2;
    public int timing = 0;
    public CompilerStats[] compilerStats;
    public boolean verbose = false;
    private String[] expandedCommandLine;
    private PrintWriter err;
    protected ArrayList extraProblems;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";

    public static boolean compile(String string) {
        return new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, CompilationProgress compilationProgress) {
        return new Main(printWriter, printWriter2, false, null, compilationProgress).compile(stringArray);
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return Util.isPotentialZipArchive(string);
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        for (int i = 0; i < n; ++i) {
            File file = fileArray[i];
            if (!file.exists() || !file.isDirectory()) continue;
            fileArray2[i] = file.listFiles(filenameFilter);
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true, null, null).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = Util.EMPTY_STRING;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = stringArray[n2] + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = Util.EMPTY_STRING;
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = stringArray[n3] + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = stringArray[n4] + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this(printWriter, printWriter2, bl, map, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map<String, String> map, CompilationProgress compilationProgress) {
        this.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.relocalize();
    }

    public void addExtraProblems(CategorizedProblem categorizedProblem) {
        if (this.extraProblems == null) {
            this.extraProblems = new ArrayList();
        }
        this.extraProblems.add(categorizedProblem);
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            block6: while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            continue block6;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            continue block6;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            continue block6;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            continue block6;
                        }
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                if (string.length() != 0) {
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
                }
                return;
            }
        }
        if (NONE.equals(string3)) {
            string3 = NONE;
        }
        if (bl2 && string3 != null && Util.isPotentialZipArchive(string)) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3, this.options);
        if (object != null) {
            arrayList.add(object);
        } else if (string.length() != 0) {
            this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
        }
    }

    void addPendingErrors(String string) {
        if (this.pendingErrors == null) {
            this.pendingErrors = new ArrayList();
        }
        this.pendingErrors.add(string);
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    private boolean checkVMVersion(long l) {
        int n;
        String string = System.getProperty("java.class.version");
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 45: {
                return 2949123L >= l;
            }
            case 46: {
                return 0x2E0000L >= l;
            }
            case 47: {
                return 0x2F0000L >= l;
            }
            case 48: {
                return 0x300000L >= l;
            }
            case 49: {
                return 0x310000L >= l;
            }
            case 50: {
                return 0x320000L >= l;
            }
            case 51: {
                return 0x330000L >= l;
            }
            case 52: {
                return 0x340000L >= l;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(String[] stringArray) {
        try {
            this.configure(stringArray);
            if (this.progress != null) {
                this.progress.begin(this.filenames == null ? 0 : this.filenames.length * this.maxRepetition);
            }
            if (this.proceed) {
                if (this.showProgress) {
                    this.logger.compiling();
                }
                this.currentRepetition = 0;
                while (this.currentRepetition < this.maxRepetition) {
                    this.globalProblemsCount = 0;
                    this.globalErrorsCount = 0;
                    this.globalWarningsCount = 0;
                    this.globalTasksCount = 0;
                    this.exportedClassFilesCounter = 0;
                    if (this.maxRepetition > 1) {
                        this.logger.flush();
                        this.logger.logRepetition(this.currentRepetition, this.maxRepetition);
                    }
                    this.performCompilation();
                    ++this.currentRepetition;
                }
                if (this.compilerStats != null) {
                    this.logger.logAverage();
                }
                if (this.showProgress) {
                    this.logger.printNewLine();
                }
            }
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(this.globalErrorsCount > 0 ? -1 : 0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.logException(illegalArgumentException);
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.logger.logException(runtimeException);
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.flush();
            this.logger.close();
            if (this.progress != null) {
                this.progress.done();
            }
        }
        return this.globalErrorsCount == 0 && (this.progress == null || !this.progress.isCanceled());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            this.printUsage();
            return;
        }
        ArrayList arrayList = new ArrayList(4);
        String string = null;
        ArrayList arrayList2 = new ArrayList(4);
        ArrayList arrayList3 = new ArrayList(4);
        ArrayList<String> arrayList4 = null;
        ArrayList<String> arrayList5 = null;
        this.annotationPaths = null;
        this.annotationsFromClasspath = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = stringArray.length;
        int n6 = 0;
        this.maxRepetition = 0;
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = Util.EMPTY_STRING;
        HashSet<String> hashSet = null;
        boolean bl6 = false;
        for (int i = 0; i < n5; ++i) {
            if (!stringArray[i].startsWith("@")) continue;
            bl6 = true;
            break;
        }
        String[] stringArray2 = null;
        if (bl6) {
            stringArray2 = new String[n5];
            n2 = 0;
            for (n = 0; n < n5; ++n) {
                String[] stringArray3 = null;
                String string7 = stringArray[n].trim();
                if (string7.startsWith("@")) {
                    try {
                        String string8;
                        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(string7.substring(1)), null))));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((string8 = lineNumberReader.readLine()) != null) {
                            if ((string8 = string8.trim()).startsWith("#")) continue;
                            stringBuffer.append(string8).append(" ");
                        }
                        stringArray3 = Main.tokenize(stringBuffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(this.bind("configure.invalidexpansionargumentname", string7));
                    }
                }
                if (stringArray3 != null) {
                    int n7 = stringArray2.length;
                    int n8 = stringArray3.length;
                    String[] stringArray4 = stringArray2;
                    stringArray2 = new String[n7 + n8 - 1];
                    System.arraycopy(stringArray4, 0, stringArray2, 0, n2);
                    System.arraycopy(stringArray3, 0, stringArray2, n2, n8);
                    n2 += n8;
                    continue;
                }
                stringArray2[n2++] = string7;
            }
            n2 = -1;
        } else {
            stringArray2 = stringArray;
            for (n = 0; n < n5; ++n) {
                stringArray2[n] = stringArray2[n].trim();
            }
        }
        n5 = stringArray2.length;
        this.expandedCommandLine = stringArray2;
        block56: while (++n2 < n5) {
            int n9;
            File file;
            if (string3 != null) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedCustomEncoding", string6, string3));
            }
            string6 = stringArray2[n2];
            switch (n6) {
                case 0: {
                    String string9;
                    if (string6.startsWith("-nowarn")) {
                        switch (string6.length()) {
                            case 7: {
                                this.disableAll(0);
                                break;
                            }
                            case 8: {
                                throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", string6));
                            }
                            default: {
                                n = string6.indexOf(91) + 1;
                                int n10 = string6.lastIndexOf(93);
                                if (n <= 8 || n10 == -1 || n > n10 || n10 < string6.length() - 1) {
                                    throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", string6));
                                }
                                String string10 = string6.substring(n, n10);
                                if (string10.length() <= 0) throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", string6));
                                char[][] cArray = Main.decodeIgnoreOptionalProblemsFromFolders(string10);
                                if (this.ignoreOptionalProblemsFromFolders != null) {
                                    int n11 = this.ignoreOptionalProblemsFromFolders.length + cArray.length;
                                    char[][] cArrayArray = new char[n11][];
                                    System.arraycopy(this.ignoreOptionalProblemsFromFolders, 0, cArrayArray, 0, this.ignoreOptionalProblemsFromFolders.length);
                                    System.arraycopy(cArray, 0, cArrayArray, this.ignoreOptionalProblemsFromFolders.length, cArray.length);
                                    this.ignoreOptionalProblemsFromFolders = cArrayArray;
                                    break;
                                }
                                this.ignoreOptionalProblemsFromFolders = cArray;
                                break;
                            }
                        }
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.startsWith("[")) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string6));
                    }
                    if (string6.endsWith("]")) {
                        n = string6.indexOf(91) + 1;
                        if (n <= 1) {
                            throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string6));
                        }
                        int n12 = string6.length() - 1;
                        if (n >= 1) {
                            if (n < n12) {
                                string3 = string6.substring(n, n12);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string3);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", string3));
                                }
                            }
                            string6 = string6.substring(0, n - 1);
                        }
                    }
                    if (string6.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[n5 - n2];
                            this.encodings = new String[n5 - n2];
                            this.destinationPaths = new String[n5 - n2];
                        } else if (n3 == this.filenames.length) {
                            n = this.filenames.length;
                            this.filenames = new String[n + n5 - n2];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, n);
                            this.encodings = new String[n + n5 - n2];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, n);
                            this.destinationPaths = new String[n + n5 - n2];
                            System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, n);
                        }
                        this.filenames[n3] = string6;
                        this.encodings[n3++] = string3;
                        string3 = null;
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-log")) {
                        if (this.log != null) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateLog", string6));
                        }
                        n6 = 5;
                        continue block56;
                    }
                    if (string6.equals("-repeat")) {
                        if (this.maxRepetition > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateRepeat", string6));
                        }
                        n6 = 6;
                        continue block56;
                    }
                    if (string6.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateMaxProblems", string6));
                        }
                        n6 = 11;
                        continue block56;
                    }
                    if (string6.equals("-source")) {
                        n6 = 7;
                        continue block56;
                    }
                    if (string6.equals("-encoding")) {
                        n6 = 8;
                        continue block56;
                    }
                    if (string6.equals("-1.3")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-1.4")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-1.5") || string6.equals("-5") || string6.equals("-5.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-1.6") || string6.equals("-6") || string6.equals("-6.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-1.7") || string6.equals("-7") || string6.equals("-7.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-1.8") || string6.equals("-8") || string6.equals("-8.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-d")) {
                        if (this.destinationPath != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                        }
                        n6 = 3;
                        continue block56;
                    }
                    if (string6.equals("-classpath") || string6.equals("-cp")) {
                        n6 = 1;
                        continue block56;
                    }
                    if (string6.equals("-bootclasspath")) {
                        if (arrayList.size() > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", stringBuffer.toString()));
                        }
                        n6 = 9;
                        continue block56;
                    }
                    if (string6.equals("-sourcepath")) {
                        if (string != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", stringBuffer.toString()));
                        }
                        n6 = 13;
                        continue block56;
                    }
                    if (string6.equals("-extdirs")) {
                        if (arrayList4 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", stringBuffer.toString()));
                        }
                        n6 = 12;
                        continue block56;
                    }
                    if (string6.equals("-endorseddirs")) {
                        if (arrayList5 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", stringBuffer.toString()));
                        }
                        n6 = 15;
                        continue block56;
                    }
                    if (string6.equals("-progress")) {
                        n6 = 0;
                        this.showProgress = true;
                        continue block56;
                    }
                    if (string6.startsWith("-proceedOnError")) {
                        n6 = 0;
                        n = string6.length();
                        if (n > 15) {
                            if (!string6.equals("-proceedOnError:Fatal")) throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", string6));
                            this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
                        } else {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
                        }
                        this.proceedOnError = true;
                        continue block56;
                    }
                    if (string6.equals("-time")) {
                        n6 = 0;
                        this.timing = 1;
                        continue block56;
                    }
                    if (string6.equals("-time:detail")) {
                        n6 = 0;
                        this.timing = 3;
                        continue block56;
                    }
                    if (string6.equals("-version") || string6.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (string6.equals("-showversion")) {
                        bl2 = true;
                        n6 = 0;
                        continue block56;
                    }
                    if ("-deprecation".equals(string6)) {
                        bl3 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-help") || string6.equals("-?")) {
                        bl = true;
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-help:warn") || string6.equals("-?:warn")) {
                        bl = true;
                        string2 = "misc.usage.warn";
                        continue block56;
                    }
                    if (string6.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-verbose")) {
                        this.verbose = true;
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-inlineJSR")) {
                        n6 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        continue block56;
                    }
                    if (string6.equals("-parameters")) {
                        n6 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
                        continue block56;
                    }
                    if (string6.equals("-genericsignature")) {
                        n6 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "generate");
                        continue block56;
                    }
                    if (string6.startsWith("-g")) {
                        n6 = 0;
                        String string11 = string6;
                        int n13 = string6.length();
                        if (n13 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue block56;
                        }
                        if (n13 <= 3) throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", string11));
                        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                        if (n13 == 7 && string11.equals("-g:none")) continue block56;
                        StringTokenizer stringTokenizer = new StringTokenizer(string11.substring(3, string11.length()), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string12 = stringTokenizer.nextToken();
                            if (string12.equals("vars")) {
                                this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                continue;
                            }
                            if (string12.equals("lines")) {
                                this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                continue;
                            }
                            if (!string12.equals("source")) throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", string11));
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                        }
                        continue block56;
                    }
                    if (string6.startsWith("-warn")) {
                        boolean bl7;
                        int n14;
                        n6 = 0;
                        String string13 = string6;
                        int n15 = string6.length();
                        if (n15 == 10 && string13.equals("-warn:none")) {
                            this.disableAll(0);
                            continue block56;
                        }
                        if (n15 <= 6) {
                            throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", string13));
                        }
                        switch (string13.charAt(6)) {
                            case '+': {
                                n14 = 7;
                                bl7 = true;
                                break;
                            }
                            case '-': {
                                n14 = 7;
                                bl7 = false;
                                break;
                            }
                            default: {
                                this.disableAll(0);
                                n14 = 6;
                                bl7 = true;
                            }
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string13.substring(n14, string13.length()), ",");
                        int n16 = 0;
                        if (bl3) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            ++n16;
                            switch (string9.charAt(0)) {
                                case '+': {
                                    bl7 = true;
                                    string9 = string9.substring(1);
                                    break;
                                }
                                case '-': {
                                    bl7 = false;
                                    string9 = string9.substring(1);
                                }
                            }
                            this.handleWarningToken(string9, bl7);
                        }
                        if (n16 != 0) continue block56;
                        throw new IllegalArgumentException(this.bind("configure.invalidWarningOption", string6));
                    }
                    if (string6.startsWith("-err")) {
                        boolean bl8;
                        int n17;
                        n6 = 0;
                        String string14 = string6;
                        int n18 = string6.length();
                        if (n18 <= 5) {
                            throw new IllegalArgumentException(this.bind("configure.invalidErrorConfiguration", string14));
                        }
                        switch (string14.charAt(5)) {
                            case '+': {
                                n17 = 6;
                                bl8 = true;
                                break;
                            }
                            case '-': {
                                n17 = 6;
                                bl8 = false;
                                break;
                            }
                            default: {
                                this.disableAll(1);
                                n17 = 5;
                                bl8 = true;
                            }
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string14.substring(n17, string14.length()), ",");
                        int n19 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer.nextToken();
                            ++n19;
                            switch (string9.charAt(0)) {
                                case '+': {
                                    bl8 = true;
                                    string9 = string9.substring(1);
                                    break;
                                }
                                case '-': {
                                    bl8 = false;
                                    string9 = string9.substring(1);
                                }
                            }
                            this.handleErrorToken(string9, bl8);
                        }
                        if (n19 != 0) continue block56;
                        throw new IllegalArgumentException(this.bind("configure.invalidErrorOption", string6));
                    }
                    if (string6.equals("-target")) {
                        n6 = 4;
                        continue block56;
                    }
                    if (string6.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-enableJavadoc")) {
                        n6 = 0;
                        this.enableJavadocOn = true;
                        continue block56;
                    }
                    if (string6.equals("-Xemacs")) {
                        n6 = 0;
                        this.logger.setEmacs();
                        continue block56;
                    }
                    if (string6.startsWith("-A")) {
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-processorpath")) {
                        n6 = 17;
                        continue block56;
                    }
                    if (string6.equals("-processor")) {
                        n6 = 18;
                        continue block56;
                    }
                    if (string6.equals("-proc:only")) {
                        this.options.put("org.eclipse.jdt.core.compiler.generateClassFiles", "disabled");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-proc:none")) {
                        bl5 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "disabled");
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-s")) {
                        n6 = 19;
                        continue block56;
                    }
                    if (string6.equals("-XprintProcessorInfo") || string6.equals("-XprintRounds")) {
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.startsWith("-X")) {
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.startsWith("-J")) {
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-O")) {
                        n6 = 0;
                        continue block56;
                    }
                    if (string6.equals("-classNames")) {
                        n6 = 20;
                        continue block56;
                    }
                    if (string6.equals("-properties")) {
                        n6 = 21;
                        continue block56;
                    }
                    if (string6.equals("-missingNullDefault")) {
                        this.options.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "warning");
                        continue block56;
                    }
                    if (!string6.equals("-annotationpath")) break;
                    n6 = 22;
                    continue block56;
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateTarget", string6));
                    }
                    this.didSpecifyTarget = true;
                    if (string6.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (string6.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (string6.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (string6.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (string6.equals("1.5") || string6.equals("5") || string6.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (string6.equals("1.6") || string6.equals("6") || string6.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (string6.equals("1.7") || string6.equals("7") || string6.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    } else if (string6.equals("1.8") || string6.equals("8") || string6.equals("8.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    } else if (string6.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        if (!string6.equals("cldc1.1")) throw new IllegalArgumentException(this.bind("configure.targetJDK", string6));
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "cldc1.1");
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                    }
                    n6 = 0;
                    continue block56;
                }
                case 5: {
                    this.log = string6;
                    n6 = 0;
                    continue block56;
                }
                case 6: {
                    try {
                        this.maxRepetition = Integer.parseInt(string6);
                        if (this.maxRepetition <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.repetition", string6));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(this.bind("configure.repetition", string6));
                    }
                    n6 = 0;
                    continue block56;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(string6);
                        if (this.maxProblems <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.maxProblems", string6));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(this.bind("configure.maxProblems", string6));
                    }
                    n6 = 0;
                    continue block56;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateSource", string6));
                    }
                    this.didSpecifySource = true;
                    if (string6.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (string6.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (string6.equals("1.5") || string6.equals("5") || string6.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (string6.equals("1.6") || string6.equals("6") || string6.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else if (string6.equals("1.7") || string6.equals("7") || string6.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    } else {
                        if (!string6.equals("1.8") && !string6.equals("8") && !string6.equals("8.0")) throw new IllegalArgumentException(this.bind("configure.source", string6));
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.8");
                    }
                    n6 = 0;
                    continue block56;
                }
                case 8: {
                    if (hashSet != null) {
                        if (!hashSet.contains(string6)) {
                            if (hashSet.size() > 1) {
                                this.logger.logWarning(this.bind("configure.differentencodings", string6, Main.getAllEncodings(hashSet)));
                            } else {
                                this.logger.logWarning(this.bind("configure.differentencoding", string6, Main.getAllEncodings(hashSet)));
                            }
                        }
                    } else {
                        hashSet = new HashSet<String>();
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string6);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", string6));
                    }
                    hashSet.add(string6);
                    this.options.put("org.eclipse.jdt.core.encoding", string6);
                    n6 = 0;
                    continue block56;
                }
                case 3: {
                    this.setDestinationPath(string6.equals(NONE) ? NONE : string6);
                    n6 = 0;
                    continue block56;
                }
                case 1: {
                    n6 = 0;
                    n2 += this.processPaths(stringArray2, n2, string6, arrayList3);
                    continue block56;
                }
                case 9: {
                    n6 = 0;
                    n2 += this.processPaths(stringArray2, n2, string6, arrayList);
                    continue block56;
                }
                case 13: {
                    n6 = 0;
                    String[] stringArray5 = new String[1];
                    n2 += this.processPaths(stringArray2, n2, string6, stringArray5);
                    string = stringArray5[0];
                    continue block56;
                }
                case 12: {
                    if (string6.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-extdir"));
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator, false);
                    arrayList4 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList4.add(stringTokenizer.nextToken());
                    }
                    n6 = 0;
                    continue block56;
                }
                case 15: {
                    if (string6.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-endorseddirs"));
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator, false);
                    arrayList5 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList5.add(stringTokenizer.nextToken());
                    }
                    n6 = 0;
                    continue block56;
                }
                case 16: {
                    if (!string6.endsWith("]")) throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", "[-d " + string6));
                    string4 = string6.substring(0, string6.length() - 1);
                    break;
                }
                case 17: {
                    n6 = 0;
                    continue block56;
                }
                case 18: {
                    n6 = 0;
                    continue block56;
                }
                case 19: {
                    n6 = 0;
                    continue block56;
                }
                case 20: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                    if (this.classNames == null) {
                        this.classNames = new String[4];
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        if (this.classNames.length == n4) {
                            this.classNames = new String[n4 * 2];
                            System.arraycopy(this.classNames, 0, this.classNames, 0, n4);
                        }
                        this.classNames[n4++] = stringTokenizer.nextToken();
                    }
                    n6 = 0;
                    continue block56;
                }
                case 21: {
                    this.initializeWarnings(string6);
                    n6 = 0;
                    continue block56;
                }
                case 22: {
                    n6 = 0;
                    if (string6.isEmpty() || string6.charAt(0) == '-') {
                        throw new IllegalArgumentException(this.bind("configure.missingAnnotationPath", string6));
                    }
                    if (ANNOTATION_SOURCE_CLASSPATH.equals(string6)) {
                        this.annotationsFromClasspath = true;
                        continue block56;
                    }
                    if (this.annotationPaths == null) {
                        this.annotationPaths = new ArrayList<String>();
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.annotationPaths.add(stringTokenizer.nextToken());
                    }
                    continue block56;
                }
            }
            if (string4 == null) {
                if (File.separatorChar != '/') {
                    string6 = string6.replace('/', File.separatorChar);
                }
                if (string6.endsWith("[-d")) {
                    string5 = string6.substring(0, string6.length() - 3);
                    n6 = 16;
                    continue;
                }
                string5 = string6;
            }
            if (!(file = new File(string5)).isDirectory()) {
                throw new IllegalArgumentException(this.bind("configure.unrecognizedOption", string5));
            }
            String[] stringArray6 = FileFinder.find(file, ".JAVA");
            if (NONE.equals(string4)) {
                string4 = NONE;
            }
            if (this.filenames != null) {
                n9 = stringArray6.length;
                this.filenames = new String[n9 + n3];
                System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
                this.encodings = new String[n9 + n3];
                System.arraycopy(this.encodings, 0, this.encodings, 0, n3);
                this.destinationPaths = new String[n9 + n3];
                System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, n3);
                System.arraycopy(stringArray6, 0, this.filenames, n3, n9);
                for (int i = 0; i < n9; ++i) {
                    this.encodings[n3 + i] = string3;
                    this.destinationPaths[n3 + i] = string4;
                }
                n3 += n9;
                string3 = null;
                string4 = null;
                string5 = null;
            } else {
                this.filenames = stringArray6;
                n3 = this.filenames.length;
                this.encodings = new String[n3];
                this.destinationPaths = new String[n3];
                for (n9 = 0; n9 < n3; ++n9) {
                    this.encodings[n9] = string3;
                    this.destinationPaths[n9] = string4;
                }
                string3 = null;
                string4 = null;
                string5 = null;
            }
            n6 = 0;
        }
        if (this.enableJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        } else if (this.warnJavadocOn || this.warnAllJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        }
        if (this.warnJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        }
        if (bl || n3 == 0 && n4 == 0) {
            if (string2 == null) {
                this.printUsage();
            } else {
                this.printUsage(string2);
            }
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(bl2);
        this.validateOptions(bl4);
        if (!bl5 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) >= 0x320000L) {
            this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        }
        this.logger.logCommandLineArguments(stringArray2);
        this.logger.logOptions(this.options);
        if (this.maxRepetition == 0) {
            this.maxRepetition = 1;
        }
        if (this.maxRepetition >= 3 && (this.timing & 1) != 0) {
            this.compilerStats = new CompilerStats[this.maxRepetition];
        }
        if (n3 != 0) {
            this.filenames = new String[n3];
            System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
        }
        if (n4 != 0) {
            this.classNames = new String[n4];
            System.arraycopy(this.classNames, 0, this.classNames, 0, n4);
        }
        this.setPaths(arrayList, string, arrayList2, arrayList3, arrayList4, arrayList5, string3);
        if (hashSet != null && hashSet.size() > 1) {
            this.logger.logWarning(this.bind("configure.multipleencodings", this.options.get("org.eclipse.jdt.core.encoding"), Main.getAllEncodings(hashSet)));
        }
        if (this.pendingErrors == null) return;
        for (String string15 : this.pendingErrors) {
            this.logger.logPendingError(string15);
        }
        this.pendingErrors = null;
    }

    private static char[][] decodeIgnoreOptionalProblemsFromFolders(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        char[][] cArrayArray = new char[stringTokenizer.countTokens()][];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (file.exists()) {
                try {
                    cArrayArray[n++] = file.getCanonicalPath().toCharArray();
                }
                catch (IOException iOException) {
                    cArrayArray[n++] = string2.toCharArray();
                }
                continue;
            }
            cArrayArray[n++] = string2.toCharArray();
        }
        return cArrayArray;
    }

    private static String getAllEncodings(Set set) {
        int n = set.size();
        Object[] objectArray = new String[n];
        set.toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)objectArray[i]);
        }
        return String.valueOf(stringBuffer);
    }

    private void initializeWarnings(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(this.bind("configure.missingwarningspropertiesfile", string));
        }
        BufferedInputStream bufferedInputStream = null;
        Properties properties = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            properties = new Properties();
            properties.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalArgumentException(this.bind("configure.ioexceptionwarningspropertiesfile", string));
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2 = entry.getKey().toString();
            if (!string2.startsWith("org.eclipse.jdt.core.compiler.")) continue;
            this.options.put(string2, entry.getValue().toString());
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.debug.localVariable")) {
            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.codegen.unusedLocal")) {
            this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.doc.comment.support")) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.problem.forbiddenReference")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        }
    }

    protected void enableAll(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "error";
                break;
            }
            case 0: {
                string = "warning";
            }
        }
        for (Map.Entry entry : this.options.entrySet().toArray(new Map.Entry[this.options.size()])) {
            if (!((String)entry.getValue()).equals("ignore")) continue;
            this.options.put((String)entry.getKey(), string);
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
    }

    protected void disableAll(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "error";
                break;
            }
            case 0: {
                string = "warning";
            }
        }
        Object[] objectArray = this.options.entrySet().toArray();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).equals(string)) continue;
            this.options.put((String)entry.getKey(), "ignore");
        }
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new BatchCompilerRequestor(this);
    }

    public CompilationUnit[] getCompilationUnits() {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = this.options.get("org.eclipse.jdt.core.encoding");
        if (Util.EMPTY_STRING.equals(string)) {
            string = null;
        }
        for (int i = 0; i < n; ++i) {
            String string2;
            char[] cArray = this.filenames[i].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new IllegalArgumentException(this.bind("unit.more", this.filenames[i]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new IllegalArgumentException(this.bind("unit.missing", this.filenames[i]));
            }
            String string3 = this.encodings[i];
            if (string3 == null) {
                string3 = string;
            }
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = this.filenames[i];
            }
            compilationUnitArray[i] = new CompilationUnit(null, string2, string3, this.destinationPaths[i], Main.shouldIgnoreOptionalProblems(this.ignoreOptionalProblemsFromFolders, string2.toCharArray()));
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            this.javaHomeCache = Util.getJavaHome();
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames, this.annotationsFromClasspath && "enabled".equals(this.options.get("org.eclipse.jdt.core.compiler.annotation.nullanalysis")));
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected ArrayList handleBootclasspath(ArrayList arrayList, String string) {
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            String[] stringArray = new String[n];
            arrayList.toArray(stringArray);
            arrayList.clear();
            for (int i = 0; i < n; ++i) {
                this.processPathEntries(4, arrayList, stringArray[i], string, false, true);
            }
        } else {
            arrayList = new ArrayList(4);
            try {
                Util.collectRunningVMBootclasspath(arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return null;
            }
        }
        return arrayList;
    }

    protected ArrayList handleClasspath(ArrayList arrayList, String string) {
        FileSystem.Classpath classpath;
        Object object;
        Object object2;
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            object2 = new String[n];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            for (int i = 0; i < n; ++i) {
                this.processPathEntries(4, arrayList, (String)object2[i], string, false, true);
            }
        } else {
            arrayList = new ArrayList<FileSystem.Classpath>(4);
            object2 = System.getProperty("java.class.path");
            if (object2 == null || ((String)object2).length() == 0) {
                this.addPendingErrors(this.bind("configure.noClasspath"));
                FileSystem.Classpath classpath2 = FileSystem.getClasspath(System.getProperty("user.dir"), string, null, this.options);
                if (classpath2 != null) {
                    arrayList.add(classpath2);
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    classpath = FileSystem.getClasspath((String)object, string, null, this.options);
                    if (classpath != null) {
                        arrayList.add(classpath);
                        continue;
                    }
                    if (((String)object).length() == 0) continue;
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", (String)object));
                }
            }
        }
        object2 = new ArrayList();
        HashMap<String, FileSystem.Classpath> hashMap = new HashMap<String, FileSystem.Classpath>();
        object = new FileSystem.ClasspathSectionProblemReporter(){

            @Override
            public void invalidClasspathSection(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.invalidClasspathSection", string));
            }

            @Override
            public void multipleClasspathSections(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.multipleClasspathSections", string));
            }
        };
        while (!arrayList.isEmpty()) {
            classpath = (FileSystem.Classpath)arrayList.remove(0);
            String string2 = classpath.getPath();
            if (hashMap.get(string2) != null) continue;
            hashMap.put(string2, classpath);
            ((ArrayList)object2).add(classpath);
            List list = classpath.fetchLinkedJars((FileSystem.ClasspathSectionProblemReporter)object);
            if (list == null) continue;
            arrayList.addAll(0, list);
        }
        return object2;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(file.getAbsolutePath() + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null, this.options);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.addPendingErrors(this.bind("configure.incorrectEndorsedDirsEntry", object[i].getAbsolutePath()));
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(file.getAbsolutePath() + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null, this.options);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.addPendingErrors(this.bind("configure.incorrectExtDirsEntry", object[i].getAbsolutePath()));
                }
            }
        }
        return arrayList;
    }

    protected void handleWarningToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 0);
    }

    protected void handleErrorToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 1);
    }

    private void setSeverity(String string, int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1: {
                    this.options.put(string, "error");
                    break;
                }
                case 0: {
                    this.options.put(string, "warning");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    String string2 = this.options.get(string);
                    if (!"error".equals(string2)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                case 0: {
                    String string3 = this.options.get(string);
                    if (!"warning".equals(string3)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                }
            }
        }
    }

    private void handleErrorOrWarningToken(String string, boolean bl, int n) {
        if (string.length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case 'a': {
                if (string.equals("allDeprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allJavadoc")) {
                    this.warnAllJavadocOn = this.warnJavadocOn = bl;
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    return;
                }
                if (string.equals("assertIdentifier")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.assertIdentifier", n, bl);
                    return;
                }
                if (string.equals("allDeadCode")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allOver-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("all-static-method")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", n, bl);
                    return;
                }
                if (!string.equals("all")) break;
                if (bl) {
                    this.enableAll(n);
                } else {
                    this.disableAll(n);
                }
                return;
            }
            case 'b': {
                if (!string.equals("boxing")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.autoboxing", n, bl);
                return;
            }
            case 'c': {
                if (string.equals("constructorName")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", n, bl);
                    return;
                }
                if (string.equals("conditionAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", n, bl);
                    return;
                }
                if (string.equals("compareIdentical")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.comparingIdentical", n, bl);
                    return;
                }
                if (!string.equals("charConcat")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                return;
            }
            case 'd': {
                if (string.equals("deprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
                    return;
                }
                if (string.equals("dep-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", n, bl);
                    return;
                }
                if (string.equals("discouraged")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.discouragedReference", n, bl);
                    return;
                }
                if (!string.equals("deadCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "disabled");
                return;
            }
            case 'e': {
                if (string.equals("enumSwitch")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                    return;
                }
                if (string.equals("enumSwitchPedantic")) {
                    if (bl) {
                        switch (n) {
                            case 1: {
                                this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                                break;
                            }
                            case 0: {
                                if (!"ignore".equals(this.options.get("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"))) break;
                                this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                                break;
                            }
                        }
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("emptyBlock")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", n, bl);
                    return;
                }
                if (!string.equals("enumIdentifier")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.enumIdentifier", n, bl);
                return;
            }
            case 'f': {
                if (string.equals("fieldHiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    return;
                }
                if (string.equals("finalBound")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finalParameterBound", n, bl);
                    return;
                }
                if (string.equals("finally")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", n, bl);
                    return;
                }
                if (string.equals("forbidden")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.forbiddenReference", n, bl);
                    return;
                }
                if (!string.equals("fallthrough")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.fallthroughCase", n, bl);
                return;
            }
            case 'h': {
                if (string.equals("hiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                    return;
                }
                if (!string.equals("hashCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", n, bl);
                return;
            }
            case 'i': {
                if (string.equals("indirectStatic")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("inheritNullAnnot")) {
                    this.options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", n, bl);
                    return;
                }
                if (string.equals("intfAnnotation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", n, bl);
                    return;
                }
                if (string.equals("intfRedundant")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                    return;
                }
                if (string.equals("includeAssertNull")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadoc")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("invalidJavadocTag")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadocTagDep")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadocTagNotVisible")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", bl ? "enabled" : "disabled");
                    return;
                }
                if (!string.startsWith("invalidJavadocTagVisibility")) break;
                int n2 = string.indexOf(40);
                int n3 = string.indexOf(41);
                String string2 = null;
                if (bl && n2 >= 0 && n3 >= 0 && n2 < n3) {
                    string2 = string.substring(n2 + 1, n3).trim();
                }
                if (string2 != null && string2.equals("public") || string2.equals("private") || string2.equals("protected") || string2.equals("default")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", string2);
                    return;
                }
                throw new IllegalArgumentException(this.bind("configure.invalidJavadocTagVisibility", string));
            }
            case 'j': {
                if (!string.equals("javadoc")) break;
                this.warnJavadocOn = bl;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                return;
            }
            case 'l': {
                if (!string.equals("localHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                return;
            }
            case 'm': {
                if (string.equals("maskedCatchBlock") || string.equals("maskedCatchBlocks")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                    return;
                }
                if (string.equals("missingJavadocTags")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("missingJavadocTagsOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("missingJavadocTagsMethod")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.startsWith("missingJavadocTagsVisibility")) {
                    int n4 = string.indexOf(40);
                    int n5 = string.indexOf(41);
                    String string3 = null;
                    if (bl && n4 >= 0 && n5 >= 0 && n4 < n5) {
                        string3 = string.substring(n4 + 1, n5).trim();
                    }
                    if (string3 != null && string3.equals("public") || string3.equals("private") || string3.equals("protected") || string3.equals("default")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", string3);
                        return;
                    }
                    throw new IllegalArgumentException(this.bind("configure.missingJavadocTagsVisibility", string));
                }
                if (string.equals("missingJavadocComments")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("missingJavadocCommentsOverriding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (!string.startsWith("missingJavadocCommentsVisibility")) break;
                int n6 = string.indexOf(40);
                int n7 = string.indexOf(41);
                String string4 = null;
                if (bl && n6 >= 0 && n7 >= 0 && n6 < n7) {
                    string4 = string.substring(n6 + 1, n7).trim();
                }
                if (string4 != null && string4.equals("public") || string4.equals("private") || string4.equals("protected") || string4.equals("default")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", string4);
                    return;
                }
                throw new IllegalArgumentException(this.bind("configure.missingJavadocCommentsVisibility", string));
            }
            case 'n': {
                if (string.equals("nls")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", n, bl);
                    return;
                }
                if (string.equals("noEffectAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", n, bl);
                    return;
                }
                if (string.equals("noImplicitStringConversion")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                    return;
                }
                if (string.equals("null")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", n, bl);
                    return;
                }
                if (string.equals("nullDereference")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                    if (!bl) {
                        this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", 256, bl);
                        this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", 256, bl);
                    }
                    return;
                }
                if (string.equals("nullAnnotConflict")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", n, bl);
                    return;
                }
                if (string.equals("nullAnnotRedundant")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", n, bl);
                    return;
                }
                if (string.startsWith("nullAnnot")) {
                    String string5 = Util.EMPTY_STRING;
                    int n8 = string.indexOf(40);
                    int n9 = string.indexOf(41);
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    if (bl && n8 >= 0 && n9 >= 0 && n8 < n9) {
                        boolean bl2 = !this.primaryNullAnnotationsSeen;
                        string5 = string.substring(n8 + 1, n9).trim();
                        int n10 = string5.indexOf(124);
                        if (n10 == -1) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string7 = string5.substring(0, n10).trim();
                        if (bl2 && string7.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        int n11 = string5.indexOf(124, n10 + 1);
                        if (n11 == -1) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string6 = string5.substring(n10 + 1, n11).trim();
                        if (bl2 && string6.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string8 = string5.substring(n11 + 1).trim();
                        if (bl2 && string8.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        if (bl2) {
                            this.primaryNullAnnotationsSeen = true;
                            this.options.put("org.eclipse.jdt.core.compiler.annotation.nullable", string7);
                            this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", string6);
                            this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", string8);
                        } else {
                            String string9;
                            if (string7.length() > 0) {
                                string9 = this.options.get("org.eclipse.jdt.core.compiler.annotation.nullable.secondary");
                                string9 = string9.isEmpty() ? string7 : string9 + ',' + string7;
                                this.options.put("org.eclipse.jdt.core.compiler.annotation.nullable.secondary", string9);
                            }
                            if (string6.length() > 0) {
                                string9 = this.options.get("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary");
                                string9 = string9.isEmpty() ? string6 : string9 + ',' + string6;
                                this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnull.secondary", string9);
                            }
                            if (string8.length() > 0) {
                                string9 = this.options.get("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary");
                                string9 = string9.isEmpty() ? string8 : string9 + ',' + string8;
                                this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", string9);
                            }
                        }
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", bl ? "enabled" : "disabled");
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", n, bl);
                    return;
                }
                if (string.equals("nullUncheckedConversion")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", n, bl);
                    return;
                }
                if (!string.equals("nonnullNotRepeated")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", n, bl);
                return;
            }
            case 'o': {
                if (string.equals("over-sync")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (!string.equals("over-ann")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
                return;
            }
            case 'p': {
                if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", n, bl);
                    return;
                }
                if (!string.equals("paramAssign")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.parameterAssignment", n, bl);
                return;
            }
            case 'r': {
                if (string.equals("raw")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.rawTypeReference", n, bl);
                    return;
                }
                if (string.equals("redundantSuperinterface")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                    return;
                }
                if (!string.equals("resource")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", n, bl);
                return;
            }
            case 's': {
                if (string.equals("specialParamHiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", n, bl);
                    return;
                }
                if (string.equals("staticReceiver")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    return;
                }
                if (string.equals("syncOverride")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (string.equals("semicolon")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.emptyStatement", n, bl);
                    return;
                }
                if (string.equals("serial")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", n, bl);
                    return;
                }
                if (string.equals("suppress")) {
                    switch (n) {
                        case 0: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "disabled");
                            break;
                        }
                        case 1: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", bl ? "enabled" : "disabled");
                        }
                    }
                    return;
                }
                if (string.equals("static-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("super")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", n, bl);
                    return;
                }
                if (string.equals("static-method")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                    return;
                }
                if (string.equals("switchDefault")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", n, bl);
                    return;
                }
                if (!string.equals("syntacticAnalysis")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", bl ? "enabled" : "disabled");
                return;
            }
            case 't': {
                if (string.startsWith("tasks")) {
                    String string10 = Util.EMPTY_STRING;
                    int n12 = string.indexOf(40);
                    int n13 = string.indexOf(41);
                    if (n12 >= 0 && n13 >= 0 && n12 < n13) {
                        string10 = string.substring(n12 + 1, n13).trim();
                        string10 = string10.replace('|', ',');
                    }
                    if (string10.length() == 0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidTaskTag", string));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string10 : Util.EMPTY_STRING);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.tasks", n, bl);
                    return;
                }
                if (!string.equals("typeHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                return;
            }
            case 'u': {
                if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    return;
                }
                if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    return;
                }
                if (string.equals("unusedExceptionParam")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", n, bl);
                    return;
                }
                if (string.equals("unusedImport") || string.equals("unusedImports")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    return;
                }
                if (string.equals("unusedAllocation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", n, bl);
                    return;
                }
                if (string.equals("unusedPrivate")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    return;
                }
                if (string.equals("unusedLabel")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    return;
                }
                if (string.equals("uselessTypeCheck")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", n, bl);
                    return;
                }
                if (string.equals("unchecked") || string.equals("unsafe")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", n, bl);
                    return;
                }
                if (string.equals("unnecessaryElse")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", n, bl);
                    return;
                }
                if (string.equals("unusedThrown")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    return;
                }
                if (string.equals("unusedThrownWhenOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedThrownIncludeDocComment")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedThrownExemptExceptionThrowable")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", n, bl);
                    return;
                }
                if (string.equals("unused")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", n, bl);
                    return;
                }
                if (string.equals("unusedParam")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    return;
                }
                if (string.equals("unusedTypeParameter")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", n, bl);
                    return;
                }
                if (string.equals("unusedParamIncludeDoc")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedParamOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedParamImplementing")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedTypeArgs")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    return;
                }
                if (!string.equals("unavoidableGenericProblems")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", bl ? "enabled" : "disabled");
                return;
            }
            case 'v': {
                if (!string.equals("varargsCast")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", n, bl);
                return;
            }
            case 'w': {
                if (!string.equals("warningToken")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", n, bl);
                return;
            }
        }
        String string11 = null;
        switch (n) {
            case 0: {
                string11 = this.bind("configure.invalidWarning", string);
                break;
            }
            case 1: {
                string11 = this.bind("configure.invalidError", string);
            }
        }
        this.addPendingErrors(string11);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map<String, String> map, CompilationProgress compilationProgress) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.proceed = true;
        this.out = printWriter;
        this.err = printWriter2;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        this.ignoreOptionalProblemsFromFolders = null;
        this.progress = compilationProgress;
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    protected void initializeAnnotationProcessorManager() {
        String string = "org.eclipse.jdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager";
        try {
            Class<?> clazz = Class.forName(string);
            AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = (AbstractAnnotationProcessorManager)clazz.newInstance();
            abstractAnnotationProcessorManager.configure(this, this.expandedCommandLine);
            abstractAnnotationProcessorManager.setErr(this.err);
            abstractAnnotationProcessorManager.setOut(this.out);
            this.batchCompiler.annotationProcessorManager = abstractAnnotationProcessorManager;
        }
        catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
            this.logger.logUnavaibleAPT(string);
            throw new AbortCompilation();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbortCompilation();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.logger.logIncorrectVMVersionForAnnotationProcessing();
        }
    }

    private static boolean isParentOf(char[] cArray, char[] cArray2) {
        if (cArray.length >= cArray2.length) {
            return false;
        }
        if (cArray2[cArray.length] != '\\' && cArray2[cArray.length] != '/') {
            return false;
        }
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            String string = null;
            boolean bl = false;
            CompilationUnit compilationUnit = (CompilationUnit)compilationResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    string = this.extractDestinationPathFromSourceFile(compilationResult);
                } else if (this.destinationPath != NONE) {
                    string = this.destinationPath;
                    bl = true;
                }
            } else if (compilationUnit.destinationPath != NONE) {
                string = compilationUnit.destinationPath;
                bl = true;
            }
            if (string != null) {
                int n = classFileArray.length;
                for (int i = 0; i < n; ++i) {
                    ClassFile classFile = classFileArray[i];
                    char[] cArray = classFile.fileName();
                    int n2 = cArray.length;
                    char[] cArray2 = new char[n2 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n2, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string2 = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                        }
                        Util.writeToDisk(bl, string, string2, classFile);
                        this.logger.logClassFile(bl, string, string2);
                        ++this.exportedClassFilesCounter;
                        continue;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(string, string2, iOException);
                    }
                }
                this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
            }
        }
    }

    public void performCompilation() {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler(fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out, this.progress);
        this.batchCompiler.remainingIterations = this.maxRepetition - this.currentRepetition;
        String string = System.getProperty("jdt.compiler.useSingleThread");
        boolean bl = this.batchCompiler.useSingleThread = string != null && string.equals("true");
        if (this.compilerOptions.complianceLevel >= 0x320000L && this.compilerOptions.processAnnotations) {
            if (this.checkVMVersion(0x320000L)) {
                this.initializeAnnotationProcessorManager();
                if (this.classNames != null) {
                    this.batchCompiler.setBinaryTypes(this.processClassNames(this.batchCompiler.lookupEnvironment));
                }
            } else {
                this.logger.logIncorrectVMVersionForAnnotationProcessing();
            }
        }
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        finally {
            this.logger.endLoggingSources();
        }
        if (this.extraProblems != null) {
            this.loggingExtraProblems();
            this.extraProblems = null;
        }
        if (this.compilerStats != null) {
            this.compilerStats[this.currentRepetition] = this.batchCompiler.stats;
        }
        this.logger.printStats();
        fileSystem.cleanup();
    }

    protected void loggingExtraProblems() {
        this.logger.loggingExtraProblems(this);
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String string) {
        this.logger.logUsage(this.bind(string, new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
        this.logger.flush();
    }

    private ReferenceBinding[] processClassNames(LookupEnvironment lookupEnvironment) {
        int n = this.classNames.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = this.classNames[i];
            Object object2 = null;
            if (string.indexOf(46) != -1) {
                object = string.toCharArray();
                object2 = CharOperation.splitOn('.', (char[])object);
            } else {
                object2 = new char[][]{string.toCharArray()};
            }
            object = lookupEnvironment.getType((char[][])object2);
            if (object != null && ((Binding)object).isValidBinding()) {
                if (!((ReferenceBinding)object).isBinaryBinding()) continue;
                referenceBindingArray[i] = object;
                continue;
            }
            throw new IllegalArgumentException(this.bind("configure.invalidClassName", string));
        }
        return referenceBindingArray;
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = "";
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        for (int i = n5; i < n3; ++i) {
                            string3 = string3 + (String)arrayList3.get(i);
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
            default: {
                if (string.length() == 0) break;
                this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
            }
        }
    }

    private int processPaths(String[] stringArray, int n, String string, ArrayList arrayList) {
        int n2 = n;
        int n3 = 0;
        int n4 = string.length();
        block8: for (int i = 0; i < n4; ++i) {
            switch (string.charAt(i)) {
                case '[': {
                    ++n3;
                    continue block8;
                }
                case ']': {
                    --n3;
                }
            }
        }
        if (n3 != 0) {
            if (n3 > 1) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[++n2];
                int n5 = string2.length();
                block10: for (int i = 0; i < n5; ++i) {
                    switch (string2.charAt(i)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                            }
                            ++n3;
                            continue block10;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    arrayList.add(stringBuffer.toString());
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        arrayList.add(string);
        return n2 - n;
    }

    private int processPaths(String[] stringArray, int n, String string, String[] stringArray2) {
        int n2 = n;
        int n3 = 0;
        int n4 = string.length();
        block8: for (int i = 0; i < n4; ++i) {
            switch (string.charAt(i)) {
                case '[': {
                    ++n3;
                    continue block8;
                }
                case ']': {
                    --n3;
                }
            }
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (++n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[n2];
                int n5 = string2.length();
                block10: for (int i = 0; i < n5; ++i) {
                    switch (string2.charAt(i)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                            }
                            ++n3;
                            continue block10;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringArray2[0] = stringBuffer.toString();
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        stringArray2[0] = string;
        return n2 - n;
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) {
        arrayList = this.handleBootclasspath(arrayList, string2);
        arrayList3 = this.handleClasspath(arrayList3, string2);
        if (string != null) {
            this.processPathEntries(4, arrayList2, string, string2, true, false);
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(0, arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        arrayList3 = FileSystem.ClasspathNormalizer.normalize(arrayList3);
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
        if (this.annotationPaths != null && "enabled".equals(this.options.get("org.eclipse.jdt.core.compiler.annotation.nullanalysis"))) {
            for (FileSystem.Classpath classpath : this.checkedClasspaths) {
                if (!(classpath instanceof ClasspathJar)) continue;
                ((ClasspathJar)classpath).annotationPaths = this.annotationPaths;
            }
        }
    }

    private static boolean shouldIgnoreOptionalProblems(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray2 == null) {
            return false;
        }
        for (char[] cArray3 : cArray) {
            if (!Main.isParentOf(cArray3, cArray2)) continue;
            return true;
        }
        return false;
    }

    protected void validateOptions(boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(string2)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(string2)) {
                if (this.didSpecifySource) {
                    string = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                        }
                    } else if ("1.4".equals(string) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    }
                }
            } else if ("1.5".equals(string2)) {
                if (this.didSpecifySource) {
                    string = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(string) || "1.4".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(string) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                }
            } else if ("1.6".equals(string2)) {
                if (this.didSpecifySource) {
                    string = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(string) || "1.4".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if (("1.5".equals(string) || "1.6".equals(string)) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                }
            } else if ("1.7".equals(string2)) {
                if (this.didSpecifySource) {
                    string = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(string) || "1.4".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(string) || "1.6".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(string) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                }
            } else if ("1.8".equals(string2)) {
                if (this.didSpecifySource) {
                    string = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(string) || "1.4".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(string) || "1.6".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(string)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                        }
                    } else if ("1.8".equals(string) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.8");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    }
                }
            }
        } else if (this.didSpecifySource) {
            string2 = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(string2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(string2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(string2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            } else if ("1.7".equals(string2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                }
            } else if ("1.8".equals(string2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                }
            }
        }
        string2 = this.options.get("org.eclipse.jdt.core.compiler.source");
        string = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (string2.equals("1.8") && CompilerOptions.versionToJdkLevel(string) < 0x340000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.8"));
        }
        if (string2.equals("1.7") && CompilerOptions.versionToJdkLevel(string) < 0x330000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.7"));
        }
        if (string2.equals("1.6") && CompilerOptions.versionToJdkLevel(string) < 0x320000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (string2.equals("1.5") && CompilerOptions.versionToJdkLevel(string) < 0x310000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (string2.equals("1.4") && CompilerOptions.versionToJdkLevel(string) < 0x300000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            String string3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(string3)) {
                if (CompilerOptions.versionToJdkLevel(string2) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForGenericSource", string3, string2));
                }
            } else if ("cldc1.1".equals(string3)) {
                if (this.didSpecifySource && CompilerOptions.versionToJdkLevel(string2) >= 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleSourceForCldcTarget", string3, string2));
                }
                if (CompilerOptions.versionToJdkLevel(string) >= 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForCldcTarget", string3, string2));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(string2) >= 0x340000L && CompilerOptions.versionToJdkLevel(string3) < 0x340000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", string3, "1.8"));
                }
                if (CompilerOptions.versionToJdkLevel(string2) >= 0x330000L && CompilerOptions.versionToJdkLevel(string3) < 0x330000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", string3, "1.7"));
                }
                if (CompilerOptions.versionToJdkLevel(string2) >= 0x320000L && CompilerOptions.versionToJdkLevel(string3) < 0x320000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", string3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(string2) >= 0x310000L && CompilerOptions.versionToJdkLevel(string3) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", string3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(string2) >= 0x300000L && CompilerOptions.versionToJdkLevel(string3) < 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", string3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(string) < CompilerOptions.versionToJdkLevel(string3)) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForTarget", this.options.get("org.eclipse.jdt.core.compiler.compliance"), string3));
                }
            }
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle resourceBundle = (ResourceBundle)Cache.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(Main.bundleName, locale);
                Cache.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
    }

    public static class Logger {
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String WARNING_TAG = "warning";
        private static final String EXCEPTION = "exception";
        private static final String EXTRA_PROBLEM_TAG = "extra_problem";
        private static final String EXTRA_PROBLEMS = "extra_problems";
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String OUTPUT = "output";
        private static final String PACKAGE = "package";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_CATEGORY_ID = "categoryID";
        private static final String ID = "id";
        private static final String PROBLEM_ID = "problemID";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_OPTION_KEY = "optionKey";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.004 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_004.dtd\">";

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingExtraProblems() {
            this.endTag(EXTRA_PROBLEMS);
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).endTag(string, true, true);
            }
        }

        private String errorReportSource(CategorizedProblem categorizedProblem, char[] cArray, int n) {
            int n2;
            int n3;
            char c;
            int n4;
            int n5;
            int n6 = categorizedProblem.getSourceStart();
            int n7 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (n6 > n7 || n6 < 0 && n7 < 0 || cArray == null || (n5 = cArray.length) == 0) {
                return Messages.problem_noSourceInformation;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 2) == 0) {
                stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(categorizedProblem.getSourceLineNumber())));
                stringBuffer.append(Util.LINE_SEPARATOR);
            }
            stringBuffer.append('\t');
            int n8 = n4 = n6 >= n5 ? n5 - 1 : n6;
            while (n4 > 0 && (c = cArray[n4 - 1]) != '\n' && c != '\r') {
                --n4;
            }
            int n9 = n3 = n7 >= n5 ? n5 - 1 : n7;
            while (n3 + 1 < n5 && (c = cArray[n3 + 1]) != '\r' && c != '\n') {
                ++n3;
            }
            while ((c = cArray[n4]) == ' ' || c == '\t') {
                ++n4;
            }
            stringBuffer.append(cArray, n4, n3 - n4 + 1);
            stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
            for (n2 = n4; n2 < n6; ++n2) {
                stringBuffer.append(cArray[n2] == '\t' ? (char)'\t' : ' ');
            }
            for (n2 = n6; n2 <= (n7 >= n5 ? n5 - 1 : n7); ++n2) {
                stringBuffer.append('^');
            }
            return stringBuffer.toString();
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            int n;
            char c;
            int n2;
            int n3;
            int n4 = categorizedProblem.getSourceStart();
            int n5 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (n4 > n5 || n4 < 0 && n5 < 0 || cArray == null || (n3 = cArray.length) <= 0 || n5 > n3) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
                return;
            }
            int n6 = n2 = n4 >= n3 ? n3 - 1 : n4;
            while (n2 > 0 && (c = cArray[n2 - 1]) != '\n' && c != '\r') {
                --n2;
            }
            int n7 = n = n5 >= n3 ? n3 - 1 : n5;
            while (n + 1 < n3 && (c = cArray[n + 1]) != '\r' && c != '\n') {
                ++n;
            }
            while ((c = cArray[n2]) == ' ' || c == '\t') {
                ++n2;
            }
            while ((c = cArray[n]) == ' ' || c == '\t') {
                --n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n2, n - n2 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n4 - n2));
            this.parameters.put(SOURCE_END, Integer.toString(n5 - n2));
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            int n2 = n & 0xFFFFFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            return (String)FIELD_TABLE.get(n2);
        }

        private String getProblemOptionKey(int n) {
            int n2 = ProblemReporter.getIrritant(n);
            return CompilerOptions.optionKeyFromIrritant(n2);
        }

        public void logAverage() {
            Arrays.sort(this.main.compilerStats);
            long l = this.main.compilerStats[0].lineCount;
            int n = this.main.maxRepetition;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            int n2 = n - 1;
            for (int i = 1; i < n2; ++i) {
                CompilerStats compilerStats = this.main.compilerStats[i];
                l2 += compilerStats.elapsedTime();
                l3 += compilerStats.parseTime;
                l4 += compilerStats.resolveTime;
                l5 += compilerStats.analyzeTime;
                l6 += compilerStats.generateTime;
            }
            long l7 = l2 / (long)(n - 2);
            long l8 = l3 / (long)(n - 2);
            long l9 = l4 / (long)(n - 2);
            long l10 = l5 / (long)(n - 2);
            long l11 = l6 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l7), String.valueOf((double)((int)((double)l * 10000.0 / (double)l7)) / 10.0)}));
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(l8), String.valueOf((double)((int)((double)l8 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l9), String.valueOf((double)((int)((double)l9 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l10), String.valueOf((double)((int)((double)l10 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l11), String.valueOf((double)((int)((double)l11 * 1000.0 / (double)l7)) / 10.0)}));
            }
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? string + string2 : string + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? string + string2.substring(n + 1, n2) : string + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    String string = classpathArray[i].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isPotentialZipArchive(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 == null) continue;
                    this.parameters.put("id", string2);
                    this.printTag(CLASSPATH, this.parameters, true, true);
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        private void logExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            char[] cArray = categorizedProblem.getOriginatingFileName();
            if (cArray == null) {
                if (categorizedProblem.isError()) {
                    this.printErr(this.main.bind("requestor.extraerror", Integer.toString(n2)));
                } else {
                    this.printErr(this.main.bind("requestor.extrawarning", Integer.toString(n2)));
                }
                this.printErr(" ");
                this.printlnErr(categorizedProblem.getMessage());
            } else {
                String string = new String(cArray);
                if ((this.tagBits & 2) != 0) {
                    String string2 = string + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                    this.printlnErr(string2);
                    String string3 = this.errorReportSource(categorizedProblem, null, this.tagBits);
                    this.printlnErr(string3);
                } else {
                    if (n == 0) {
                        this.printlnErr("----------");
                    }
                    this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(string)) : this.main.bind("requestor.warning", Integer.toString(n2), new String(string)));
                    String string4 = this.errorReportSource(categorizedProblem, null, 0);
                    this.printlnErr(string4);
                    this.printlnErr(categorizedProblem.getMessage());
                    this.printlnErr("----------");
                }
            }
        }

        public void loggingExtraProblems(Main main) {
            ArrayList arrayList = main.extraProblems;
            int n = arrayList.size();
            int n2 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    categorizedProblem = (CategorizedProblem)arrayList.get(n3);
                    if (categorizedProblem == null) continue;
                    ++main.globalProblemsCount;
                    this.logExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                    ++n2;
                    if (categorizedProblem.isError()) {
                        ++n4;
                        ++main.globalErrorsCount;
                        continue;
                    }
                    if (!categorizedProblem.isWarning()) continue;
                    ++main.globalWarningsCount;
                    ++n5;
                }
                if ((this.tagBits & 1) != 0 && n4 + n5 != 0) {
                    this.startLoggingExtraProblems(n);
                    for (n3 = 0; n3 < n; ++n3) {
                        categorizedProblem = (CategorizedProblem)arrayList.get(n3);
                        if (categorizedProblem == null || categorizedProblem.getID() == 536871362) continue;
                        this.logXmlExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                    }
                    this.endLoggingExtraProblems();
                }
            }
        }

        public void logUnavaibleAPT(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.unavailableAPT", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.unavailableAPT", string));
        }

        public void logIncorrectVMVersionForAnnotationProcessing() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectVMVersionforAPT"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectVMVersionforAPT"));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", n);
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map<String, String> map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set<Map.Entry<String, String>> set = map.entrySet();
                Map.Entry[] entryArray = set.toArray(new Map.Entry[set.size()]);
                Arrays.sort(entryArray, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
                        Map.Entry<String, String> entry3 = entry;
                        Map.Entry<String, String> entry4 = entry2;
                        return entry3.getKey().compareTo(entry4.getKey());
                    }
                });
                for (Map.Entry entry : entryArray) {
                    String string = (String)entry.getKey();
                    this.parameters.put(KEY, string);
                    this.parameters.put("value", entry.getValue());
                    this.printTag(OPTION, this.parameters, true, true);
                }
                this.endTag(OPTIONS);
            }
        }

        public void logPendingError(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(string);
        }

        public void logWarning(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(WARNING_TAG, this.parameters, true, true);
            }
            this.printlnOut(string);
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = new String(categorizedProblem.getOriginatingFileName()) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = this.errorReportSource(categorizedProblem, cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = this.errorReportSource(categorizedProblem, cArray, 0);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    categorizedProblem = categorizedProblemArray[n4];
                    if (categorizedProblem == null) continue;
                    ++main.globalProblemsCount;
                    this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                    ++n3;
                    if (categorizedProblem.isError()) {
                        ++n2;
                        ++n5;
                        ++main.globalErrorsCount;
                        continue;
                    }
                    if (categorizedProblem.getID() == 536871362) {
                        ++main.globalTasksCount;
                        ++n7;
                        continue;
                    }
                    ++main.globalWarningsCount;
                    ++n6;
                }
                if ((this.tagBits & 1) != 0) {
                    if (n5 + n6 != 0) {
                        this.startLoggingProblems(n5, n6);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() == 536871362) continue;
                            this.logXmlProblem(categorizedProblem, cArray);
                        }
                        this.endLoggingProblems();
                    }
                    if (n7 != 0) {
                        this.startLoggingTasks(n7);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() != 536871362) continue;
                            this.logXmlTask(categorizedProblem, cArray);
                        }
                        this.endLoggingTasks();
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", n);
                this.parameters.put(NUMBER_OF_ERRORS, n2);
                this.parameters.put(NUMBER_OF_WARNINGS, n3);
                this.parameters.put("tasks", n4);
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 1) == 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(CompilerStats compilerStats) {
            long l = compilerStats.elapsedTime();
            long l2 = compilerStats.lineCount;
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", l);
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", l2);
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", new String[]{String.valueOf(l)}));
            }
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(compilerStats.parseTime), String.valueOf((double)((int)((double)compilerStats.parseTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.resolveTime), String.valueOf((double)((int)((double)compilerStats.resolveTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.analyzeTime), String.valueOf((double)((int)((double)compilerStats.analyzeTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.generateTime), String.valueOf((double)((int)((double)compilerStats.generateTime * 1000.0 / (double)l)) / 10.0)}));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            boolean bl = categorizedProblem.isError();
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, categorizedProblem.getSourceLineNumber());
            this.parameters.put(PROBLEM_SOURCE_START, n3);
            this.parameters.put(PROBLEM_SOURCE_END, n4);
            this.printTag(EXTRA_PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, null);
            this.endTag(EXTRA_PROBLEM_TAG);
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            int n3 = categorizedProblem.getID();
            this.parameters.put("id", this.getFieldName(n3));
            this.parameters.put(PROBLEM_ID, n3);
            boolean bl = categorizedProblem.isError();
            int n4 = bl ? 1 : 0;
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, categorizedProblem.getSourceLineNumber());
            this.parameters.put(PROBLEM_SOURCE_START, n);
            this.parameters.put(PROBLEM_SOURCE_END, n2);
            String string = this.getProblemOptionKey(n3);
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            int n5 = ProblemReporter.getProblemCategory(n4, n3);
            this.parameters.put(PROBLEM_CATEGORY_ID, n5);
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            String[] stringArray = categorizedProblem.getArguments();
            int n6 = stringArray.length;
            if (n6 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                for (int i = 0; i < n6; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, categorizedProblem.getSourceLineNumber());
            this.parameters.put(PROBLEM_SOURCE_START, categorizedProblem.getSourceStart());
            this.parameters.put(PROBLEM_SOURCE_END, categorizedProblem.getSourceEnd());
            String string = this.getProblemOptionKey(categorizedProblem.getID());
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl;
            boolean bl2 = bl = (this.main.timing & 1) != 0;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                CompilerStats compilerStats = this.main.batchCompiler.stats;
                compilerStats.startTime = this.main.startTime;
                compilerStats.endTime = System.currentTimeMillis();
                this.logTiming(compilerStats);
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            }
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
            try {
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    if (string.substring(n).toLowerCase().equals(".xml")) {
                        this.log = new GenericXMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"), Util.LINE_SEPARATOR, true);
                        this.tagBits |= 1;
                        this.log.println("<!-- " + dateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                    }
                } else {
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLog", string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLogInvalidEncoding", string));
            }
        }

        private void startLoggingExtraProblems(int n) {
            this.parameters.put("problems", n);
            this.printTag(EXTRA_PROBLEMS, this.parameters, true, false);
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", n + n2);
            this.parameters.put(NUMBER_OF_ERRORS, n);
            this.parameters.put(NUMBER_OF_WARNINGS, n2);
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                if (iCompilationUnit != null) {
                    char[][] cArray;
                    char[] cArray2 = iCompilationUnit.getFileName();
                    File file = new File(new String(cArray2));
                    if (cArray2 != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                    if ((cArray = compilationResult.packageName) != null) {
                        this.parameters.put(PACKAGE, new String(CharOperation.concatWith(cArray, File.separatorChar)));
                    }
                    CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnit;
                    String string = compilationUnit.destinationPath;
                    if (string == null) {
                        string = this.main.destinationPath;
                    }
                    if (string != null && string != Main.NONE) {
                        if (File.separatorChar == '/') {
                            this.parameters.put(OUTPUT, string);
                        } else {
                            this.parameters.put(OUTPUT, string.replace('/', File.separatorChar));
                        }
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", n);
                this.printTag("tasks", this.parameters, true, false);
            }
        }

        static {
            try {
                Class<IProblem> clazz = IProblem.class;
                for (Field field : clazz.getFields()) {
                    if (!field.getType().equals(Integer.TYPE)) continue;
                    Integer n = (Integer)field.get(null);
                    int n2 = n & 0xFFFFFF;
                    if (n2 == 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    FIELD_TABLE.put(n2, field.getName());
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

