# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtPrintSupport, except for defaults which are replaced by "...".
"""

# Module PySide2.QtPrintSupport
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtPrintSupport


class QAbstractPrintDialog(PySide2.QtWidgets.QDialog):

    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: PySide2.QtWidgets.QWidget = ...): ...
    def addEnabledOption(self, option: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption): ...
    def enabledOptions(self) -> PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions: ...
    def exec_(self) -> int: ...
    def fromPage(self) -> int: ...
    def isOptionEnabled(self, option: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption) -> bool: ...
    def maxPage(self) -> int: ...
    def minPage(self) -> int: ...
    def printRange(self) -> PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange: ...
    def printer(self) -> PySide2.QtPrintSupport.QPrinter: ...
    def setEnabledOptions(self, options: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions): ...
    def setFromTo(self, fromPage: int, toPage: int): ...
    def setMinMax(self, min: int, max: int): ...
    def setOptionTabs(self, tabs: list): ...
    def setPrintRange(self, range: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange): ...
    def toPage(self) -> int: ...


class QPageSetupDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: PySide2.QtWidgets.QWidget = ...): ...
    def done(self, result: int): ...
    def exec_(self) -> int: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def printer(self) -> PySide2.QtPrintSupport.QPrinter: ...


class QPrintDialog(PySide2.QtPrintSupport.QAbstractPrintDialog):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: PySide2.QtWidgets.QWidget = ...): ...
    def accept(self): ...
    def done(self, result: int): ...
    def exec_(self) -> int: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def options(self) -> PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions: ...
    def setOption(self, option: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption, on: bool = ...): ...
    def setOptions(self, options: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions): ...
    def setVisible(self, visible: bool): ...
    def testOption(self, option: PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption) -> bool: ...


class QPrintEngine(Shiboken.Object):

    def __init__(self): ...
    def abort(self) -> bool: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def printerState(self) -> PySide2.QtPrintSupport.QPrinter.PrinterState: ...
    def property(self, key: PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey) -> typing.Any: ...
    def setProperty(self, key: PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey, value: typing.Any): ...


class QPrintPreviewDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def done(self, result: int): ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: str): ...
    def printer(self) -> PySide2.QtPrintSupport.QPrinter: ...
    def setVisible(self, visible: bool): ...


class QPrintPreviewWidget(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: PySide2.QtWidgets.QWidget = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...): ...
    def currentPage(self) -> int: ...
    def fitInView(self): ...
    def fitToWidth(self): ...
    def orientation(self) -> PySide2.QtPrintSupport.QPrinter.Orientation: ...
    def pageCount(self) -> int: ...
    def print_(self): ...
    def setAllPagesViewMode(self): ...
    def setCurrentPage(self, pageNumber: int): ...
    def setFacingPagesViewMode(self): ...
    def setLandscapeOrientation(self): ...
    def setOrientation(self, orientation: PySide2.QtPrintSupport.QPrinter.Orientation): ...
    def setPortraitOrientation(self): ...
    def setSinglePageViewMode(self): ...
    def setViewMode(self, viewMode: PySide2.QtPrintSupport.QPrintPreviewWidget.ViewMode): ...
    def setVisible(self, visible: bool): ...
    def setZoomFactor(self, zoomFactor: float): ...
    def setZoomMode(self, zoomMode: PySide2.QtPrintSupport.QPrintPreviewWidget.ZoomMode): ...
    def updatePreview(self): ...
    def viewMode(self) -> PySide2.QtPrintSupport.QPrintPreviewWidget.ViewMode: ...
    def zoomFactor(self) -> float: ...
    def zoomIn(self, zoom: float = ...): ...
    def zoomMode(self) -> PySide2.QtPrintSupport.QPrintPreviewWidget.ZoomMode: ...
    def zoomOut(self, zoom: float = ...): ...


class QPrinter(PySide2.QtGui.QPagedPaintDevice):

    @typing.overload
    def __init__(self, mode: PySide2.QtPrintSupport.QPrinter.PrinterMode = ...): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinterInfo, mode: PySide2.QtPrintSupport.QPrinter.PrinterMode = ...): ...
    def abort(self) -> bool: ...
    def actualNumCopies(self) -> int: ...
    def collateCopies(self) -> bool: ...
    def colorMode(self) -> PySide2.QtPrintSupport.QPrinter.ColorMode: ...
    def copyCount(self) -> int: ...
    def creator(self) -> str: ...
    def devType(self) -> int: ...
    def docName(self) -> str: ...
    def doubleSidedPrinting(self) -> bool: ...
    def duplex(self) -> PySide2.QtPrintSupport.QPrinter.DuplexMode: ...
    def fontEmbeddingEnabled(self) -> bool: ...
    def fromPage(self) -> int: ...
    def fullPage(self) -> bool: ...
    def getPageMargins(self, left: float, top: float, right: float, bottom: float, unit: PySide2.QtPrintSupport.QPrinter.Unit): ...
    def isValid(self) -> bool: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def numCopies(self) -> int: ...
    def orientation(self) -> PySide2.QtPrintSupport.QPrinter.Orientation: ...
    def outputFileName(self) -> str: ...
    def outputFormat(self) -> PySide2.QtPrintSupport.QPrinter.OutputFormat: ...
    def pageOrder(self) -> PySide2.QtPrintSupport.QPrinter.PageOrder: ...
    @typing.overload
    def pageRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def pageRect(self, arg__1: PySide2.QtPrintSupport.QPrinter.Unit) -> PySide2.QtCore.QRectF: ...
    def pageSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paperName(self) -> str: ...
    @typing.overload
    def paperRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def paperRect(self, arg__1: PySide2.QtPrintSupport.QPrinter.Unit) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def paperSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    @typing.overload
    def paperSize(self, unit: PySide2.QtPrintSupport.QPrinter.Unit) -> PySide2.QtCore.QSizeF: ...
    def paperSource(self) -> PySide2.QtPrintSupport.QPrinter.PaperSource: ...
    def pdfVersion(self) -> PySide2.QtGui.QPagedPaintDevice.PdfVersion: ...
    def printEngine(self) -> PySide2.QtPrintSupport.QPrintEngine: ...
    def printProgram(self) -> str: ...
    def printRange(self) -> PySide2.QtPrintSupport.QPrinter.PrintRange: ...
    def printerName(self) -> str: ...
    def printerState(self) -> PySide2.QtPrintSupport.QPrinter.PrinterState: ...
    def resolution(self) -> int: ...
    def setCollateCopies(self, collate: bool): ...
    def setColorMode(self, arg__1: PySide2.QtPrintSupport.QPrinter.ColorMode): ...
    def setCopyCount(self, arg__1: int): ...
    def setCreator(self, arg__1: str): ...
    def setDocName(self, arg__1: str): ...
    def setDoubleSidedPrinting(self, enable: bool): ...
    def setDuplex(self, duplex: PySide2.QtPrintSupport.QPrinter.DuplexMode): ...
    def setEngines(self, printEngine: PySide2.QtPrintSupport.QPrintEngine, paintEngine: PySide2.QtGui.QPaintEngine): ...
    def setFontEmbeddingEnabled(self, enable: bool): ...
    def setFromTo(self, fromPage: int, toPage: int): ...
    def setFullPage(self, arg__1: bool): ...
    def setMargins(self, m: PySide2.QtGui.QPagedPaintDevice.Margins): ...
    def setNumCopies(self, arg__1: int): ...
    def setOrientation(self, arg__1: PySide2.QtPrintSupport.QPrinter.Orientation): ...
    def setOutputFileName(self, arg__1: str): ...
    def setOutputFormat(self, format: PySide2.QtPrintSupport.QPrinter.OutputFormat): ...
    @typing.overload
    def setPageMargins(self, left: float, top: float, right: float, bottom: float, unit: PySide2.QtPrintSupport.QPrinter.Unit): ...
    @typing.overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    def setPageOrder(self, arg__1: PySide2.QtPrintSupport.QPrinter.PageOrder): ...
    def setPageSize(self, arg__1: PySide2.QtGui.QPagedPaintDevice.PageSize): ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF): ...
    def setPaperName(self, paperName: str): ...
    @typing.overload
    def setPaperSize(self, arg__1: PySide2.QtGui.QPagedPaintDevice.PageSize): ...
    @typing.overload
    def setPaperSize(self, paperSize: PySide2.QtCore.QSizeF, unit: PySide2.QtPrintSupport.QPrinter.Unit): ...
    def setPaperSource(self, arg__1: PySide2.QtPrintSupport.QPrinter.PaperSource): ...
    def setPdfVersion(self, version: PySide2.QtGui.QPagedPaintDevice.PdfVersion): ...
    def setPrintProgram(self, arg__1: str): ...
    def setPrintRange(self, range: PySide2.QtPrintSupport.QPrinter.PrintRange): ...
    def setPrinterName(self, arg__1: str): ...
    def setResolution(self, arg__1: int): ...
    def setWinPageSize(self, winPageSize: int): ...
    def supportedResolutions(self) -> int: ...
    def supportsMultipleCopies(self) -> bool: ...
    def toPage(self) -> int: ...
    def winPageSize(self) -> int: ...


class QPrinterInfo(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtPrintSupport.QPrinterInfo): ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter): ...
    def __copy__(self): ...
    @staticmethod
    def availablePrinterNames() -> typing.List[str]: ...
    @staticmethod
    def availablePrinters() -> PySide2.QtPrintSupport.QPrinterInfo: ...
    def defaultDuplexMode(self) -> PySide2.QtPrintSupport.QPrinter.DuplexMode: ...
    def defaultPageSize(self) -> PySide2.QtGui.QPageSize: ...
    @staticmethod
    def defaultPrinter() -> PySide2.QtPrintSupport.QPrinterInfo: ...
    @staticmethod
    def defaultPrinterName() -> str: ...
    def description(self) -> str: ...
    def isDefault(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isRemote(self) -> bool: ...
    def location(self) -> str: ...
    def makeAndModel(self) -> str: ...
    def maximumPhysicalPageSize(self) -> PySide2.QtGui.QPageSize: ...
    def minimumPhysicalPageSize(self) -> PySide2.QtGui.QPageSize: ...
    @staticmethod
    def printerInfo(printerName: str) -> PySide2.QtPrintSupport.QPrinterInfo: ...
    def printerName(self) -> str: ...
    def state(self) -> PySide2.QtPrintSupport.QPrinter.PrinterState: ...
    def supportedDuplexModes(self) -> PySide2.QtPrintSupport.QPrinter.DuplexMode: ...
    def supportedPageSizes(self) -> PySide2.QtGui.QPageSize: ...
    def supportedPaperSizes(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def supportedResolutions(self) -> int: ...
    def supportedSizesWithNames(self) -> typing.Tuple[typing.Any, typing.Any]: ...
    def supportsCustomPageSizes(self) -> bool: ...

# eof
