/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.JNIObject;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.OperationContext;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.RemoteFileRevisionsCallback;
import org.apache.subversion.javahl.callback.RemoteLocationSegmentsCallback;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.remote.CommitEditor;
import org.apache.subversion.javahl.remote.StateReporter;
import org.apache.subversion.javahl.remote.StatusEditor;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;

public class RemoteSession
extends JNIObject
implements ISVNRemote {
    private RemoteSessionContext sessionContext = new RemoteSessionContext();
    private WeakReference<ISVNEditor> editorReference;
    private WeakReference<ISVNReporter> reporterReference;

    @Override
    public void dispose() {
        Object object;
        if (this.editorReference != null) {
            object = (ISVNEditor)this.editorReference.get();
            if (object != null) {
                object.dispose();
                this.editorReference.clear();
            }
            this.editorReference = null;
        }
        if (this.reporterReference != null) {
            object = (ISVNReporter)this.reporterReference.get();
            if (object != null) {
                object.dispose();
                this.reporterReference.clear();
            }
            this.reporterReference = null;
        }
        this.nativeDispose();
    }

    @Override
    public native void cancelOperation() throws ClientException;

    @Override
    public native void reparent(String var1) throws ClientException;

    @Override
    public native String getSessionUrl() throws ClientException;

    @Override
    public native String getSessionRelativePath(String var1) throws ClientException;

    @Override
    public native String getReposRelativePath(String var1) throws ClientException;

    @Override
    public native String getReposUUID() throws ClientException;

    @Override
    public native String getReposRootUrl() throws ClientException;

    @Override
    public native long getLatestRevision() throws ClientException;

    @Override
    public long getRevisionByDate(Date date) throws ClientException {
        long l = TimeUnit.MICROSECONDS.convert(date.getTime(), TimeUnit.MILLISECONDS);
        return this.getRevisionByTimestamp(l);
    }

    @Override
    public native long getRevisionByTimestamp(long var1) throws ClientException;

    @Override
    public void changeRevisionProperty(long l, String string, byte[] byArray, byte[] byArray2) throws ClientException {
        if (byArray != null && !this.hasCapability(ISVNRemote.Capability.atomic_revprops)) {
            throw new IllegalArgumentException("oldValue must be null;\nThe server does not support atomic revision property changes");
        }
        this.nativeChangeRevisionProperty(l, string, byArray, byArray2);
    }

    @Override
    public native Map<String, byte[]> getRevisionProperties(long var1) throws ClientException;

    @Override
    public native byte[] getRevisionProperty(long var1, String var3) throws ClientException;

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> map, CommitCallback commitCallback, Set<Lock> set, boolean bl, ISVNEditor.ProvideBaseCallback provideBaseCallback, ISVNEditor.ProvidePropsCallback providePropsCallback, ISVNEditor.GetNodeKindCallback getNodeKindCallback) throws ClientException {
        RemoteSession.check_inactive(this.editorReference, this.reporterReference);
        CommitEditor commitEditor = CommitEditor.createInstance(this, map, commitCallback, set, bl, provideBaseCallback, providePropsCallback, getNodeKindCallback);
        if (this.editorReference != null) {
            this.editorReference.clear();
        }
        this.editorReference = new WeakReference<CommitEditor>(commitEditor);
        return commitEditor;
    }

    @Override
    public ISVNEditor getCommitEditor(Map<String, byte[]> map, CommitCallback commitCallback, Set<Lock> set, boolean bl) throws ClientException {
        return this.getCommitEditor(map, commitCallback, set, bl, null, null, null);
    }

    @Override
    public long getFile(long l, String string, OutputStream outputStream, Map<String, byte[]> map) throws ClientException {
        RemoteSession.maybe_clear(map);
        return this.nativeGetFile(l, string, outputStream, map);
    }

    @Override
    public long getDirectory(long l, String string, int n, Map<String, DirEntry> map, Map<String, byte[]> map2) throws ClientException {
        RemoteSession.maybe_clear(map);
        RemoteSession.maybe_clear(map2);
        return this.nativeGetDirectory(l, string, n, map, map2);
    }

    @Override
    public native Map<String, Mergeinfo> getMergeinfo(Iterable<String> var1, long var2, Mergeinfo.Inheritance var4, boolean var5) throws ClientException;

    @Override
    public ISVNReporter status(String string, long l, Depth depth, RemoteStatus remoteStatus) throws ClientException {
        RemoteSession.check_inactive(this.editorReference, this.reporterReference);
        StateReporter stateReporter = StateReporter.createInstance(this);
        StatusEditor statusEditor = new StatusEditor(remoteStatus);
        this.nativeStatus(string, l, depth, statusEditor, stateReporter);
        if (this.reporterReference != null) {
            this.reporterReference.clear();
        }
        this.reporterReference = new WeakReference<StateReporter>(stateReporter);
        return stateReporter;
    }

    @Override
    public native void getLog(Iterable<String> var1, long var2, long var4, int var6, boolean var7, boolean var8, boolean var9, Iterable<String> var10, LogMessageCallback var11) throws ClientException;

    @Override
    public native NodeKind checkPath(String var1, long var2) throws ClientException;

    @Override
    public native DirEntry stat(String var1, long var2) throws ClientException;

    @Override
    public native Map<Long, String> getLocations(String var1, long var2, Iterable<Long> var4) throws ClientException;

    @Override
    public native void getLocationSegments(String var1, long var2, long var4, long var6, RemoteLocationSegmentsCallback var8) throws ClientException;

    @Override
    public List<ISVNRemote.LocationSegment> getLocationSegments(String string, long l, long l2, long l3) throws ClientException {
        GetLocationSegmentsHandler getLocationSegmentsHandler = new GetLocationSegmentsHandler();
        this.getLocationSegments(string, l, l2, l3, getLocationSegmentsHandler);
        return getLocationSegmentsHandler.locationSegments;
    }

    @Override
    public native void getFileRevisions(String var1, long var2, long var4, boolean var6, RemoteFileRevisionsCallback var7) throws ClientException;

    @Override
    public List<ISVNRemote.FileRevision> getFileRevisions(String string, long l, long l2, boolean bl) throws ClientException {
        GetFileRevisionsHandler getFileRevisionsHandler = new GetFileRevisionsHandler();
        this.getFileRevisions(string, l, l2, bl, getFileRevisionsHandler);
        return getFileRevisionsHandler.fileRevisions;
    }

    @Override
    public native Map<String, Lock> getLocks(String var1, Depth var2) throws ClientException;

    @Override
    public boolean hasCapability(ISVNRemote.Capability capability) throws ClientException {
        return this.nativeHasCapability(capability.toString());
    }

    public native void finalize() throws Throwable;

    protected RemoteSession(long l) {
        super(l);
    }

    private native void nativeDispose();

    private native void nativeChangeRevisionProperty(long var1, String var3, byte[] var4, byte[] var5) throws ClientException;

    private native long nativeGetFile(long var1, String var3, OutputStream var4, Map<String, byte[]> var5) throws ClientException;

    private native long nativeGetDirectory(long var1, String var3, int var4, Map<String, DirEntry> var5, Map<String, byte[]> var6) throws ClientException;

    private native void nativeStatus(String var1, long var2, Depth var4, ISVNEditor var5, ISVNReporter var6) throws ClientException;

    private native boolean nativeHasCapability(String var1) throws ClientException;

    void disposeEditor(ISVNEditor iSVNEditor) {
        if (this.editorReference == null) {
            return;
        }
        ISVNEditor iSVNEditor2 = (ISVNEditor)this.editorReference.get();
        if (iSVNEditor2 == null) {
            return;
        }
        if (iSVNEditor2 != iSVNEditor) {
            throw new IllegalStateException("Disposing unknown editor");
        }
        this.editorReference.clear();
    }

    void disposeReporter(ISVNReporter iSVNReporter) {
        if (this.reporterReference == null) {
            return;
        }
        ISVNReporter iSVNReporter2 = (ISVNReporter)this.reporterReference.get();
        if (iSVNReporter2 == null) {
            return;
        }
        if (iSVNReporter2 != iSVNReporter) {
            throw new IllegalStateException("Disposing unknown reporter");
        }
        this.reporterReference.clear();
    }

    private static final <K, V> void maybe_clear(Map<K, V> map) {
        if (map != null && !map.isEmpty()) {
            try {
                map.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static final void check_inactive(WeakReference<ISVNEditor> weakReference, WeakReference<ISVNReporter> weakReference2) {
        if (weakReference != null && weakReference.get() != null) {
            throw new IllegalStateException("An editor is already active");
        }
        if (weakReference2 != null && weakReference2.get() != null) {
            throw new IllegalStateException("A reporter is already active");
        }
    }

    static {
        NativeResources.loadNativeLibrary();
    }

    private class RemoteSessionContext
    extends OperationContext {
        private RemoteSessionContext() {
        }
    }

    private static class GetFileRevisionsHandler
    implements RemoteFileRevisionsCallback {
        public List<ISVNRemote.FileRevision> fileRevisions = null;

        private GetFileRevisionsHandler() {
        }

        @Override
        public void doRevision(ISVNRemote.FileRevision fileRevision) {
            if (this.fileRevisions == null) {
                this.fileRevisions = new ArrayList<ISVNRemote.FileRevision>();
            }
            this.fileRevisions.add(fileRevision);
        }
    }

    private static class GetLocationSegmentsHandler
    implements RemoteLocationSegmentsCallback {
        public List<ISVNRemote.LocationSegment> locationSegments = null;

        private GetLocationSegmentsHandler() {
        }

        @Override
        public void doSegment(ISVNRemote.LocationSegment locationSegment) {
            if (this.locationSegments == null) {
                this.locationSegments = new ArrayList<ISVNRemote.LocationSegment>();
            }
            this.locationSegments.add(locationSegment);
        }
    }
}

