/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer;

import java.text.NumberFormat;

public abstract class ItemValueFormatter {
    public static final int FORMAT_TOOLTIP = 0;
    public static final int FORMAT_UNITS = 1;
    public static final int FORMAT_DETAILS = 2;
    public static final int FORMAT_EXPORT = 3;
    public static final ItemValueFormatter SIMPLE = new ItemValueFormatter(){

        @Override
        public String formatValue(long l, int n) {
            return Long.toString(l);
        }

        @Override
        public String getUnits(int n) {
            return null;
        }
    };
    public static final ItemValueFormatter DEFAULT_DECIMAL = new Decimal();
    public static final ItemValueFormatter DEFAULT_BYTES = new Bytes();
    public static final ItemValueFormatter DEFAULT_PERCENT = new Percent();

    public abstract String formatValue(long var1, int var3);

    public abstract String getUnits(int var1);

    public static final class Percent
    extends ItemValueFormatter {
        private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
        private static final NumberFormat NUMBER_FORMAT;
        private double factor;

        Percent() {
            this(3);
        }

        public Percent(int n) {
            this.factor = Math.pow(10.0, n);
        }

        @Override
        public String formatValue(long l, int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return PERCENT_FORMAT.format((double)l / this.factor);
                }
                case 2: 
                case 3: {
                    return NUMBER_FORMAT.format((double)(l * 100L) / this.factor);
                }
            }
            return null;
        }

        @Override
        public String getUnits(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return null;
                }
                case 2: 
                case 3: {
                    return "%";
                }
            }
            return null;
        }

        static {
            PERCENT_FORMAT.setMinimumFractionDigits(1);
            PERCENT_FORMAT.setMaximumIntegerDigits(3);
            NUMBER_FORMAT = NumberFormat.getInstance();
            NUMBER_FORMAT.setMinimumFractionDigits(1);
            NUMBER_FORMAT.setMaximumIntegerDigits(3);
        }
    }

    private static final class Bytes
    extends ItemValueFormatter {
        private static final NumberFormat FORMAT = NumberFormat.getInstance();

        Bytes() {
        }

        @Override
        public String formatValue(long l, int n) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: {
                    return FORMAT.format(l);
                }
                case 1: {
                    String string = l == 0L ? "" : "~";
                    return string + FORMAT.format(Math.round(l / 1024L / 1024L));
                }
            }
            return null;
        }

        @Override
        public String getUnits(int n) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: {
                    return "B";
                }
                case 1: {
                    return "MB";
                }
            }
            return null;
        }
    }

    public static final class Decimal
    extends ItemValueFormatter {
        private static final NumberFormat FORMAT = NumberFormat.getInstance();
        private final int factor;
        private final String units;

        Decimal() {
            this(1, null);
        }

        public Decimal(int n, String string) {
            this.factor = n;
            this.units = string;
        }

        @Override
        public String formatValue(long l, int n) {
            return FORMAT.format(l / (long)this.factor);
        }

        @Override
        public String getUnits(int n) {
            return this.units;
        }
    }
}

