/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.protege.editor.core.ui.view.ViewBanner;
import org.protege.editor.core.ui.view.ViewMode;
import org.protege.editor.core.ui.view.ViewModeChangedHandler;

public class ViewBar
extends JPanel {
    private final ViewBanner viewBanner;
    private final JToolBar toolBar;
    private final List<ViewMode> viewModes = new ArrayList<ViewMode>();
    private final JComboBox<ViewMode> viewModeComboBox;
    private final List<ViewModeChangedHandler> viewModeChangedHandlers = new ArrayList<ViewModeChangedHandler>();

    public ViewBar(String bannerText, Color bannerColor) {
        this.setLayout(new BorderLayout(2, 2));
        this.viewBanner = new ViewBanner(bannerText, bannerColor);
        this.add((Component)this.viewBanner, "North");
        JPanel southPanel = new JPanel(new BorderLayout(7, 7));
        this.toolBar = new JToolBar();
        southPanel.add((Component)this.toolBar, "West");
        this.add((Component)southPanel, "South");
        this.toolBar.setOpaque(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setBorder(null);
        this.viewModeComboBox = new JComboBox();
        this.viewModeComboBox.addActionListener(e -> this.fireViewModeChanged());
        this.viewModeComboBox.setVisible(false);
        southPanel.add(this.viewModeComboBox, "East");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.viewBanner.setEnabled(enabled);
    }

    public ViewBanner getViewBanner() {
        return this.viewBanner;
    }

    public void addAction(Action action) {
        JButton button = this.toolBar.add(action);
        button.setRequestFocusEnabled(false);
    }

    public void addSeparator() {
        this.toolBar.addSeparator(new Dimension(6, 6));
    }

    public void addMode(ViewMode viewMode) {
        this.viewModes.add(viewMode);
        this.viewModeComboBox.setModel(new DefaultComboBoxModel<ViewMode>(this.viewModes.toArray(new ViewMode[this.viewModes.size()])));
        this.viewModeComboBox.setVisible(!this.viewModes.isEmpty());
    }

    public Optional<ViewMode> getViewMode() {
        if (this.viewModes.isEmpty()) {
            return Optional.empty();
        }
        int selIndex = this.viewModeComboBox.getSelectedIndex();
        if (selIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(this.viewModeComboBox.getItemAt(selIndex));
    }

    public void setViewMode(ViewMode viewMode) {
        this.viewModeComboBox.setSelectedItem(viewMode);
    }

    public void addViewModeChangedHandler(ViewModeChangedHandler handler) {
        this.viewModeChangedHandlers.add(handler);
    }

    private void fireViewModeChanged() {
        this.viewModeChangedHandlers.stream().forEach(h -> h.handleViewModeChanged(this.getViewMode()));
    }
}

