/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trigger {
    private final String action;
    private final List<Object> parameters;
    private static final LanguageController messages = LanguageController.getInstance();

    public Trigger(String action, List<Object> parameters) {
        this.action = action;
        this.parameters = parameters;
    }

    public String getAction() {
        return this.action;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "trigger";
    }

    public void process() throws AraraException {
        HashMap<String, 1> mapping = new HashMap<String, 1>();
        mapping.put("halt", new Callable<Object>(){

            @Override
            public Object call() {
                ConfigurationController.getInstance().put("trigger.halt", true);
                return null;
            }
        });
        if (mapping.containsKey(this.action)) {
            try {
                ((Callable)mapping.get(this.action)).call();
            }
            catch (Exception exception) {
                throw new AraraException(messages.getMessage(Messages.ERROR_TRIGGER_CALL_EXCEPTION, this.action), exception);
            }
        } else {
            throw new AraraException(messages.getMessage(Messages.ERROR_TRIGGER_ACTION_NOT_FOUND, this.action));
        }
    }
}

