/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.NbDialog;
import org.netbeans.core.windows.services.NbPresenter;
import org.netbeans.core.windows.services.PresenterDecorator;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogDisplayerImpl
extends DialogDisplayer {
    private static List<Runnable> run = Collections.synchronizedList(new ArrayList());
    private Object testResult;

    public DialogDisplayerImpl() {
        this(null);
    }

    DialogDisplayerImpl(Object object) {
        this.testResult = object;
    }

    public static void runDelayed() {
        NbPresenter.LOG.fine("runDelayed");
        List<Runnable> list = run;
        run = null;
        if (list == null) {
            NbPresenter.LOG.fine("runDelayed, nothing");
            return;
        }
        assert (EventQueue.isDispatchThread());
        for (Runnable runnable : list) {
            NbPresenter.LOG.fine("runDelayed, run = " + runnable);
            runnable.run();
        }
        NbPresenter.LOG.fine("runDelayed, done");
    }

    public Dialog createDialog(DialogDescriptor dialogDescriptor) {
        return this.createDialog(dialogDescriptor, null);
    }

    public Dialog createDialog(final DialogDescriptor dialogDescriptor, final Frame frame) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return (Dialog)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Dialog>(){

            public Dialog run() {
                Container container;
                if (NbPresenter.currentModalDialog != null) {
                    NbDialog nbDialog = NbPresenter.currentModalDialog.isLeaf() ? new NbDialog(dialogDescriptor, WindowManager.getDefault().getMainWindow()) : new NbDialog(dialogDescriptor, NbPresenter.currentModalDialog);
                    DialogDisplayerImpl.customizeDlg(nbDialog);
                    return nbDialog;
                }
                Window window = frame;
                if (null == window) {
                    window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    if (!(window instanceof NbPresenter) || !window.isVisible()) {
                        if (!(window instanceof DefaultSeparateContainer.ModeUIBase)) {
                            container = SwingUtilities.getAncestorOfClass(Window.class, window);
                            window = container != null && container instanceof DefaultSeparateContainer.ModeUIBase ? (Window)container : WindowManager.getDefault().getMainWindow();
                        }
                    } else if (window instanceof NbPresenter && ((NbPresenter)window).isLeaf()) {
                        window = WindowManager.getDefault().getMainWindow();
                    }
                }
                if (window instanceof Dialog) {
                    container = new NbDialog(dialogDescriptor, (Dialog)window);
                } else {
                    Frame frame2 = window instanceof Frame ? (Frame)window : WindowManager.getDefault().getMainWindow();
                    container = new NbDialog(dialogDescriptor, frame2);
                }
                DialogDisplayerImpl.customizeDlg((NbPresenter)container);
                container.requestFocusInWindow();
                return container;
            }
        });
    }

    public Object notify(NotifyDescriptor notifyDescriptor) {
        return this.notify(notifyDescriptor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notify(final NotifyDescriptor notifyDescriptor, final boolean bl) {
        class AWTQuery
        implements Runnable {
            public Object result;
            public boolean running;

            AWTQuery() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AWTQuery aWTQuery = this;
                synchronized (aWTQuery) {
                    this.notify();
                    this.running = true;
                }
                this.showDialog();
                aWTQuery = this;
                synchronized (aWTQuery) {
                    this.result = notifyDescriptor.getValue();
                    this.notifyAll();
                }
            }

            public void showDialog() {
                Object object;
                if (DialogDisplayerImpl.this.testResult != null) {
                    notifyDescriptor.setValue(DialogDisplayerImpl.this.testResult);
                    return;
                }
                Component component = null;
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                for (object = topComponent; object != null && !(object instanceof Window); object = ((Component)object).getParent()) {
                }
                if (object != null) {
                    component = ((Window)object).getFocusOwner();
                }
                NbPresenter nbPresenter = null;
                if (notifyDescriptor instanceof DialogDescriptor) {
                    if (NbPresenter.currentModalDialog != null) {
                        nbPresenter = NbPresenter.currentModalDialog.isLeaf() ? new NbDialog((DialogDescriptor)notifyDescriptor, WindowManager.getDefault().getMainWindow()) : new NbDialog((DialogDescriptor)notifyDescriptor, NbPresenter.currentModalDialog);
                    } else {
                        Frame frame;
                        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                        if (window instanceof NbPresenter && ((NbPresenter)window).isLeaf()) {
                            window = WindowManager.getDefault().getMainWindow();
                        }
                        Frame frame2 = frame = window instanceof Frame ? (Frame)window : WindowManager.getDefault().getMainWindow();
                        if (bl) {
                            frame = null;
                        }
                        nbPresenter = new NbDialog((DialogDescriptor)notifyDescriptor, frame);
                    }
                } else if (NbPresenter.currentModalDialog != null) {
                    nbPresenter = NbPresenter.currentModalDialog.isLeaf() ? new NbPresenter(notifyDescriptor, WindowManager.getDefault().getMainWindow(), true) : new NbPresenter(notifyDescriptor, NbPresenter.currentModalDialog, true);
                } else {
                    Frame frame;
                    Frame frame3 = frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() instanceof Frame ? (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : WindowManager.getDefault().getMainWindow();
                    if (bl) {
                        frame = null;
                    }
                    nbPresenter = new NbPresenter(notifyDescriptor, frame, true);
                }
                if ("true".equals(System.getProperty("javahelp.ignore.modality"))) {
                    nbPresenter.getRootPane().putClientProperty("javahelp.ignore.modality", "true");
                    System.setProperty("javahelp.ignore.modality", "false");
                }
                DialogDisplayerImpl.customizeDlg(nbPresenter);
                nbPresenter.getRootPane().requestDefaultFocus();
                nbPresenter.setVisible(true);
                if (component != null) {
                    ((Component)object).requestFocusInWindow();
                    topComponent.requestFocusInWindow();
                    if (!(component instanceof JRootPane)) {
                        component.requestFocusInWindow();
                    }
                }
            }
        }
        AWTQuery aWTQuery = new AWTQuery();
        if (SwingUtilities.isEventDispatchThread()) {
            aWTQuery.showDialog();
            return notifyDescriptor.getValue();
        }
        AWTQuery aWTQuery2 = aWTQuery;
        synchronized (aWTQuery2) {
            SwingUtilities.invokeLater(aWTQuery);
            try {
                aWTQuery.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (aWTQuery.running) {
                while (aWTQuery.result == null) {
                    try {
                        aWTQuery.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return aWTQuery.result;
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
    }

    public void notifyLater(final NotifyDescriptor notifyDescriptor) {
        class R
        implements Runnable {
            public boolean noParent;

            R() {
            }

            @Override
            public void run() {
                DialogDisplayerImpl.this.notify(notifyDescriptor, this.noParent);
            }
        }
        R r = new R();
        List<Runnable> list = run;
        if (list != null) {
            r.noParent = true;
            list.add(r);
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private static void customizeDlg(NbPresenter nbPresenter) {
        for (PresenterDecorator presenterDecorator : Lookup.getDefault().lookupAll(PresenterDecorator.class)) {
            presenterDecorator.customizePresenter(nbPresenter);
        }
    }
}

