/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class SnapshotCPUView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String TOOLBAR_VIEW = messages.getString("SnapshotCPUView_ToolbarView");
    private static final String VIEW_FORWARD = messages.getString("SnapshotCPUView_ViewForward");
    private static final String VIEW_HOTSPOTS = messages.getString("SnapshotCPUView_ViewHotSpots");
    private static final String VIEW_REVERSE = messages.getString("SnapshotCPUView_ViewReverse");
    private static final String TOOLBAR_AGGREGATION = messages.getString("SnapshotCPUView_ToolbarAggregation");
    private static final String AGGREGATION_METHODS = messages.getString("SnapshotCPUView_AggregationMethods");
    private static final String AGGREGATION_CLASSES = messages.getString("SnapshotCPUView_AggregationClasses");
    private static final String AGGREGATION_PACKAGES = messages.getString("SnapshotCPUView_AggregationPackages");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotCPUView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotCPUView_ResetCompareSnapshots");
    private boolean sampled;
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private int aggregation;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private JToggleButton[] toggles;
    private JToggleButton compareButton;
    private ThreadsSelector threadsSelector;
    private ExecutorService executor;

    public SnapshotCPUView(CPUResultsSnapshot cPUResultsSnapshot, boolean bl, Action action, Action action2, Action action3, ExportUtils.Exportable exportable) {
        this.initUI(action, action2, action3, exportable);
        this.registerActions();
        this.aggregation = 0;
        this.setSnapshot(cPUResultsSnapshot, bl);
    }

    public void setRefSnapshot(CPUResultsSnapshot cPUResultsSnapshot) {
        this.refSnapshot = cPUResultsSnapshot;
        if (this.compareButton != null && cPUResultsSnapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setAggregation(this.aggregation);
    }

    protected boolean profileMethodEnabled() {
        return true;
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void foundInForwardCalls() {
        this.toggles[0].setSelected(true);
    }

    protected void foundInHotSpots() {
        this.toggles[1].setSelected(true);
    }

    protected void foundInReverseCalls() {
        this.toggles[2].setSelected(true);
    }

    private void profileMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(sourceCodeSelection);
    }

    private void profileClass(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceCodeSelection.getClassName(), "*", null));
    }

    private void initUI(Action action, final Action action2, Action action3, ExportUtils.Exportable exportable) {
        Object object;
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(null, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.forwardCallsView, jPopupMenu, object, sourceCodeSelection);
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.hotSpotsView, jPopupMenu, object, sourceCodeSelection);
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(null, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.reverseCallsView, jPopupMenu, object, sourceCodeSelection);
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane jExtendedSplitPane = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider basicSplitPaneDivider;
                super(n);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color color = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    basicSplitPaneDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, color));
                }
            }
        };
        jExtendedSplitPane.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)jExtendedSplitPane).setTopComponent(this.forwardCallsView);
        ((JSplitPane)jExtendedSplitPane).setBottomComponent(this.hotSpotsView);
        jExtendedSplitPane.setDividerLocation(0.5);
        jExtendedSplitPane.setResizeWeight(0.5);
        JExtendedSplitPane jExtendedSplitPane2 = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider basicSplitPaneDivider;
                super(n);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color color = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    basicSplitPaneDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, color));
                }
            }
        };
        jExtendedSplitPane2.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)jExtendedSplitPane2).setTopComponent(jExtendedSplitPane);
        ((JSplitPane)jExtendedSplitPane2).setBottomComponent(this.reverseCallsView);
        jExtendedSplitPane2.setDividerLocation(0.66);
        jExtendedSplitPane2.setResizeWeight(0.66);
        this.add((Component)jExtendedSplitPane2, "Center");
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create(true);
        if (action != null) {
            profilerToolbar.add(action);
        }
        profilerToolbar.add(ExportUtils.exportButton(this, CPUView.EXPORT_TOOLTIP, this.getExportables(exportable)));
        if (action2 != null) {
            profilerToolbar.addSpace(2);
            profilerToolbar.addSeparator();
            profilerToolbar.addSpace(2);
            object = (Icon)action2.getValue("SmallIcon");
            this.compareButton = new JToggleButton((Icon)object){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    boolean bl = this.isSelected();
                    if (bl) {
                        action2.actionPerformed(actionEvent);
                        if (SnapshotCPUView.this.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        SnapshotCPUView.this.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            profilerToolbar.add(this.compareButton);
        }
        profilerToolbar.addSpace(2);
        profilerToolbar.addSeparator();
        profilerToolbar.addSpace(5);
        object = new GrayLabel(TOOLBAR_VIEW);
        profilerToolbar.add((Component)object);
        profilerToolbar.addSpace(5);
        MultiButtonGroup multiButtonGroup = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        this.toggles[0] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                SnapshotCPUView.this.setView(this.isSelected(), SnapshotCPUView.this.hotSpotsView.isVisible(), SnapshotCPUView.this.reverseCallsView.isVisible());
            }
        };
        this.toggles[0].setToolTipText(VIEW_FORWARD);
        multiButtonGroup.add(this.toggles[0]);
        profilerToolbar.add(this.toggles[0]);
        this.forwardCallsView.setVisible(true);
        this.toggles[0].setSelected(true);
        this.toggles[1] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                SnapshotCPUView.this.setView(SnapshotCPUView.this.forwardCallsView.isVisible(), this.isSelected(), SnapshotCPUView.this.reverseCallsView.isVisible());
            }
        };
        this.toggles[1].setToolTipText(VIEW_HOTSPOTS);
        multiButtonGroup.add(this.toggles[1]);
        profilerToolbar.add(this.toggles[1]);
        this.hotSpotsView.setVisible(false);
        this.toggles[1].setSelected(false);
        this.toggles[2] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                SnapshotCPUView.this.setView(SnapshotCPUView.this.forwardCallsView.isVisible(), SnapshotCPUView.this.hotSpotsView.isVisible(), this.isSelected());
            }
        };
        this.toggles[2].setToolTipText(VIEW_REVERSE);
        multiButtonGroup.add(this.toggles[2]);
        profilerToolbar.add(this.toggles[2]);
        this.reverseCallsView.setVisible(false);
        this.toggles[2].setSelected(false);
        profilerToolbar.addSpace(5);
        this.threadsSelector = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return SnapshotCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> collection, boolean bl) {
                SnapshotCPUView.this.mergedThreads = bl;
                SnapshotCPUView.this.selectedThreads = collection;
                SnapshotCPUView.this.setAggregation(SnapshotCPUView.this.aggregation);
            }
        };
        profilerToolbar.add(this.threadsSelector);
        profilerToolbar.addSpace(2);
        profilerToolbar.addSeparator();
        profilerToolbar.addSpace(5);
        GrayLabel grayLabel = new GrayLabel(TOOLBAR_AGGREGATION);
        profilerToolbar.add(grayLabel);
        profilerToolbar.addSpace(2);
        AbstractAction abstractAction = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_METHODS);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotCPUView.this.setAggregation(0);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_CLASSES);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotCPUView.this.setAggregation(1);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_PACKAGES);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotCPUView.this.setAggregation(2);
            }
        };
        ActionPopupButton actionPopupButton = new ActionPopupButton(abstractAction, abstractAction2, abstractAction3);
        profilerToolbar.add(actionPopupButton);
        if (action3 != null) {
            profilerToolbar.addFiller();
            profilerToolbar.add(action3);
        }
        this.add((Component)profilerToolbar.getComponent(), "North");
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = SnapshotCPUView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateFilter();
                }
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = SnapshotCPUView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, final Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        int n;
        Object object2;
        JMenuItem jMenuItem2;
        JMenuItem[] jMenuItemArray;
        if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && SnapshotCPUView.this.aggregation != 2);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotCPUView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.profileMethodSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_PROFILE_METHOD){
                {
                    super(string);
                    this.setEnabled(SnapshotCPUView.this.profileMethodEnabled() && sourceCodeSelection != null && SnapshotCPUView.this.aggregation == 0 && CPUTableView.isSelectable(sourceCodeSelection));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotCPUView.this.profileMethod(sourceCodeSelection);
                }
            });
        }
        if (this.profileClassSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_PROFILE_CLASS){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && SnapshotCPUView.this.aggregation != 2);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotCPUView.this.profileClass(sourceCodeSelection);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            jPopupMenu.addSeparator();
        }
        if ((jMenuItemArray = dataView.createCustomMenuItems(this, object, sourceCodeSelection)) != null) {
            for (JMenuItem jMenuItem2 : jMenuItemArray) {
                jPopupMenu.add(jMenuItem2);
            }
            jPopupMenu.addSeparator();
        }
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        if (dataView == this.forwardCallsView) {
            object2 = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            n = ((JTable)object2).convertColumnIndexToView(((ProfilerTable)object2).getMainColumn());
            final String string = ((ProfilerTreeTable)object2).getStringValue((TreeNode)object, n);
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = SnapshotCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        SnapshotCPUView.this.toggles[1].setSelected(true);
                        SnapshotCPUView.this.hotSpotsView.setVisible(true);
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)SnapshotCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTreeTable, string, true, true, SnapshotCPUView.createSearchHelper())) {
                        SnapshotCPUView.this.toggles[2].setSelected(true);
                        SnapshotCPUView.this.reverseCallsView.setVisible(true);
                        profilerTreeTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.addSeparator();
            jMenuItem2 = new JMenu(CPUView.SHOW_MENU);
            jPopupMenu.add(jMenuItem2);
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!SnapshotCPUView.this.mergedThreads && SnapshotCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && SnapshotCPUView.this.snapshot.getNThreads() > 1 && (SnapshotCPUView.this.selectedThreads == null || SnapshotCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    SnapshotCPUView.this.threadsSelector.addThread(prestimeCPUCCTNode.getThreadId(), true);
                }
            });
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!SnapshotCPUView.this.mergedThreads && SnapshotCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && SnapshotCPUView.this.snapshot.getNThreads() > 1 && (SnapshotCPUView.this.selectedThreads == null || SnapshotCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    SnapshotCPUView.this.threadsSelector.removeThread(prestimeCPUCCTNode.getThreadId());
                }
            });
            JMenu jMenu = new JMenu(CPUView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandPlainPath(this.val$ttable.getSelectedRow(), 2);
                }
            });
            jMenu.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandFirstPath(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseChildren(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseAll();
                }
            });
        } else if (dataView == this.hotSpotsView) {
            object2 = object.toString().replace("(", " (");
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS, (String)object2){
                final /* synthetic */ String val$searchString;
                {
                    this.val$searchString = string2;
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = SnapshotCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, this.val$searchString)) {
                        SnapshotCPUView.this.toggles[0].setSelected(true);
                        SnapshotCPUView.this.forwardCallsView.setVisible(true);
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS, (String)object2){
                final /* synthetic */ String val$searchString;
                {
                    this.val$searchString = string2;
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)SnapshotCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTreeTable, this.val$searchString, true, true, SnapshotCPUView.createSearchHelper())) {
                        SnapshotCPUView.this.toggles[2].setSelected(true);
                        SnapshotCPUView.this.reverseCallsView.setVisible(true);
                        profilerTreeTable.requestFocusInWindow();
                    }
                }
            });
        } else if (dataView == this.reverseCallsView) {
            object2 = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            n = ((JTable)object2).convertColumnIndexToView(((ProfilerTable)object2).getMainColumn());
            final String string = ((ProfilerTreeTable)object2).getStringValue((TreeNode)object, n);
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = SnapshotCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        SnapshotCPUView.this.toggles[0].setSelected(true);
                        SnapshotCPUView.this.forwardCallsView.setVisible(true);
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = SnapshotCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        SnapshotCPUView.this.toggles[1].setSelected(true);
                        SnapshotCPUView.this.hotSpotsView.setVisible(true);
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.addSeparator();
            jMenuItem2 = new JMenu(CPUView.SHOW_MENU);
            jPopupMenu.add(jMenuItem2);
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!SnapshotCPUView.this.mergedThreads && SnapshotCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && SnapshotCPUView.this.snapshot.getNThreads() > 1 && (SnapshotCPUView.this.selectedThreads == null || SnapshotCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    SnapshotCPUView.this.threadsSelector.addThread(prestimeCPUCCTNode.getThreadId(), true);
                }
            });
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!SnapshotCPUView.this.mergedThreads && SnapshotCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && SnapshotCPUView.this.snapshot.getNThreads() > 1 && (SnapshotCPUView.this.selectedThreads == null || SnapshotCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    SnapshotCPUView.this.threadsSelector.removeThread(prestimeCPUCCTNode.getThreadId());
                }
            });
            JMenu jMenu = new JMenu(CPUView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandPlainPath(this.val$ttable.getSelectedRow(), 1);
                }
            });
            jMenu.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandFirstPath(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseChildren(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseAll();
                }
            });
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    private static SearchUtils.TreeHelper createSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treeNode;
                CCTNode cCTNode = prestimeCPUCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isThreadNode()) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)cCTNode).isThreadNode() || cCTNode.getParent() == null) {
                    return 11;
                }
                return 101;
            }
        };
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private void setView(boolean bl, boolean bl2, boolean bl3) {
        this.forwardCallsView.setVisible(bl);
        this.hotSpotsView.setVisible(bl2);
        this.reverseCallsView.setVisible(bl3);
    }

    private void setAggregation(int n) {
        this.aggregation = n;
        this.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                final CPUResultsSnapshot cPUResultsSnapshot = SnapshotCPUView.this.refSnapshot == null ? SnapshotCPUView.this.snapshot : SnapshotCPUView.this.snapshot.createDiff(SnapshotCPUView.this.refSnapshot);
                final FlatProfileContainer flatProfileContainer = cPUResultsSnapshot.getFlatProfile(SnapshotCPUView.this.selectedThreads, SnapshotCPUView.this.aggregation);
                final Map map = cPUResultsSnapshot.getMethodIDMap(SnapshotCPUView.this.aggregation);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = cPUResultsSnapshot instanceof CPUResultsDiff;
                        SnapshotCPUView.this.forwardCallsView.setData(cPUResultsSnapshot, map, SnapshotCPUView.this.aggregation, SnapshotCPUView.this.selectedThreads, SnapshotCPUView.this.mergedThreads, SnapshotCPUView.this.sampled, bl);
                        SnapshotCPUView.this.hotSpotsView.setData(flatProfileContainer, map, SnapshotCPUView.this.sampled, bl);
                        SnapshotCPUView.this.reverseCallsView.setData(cPUResultsSnapshot, map, SnapshotCPUView.this.aggregation, SnapshotCPUView.this.selectedThreads, SnapshotCPUView.this.mergedThreads, SnapshotCPUView.this.sampled, bl);
                    }
                });
            }
        });
    }

    protected final void setSnapshot(CPUResultsSnapshot cPUResultsSnapshot, boolean bl) {
        this.snapshot = cPUResultsSnapshot;
        this.sampled = bl;
        this.setAggregation(this.aggregation);
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable exportable) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.refSnapshot == null && exportable.isEnabled();
            }

            @Override
            public String getName() {
                return exportable.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return exportable.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.forwardCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_FORWARD_CALLS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.forwardCallsView.getExportProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.hotSpotsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_HOTSPOTS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.hotSpotsView.getExportProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.reverseCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_REVERSE_CALLS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.reverseCallsView.getExportProviders();
            }
        }};
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

