/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import jline.Terminal;
import jline.TerminalFactory;
import org.apache.logging.log4j.Level;
import sbt.internal.util.ConsoleAppender;
import sbt.internal.util.ConsoleOut;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.SuppressedTraceContext;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;

public final class ConsoleAppender$ {
    public static ConsoleAppender$ MODULE$;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final boolean formatEnabledInEnv;
    private final AtomicInteger generateId;

    static {
        new ConsoleAppender$();
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    public boolean formatEnabledInEnv() {
        return this.formatEnabledInEnv;
    }

    public ConsoleAppender apply() {
        return this.apply(ConsoleOut$.MODULE$.systemOut());
    }

    public ConsoleAppender apply(PrintStream out) {
        return this.apply(ConsoleOut$.MODULE$.printStreamOut(out));
    }

    public ConsoleAppender apply(PrintWriter out) {
        return this.apply(ConsoleOut$.MODULE$.printWriterOut(out));
    }

    public ConsoleAppender apply(ConsoleOut out) {
        return this.apply(this.generateName(), out);
    }

    public ConsoleAppender apply(String name) {
        return this.apply(name, ConsoleOut$.MODULE$.systemOut());
    }

    public ConsoleAppender apply(String name, ConsoleOut out) {
        return this.apply(name, out, this.formatEnabledInEnv());
    }

    public ConsoleAppender apply(String name, ConsoleOut out, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return this.apply(name, out, this.formatEnabledInEnv(), this.formatEnabledInEnv(), suppressedMessage);
    }

    public ConsoleAppender apply(String name, ConsoleOut out, boolean useFormat) {
        return this.apply(name, out, this.formatEnabledInEnv(), useFormat, this.noSuppressedMessage());
    }

    public ConsoleAppender apply(String name, ConsoleOut out, boolean ansiCodesSupported, boolean useFormat, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        ConsoleAppender appender = new ConsoleAppender(name, out, ansiCodesSupported, useFormat, suppressedMessage);
        appender.start();
        return appender;
    }

    public Enumeration.Value toLevel(Level level) {
        Enumeration.Value value;
        Level level2 = level;
        Level level3 = Level.OFF;
        Level level4 = level2;
        if (!(level3 != null ? !level3.equals(level4) : level4 != null)) {
            value = Level$.MODULE$.Debug();
        } else {
            Level level5 = Level.FATAL;
            Level level6 = level2;
            if (!(level5 != null ? !level5.equals(level6) : level6 != null)) {
                value = Level$.MODULE$.Error();
            } else {
                Level level7 = Level.ERROR;
                Level level8 = level2;
                if (!(level7 != null ? !level7.equals(level8) : level8 != null)) {
                    value = Level$.MODULE$.Error();
                } else {
                    Level level9 = Level.WARN;
                    Level level10 = level2;
                    if (!(level9 != null ? !level9.equals(level10) : level10 != null)) {
                        value = Level$.MODULE$.Warn();
                    } else {
                        Level level11 = Level.INFO;
                        Level level12 = level2;
                        if (!(level11 != null ? !level11.equals(level12) : level12 != null)) {
                            value = Level$.MODULE$.Info();
                        } else {
                            Level level13 = Level.DEBUG;
                            Level level14 = level2;
                            value = !(level13 != null ? !level13.equals(level14) : level14 != null) ? Level$.MODULE$.Debug() : Level$.MODULE$.Debug();
                        }
                    }
                }
            }
        }
        return value;
    }

    public Level toXLevel(Enumeration.Value level) {
        Level level2;
        Enumeration.Value value = level;
        Enumeration.Value value2 = Level$.MODULE$.Error();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            level2 = Level.ERROR;
        } else {
            Enumeration.Value value4 = Level$.MODULE$.Warn();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                level2 = Level.WARN;
            } else {
                Enumeration.Value value6 = Level$.MODULE$.Info();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    level2 = Level.INFO;
                } else {
                    Enumeration.Value value8 = Level$.MODULE$.Debug();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        level2 = Level.DEBUG;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return level2;
    }

    public String generateName() {
        return new StringBuilder(4).append("out-").append(this.generateId.incrementAndGet()).toString();
    }

    private String jline1to2CompatMsg() {
        return "Found class jline.Terminal, but interface was expected";
    }

    private boolean ansiSupported() {
        boolean bl;
        try {
            Terminal terminal = TerminalFactory.get();
            terminal.restore();
            bl = terminal.isAnsiSupported();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof Exception)) {
                if (throwable2 instanceof IncompatibleClassChangeError) {
                    IncompatibleClassChangeError incompatibleClassChangeError = (IncompatibleClassChangeError)throwable2;
                    String string = incompatibleClassChangeError.getMessage();
                    String string2 = this.jline1to2CompatMsg();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new IncompatibleClassChangeError("JLine incompatibility detected.  Check that the sbt launcher is version 0.13.x or later.");
                    }
                }
                throw throwable;
            }
            boolean bl2 = !this.isWindows();
            bl = bl2;
        }
        return bl;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    private ConsoleAppender$() {
        MODULE$ = this;
        this.noSuppressedMessage = (Function1 & Serializable & scala.Serializable)x$1 -> None$.MODULE$;
        String value = System.getProperty("sbt.log.format");
        this.formatEnabledInEnv = value == null ? this.ansiSupported() && !Boolean.getBoolean("sbt.log.noformat") : Boolean.parseBoolean(value);
        this.generateId = new AtomicInteger();
    }
}

