/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBT;

import android.bluetooth.BluetoothAdapter;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OutputStream;
import com.zeroc.IceBT.AcceptorI;
import com.zeroc.IceBT.ConnectorI;
import com.zeroc.IceBT.Instance;
import com.zeroc.IceInternal.Acceptor;
import com.zeroc.IceInternal.Connector;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.Transceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

final class EndpointI
extends com.zeroc.IceInternal.EndpointI {
    private Instance _instance;
    private String _addr;
    private String _uuid;
    private String _name;
    private int _channel;
    private int _timeout;
    private String _connectionId;
    private boolean _compress;
    private int _hashValue;

    public EndpointI(Instance instance, String addr, String uuid, String name, int channel, int timeout, String connectionId, boolean compress) {
        this._instance = instance;
        this._addr = addr;
        this._uuid = uuid;
        this._name = name;
        this._channel = channel;
        this._timeout = timeout;
        this._connectionId = connectionId;
        this._compress = compress;
        this.hashInit();
    }

    public EndpointI(Instance instance) {
        this._instance = instance;
        this._addr = "";
        this._uuid = "";
        this._name = "";
        this._channel = 0;
        this._timeout = instance.defaultTimeout();
        this._connectionId = "";
        this._compress = false;
    }

    public EndpointI(Instance instance, InputStream s) {
        this._instance = instance;
        this._name = "";
        this._channel = 0;
        this._connectionId = "";
        this._addr = s.readString().toUpperCase();
        this._uuid = s.readString();
        this._timeout = s.readInt();
        this._compress = s.readBool();
        this.hashInit();
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        s.writeString(this._addr);
        s.writeString(this._uuid);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public int timeout() {
        return this._timeout;
    }

    @Override
    public com.zeroc.IceInternal.EndpointI timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new EndpointI(this._instance, this._addr, this._uuid, this._name, this._channel, timeout, this._connectionId, this._compress);
    }

    @Override
    public String connectionId() {
        return this._connectionId;
    }

    @Override
    public com.zeroc.IceInternal.EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._connectionId)) {
            return this;
        }
        return new EndpointI(this._instance, this._addr, this._uuid, this._name, this._channel, this._timeout, connectionId, this._compress);
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public com.zeroc.IceInternal.EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new EndpointI(this._instance, this._addr, this._uuid, this._name, this._channel, this._timeout, this._connectionId, compress);
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public boolean secure() {
        return this._instance.secure();
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType selType, EndpointI_connectors callback) {
        ArrayList<Connector> conns = new ArrayList<Connector>();
        conns.add(new ConnectorI(this._instance, this._addr, this._uuid, this._timeout, this._connectionId));
        callback.connectors(conns);
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return new AcceptorI(this, this._instance, adapterName, this._uuid, this._name);
    }

    @Override
    public List<com.zeroc.IceInternal.EndpointI> expandIfWildcard() {
        ArrayList<com.zeroc.IceInternal.EndpointI> endps = new ArrayList<com.zeroc.IceInternal.EndpointI>();
        if (this._addr.isEmpty()) {
            String addr = BluetoothAdapter.getDefaultAdapter().getAddress();
            endps.add(new EndpointI(this._instance, addr, this._uuid, this._name, this._channel, this._timeout, this._connectionId, this._compress));
        } else {
            endps.add(this);
        }
        return endps;
    }

    @Override
    public EndpointI.ExpandHostResult expandHost() {
        EndpointI.ExpandHostResult result = new EndpointI.ExpandHostResult(this);
        result.endpoints = new ArrayList<com.zeroc.IceInternal.EndpointI>();
        result.endpoints.add(this);
        return result;
    }

    @Override
    public boolean equivalent(com.zeroc.IceInternal.EndpointI endpoint) {
        if (!(endpoint instanceof EndpointI)) {
            return false;
        }
        EndpointI btEndpointI = (EndpointI)endpoint;
        return btEndpointI.type() == this.type() && btEndpointI._addr.equals(this._addr) && btEndpointI._uuid.equals(this._uuid) && btEndpointI._channel == this._channel;
    }

    @Override
    public String options() {
        boolean addQuote;
        String s = "";
        if (!this._addr.isEmpty()) {
            s = s + " -a ";
            boolean bl = addQuote = this._addr.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._addr;
            if (addQuote) {
                s = s + "\"";
            }
        }
        if (!this._uuid.isEmpty()) {
            s = s + " -u ";
            boolean bl = addQuote = this._uuid.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._uuid;
            if (addQuote) {
                s = s + "\"";
            }
        }
        if (this._channel > 0) {
            s = s + " -c " + this._channel;
        }
        s = this._timeout == -1 ? s + " -t infinite" : s + " -t " + this._timeout;
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    public void initWithOptions(ArrayList<String> args, boolean oaEndpoint) {
        super.initWithOptions(args);
        if (this._addr.isEmpty()) {
            this._addr = this._instance.defaultHost();
            if (this._addr == null) {
                this._addr = "";
            }
        } else if (this._addr.equals("*")) {
            if (oaEndpoint) {
                this._addr = "";
            } else {
                throw new EndpointParseException("`-a *' not valid for proxy endpoint `" + this.toString() + "'");
            }
        }
        if (this._name.isEmpty()) {
            this._name = "Ice Service";
        }
        if (this._uuid.isEmpty()) {
            if (oaEndpoint) {
                this._uuid = UUID.randomUUID().toString();
            } else {
                throw new EndpointParseException("a UUID must be specified using the -u option");
            }
        }
        this.hashInit();
    }

    @Override
    public EndpointInfo getInfo() {
        com.zeroc.IceBT.EndpointInfo info = new com.zeroc.IceBT.EndpointInfo(){

            @Override
            public short type() {
                return EndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return EndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return EndpointI.this.secure();
            }
        };
        info.addr = this._addr;
        info.uuid = this._uuid;
        return info;
    }

    @Override
    public int compareTo(com.zeroc.IceInternal.EndpointI obj) {
        if (!(obj instanceof EndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        EndpointI p = (EndpointI)obj;
        if (this == p) {
            return 0;
        }
        int v = this._addr.compareTo(p._addr);
        if (v != 0) {
            return v;
        }
        v = this._uuid.compareTo(p._uuid);
        if (v != 0) {
            return v;
        }
        if (this._channel < p._channel) {
            return -1;
        }
        if (p._channel < this._channel) {
            return 1;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        v = this._connectionId.compareTo(p._connectionId);
        if (v != 0) {
            return v;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this._hashValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        if (super.checkOption(option, argument, endpoint)) {
            return true;
        }
        if (option.equals("-a")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -a option in endpoint " + endpoint);
            }
            if (!argument.equals("*") && !BluetoothAdapter.checkBluetoothAddress((String)argument.toUpperCase())) {
                throw new EndpointParseException("invalid address provided for -a option in endpoint " + endpoint);
            }
            this._addr = argument.toUpperCase();
            return true;
        }
        if (option.equals("-u")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -u option in endpoint " + endpoint);
            }
            try {
                UUID.fromString(argument);
            }
            catch (IllegalArgumentException ex) {
                throw new EndpointParseException("invalid UUID for Bluetooth endpoint", ex);
            }
            this._uuid = argument;
            return true;
        }
        if (option.equals("-c")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -c option in endpoint " + endpoint);
            }
            try {
                this._channel = Integer.parseInt(argument);
            }
            catch (NumberFormatException ex) {
                throw new EndpointParseException("invalid channel value `" + argument + "' in endpoint " + endpoint);
            }
            if (this._channel < 0) throw new EndpointParseException("channel value `" + argument + "' out of range in endpoint " + endpoint);
            if (this._channel <= 30) return true;
            throw new EndpointParseException("channel value `" + argument + "' out of range in endpoint " + endpoint);
        }
        if (option.equals("-t")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -t option in endpoint " + endpoint);
            }
            if (argument.equals("infinite")) {
                this._timeout = -1;
                return true;
            }
            try {
                this._timeout = Integer.parseInt(argument);
                if (this._timeout >= 1) return true;
                throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
            }
            catch (NumberFormatException ex) {
                throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
            }
        }
        if (option.equals("-z")) {
            if (argument != null) {
                throw new EndpointParseException("unexpected argument `" + argument + "' provided for -z option in " + endpoint);
            }
            this._compress = true;
            return true;
        }
        if (!option.equals("--name")) return false;
        if (argument == null) {
            throw new EndpointParseException("no argument provided for --name option in endpoint " + endpoint);
        }
        this._name = argument;
        return true;
    }

    private void hashInit() {
        int h = 5381;
        h = HashUtil.hashAdd(h, this._addr);
        h = HashUtil.hashAdd(h, this._uuid);
        h = HashUtil.hashAdd(h, this._timeout);
        h = HashUtil.hashAdd(h, this._connectionId);
        this._hashValue = h = HashUtil.hashAdd(h, this._compress);
    }
}

