/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.logging.ConsoleOutputPane;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.TeeOutputStream;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;
import net.sourceforge.jnlp.util.logging.headers.ObservableMessagesProvider;
import net.sourceforge.jnlp.util.logging.headers.PluginMessage;

public class JavaConsole
implements ObservableMessagesProvider {
    private final List<MessageWithHeader> rawData = Collections.synchronizedList(new ArrayList());
    private final List<ConsoleOutputPane> outputs = new ArrayList<ConsoleOutputPane>();
    private static JavaConsole console;
    private Dimension lastSize;
    private JDialog consoleWindow;
    private JPanel contentPanel;
    private JPanel outputsPanel;
    private ClassLoaderInfoProvider classLoaderInfoProvider;
    private JSpinner numberOfOutputs;
    private PublicObservable observable = new PublicObservable();
    private boolean initialized = false;

    public JavaConsole() {
        System.setErr(new TeeOutputStream(System.err, true));
        System.setOut(new TeeOutputStream(System.out, false));
    }

    private void refreshOutputs() {
        this.refreshOutputs(this.outputsPanel, (Integer)this.numberOfOutputs.getValue());
    }

    private void refreshOutputs(JPanel pane, int count) {
        pane.removeAll();
        while (this.outputs.size() > count) {
            this.getObservable().deleteObserver(this.outputs.get(this.outputs.size() - 1));
            this.outputs.remove(this.outputs.size() - 1);
        }
        while (this.outputs.size() < count) {
            ConsoleOutputPane c1 = new ConsoleOutputPane(this);
            this.observable.addObserver(c1);
            this.outputs.add(c1);
        }
        if (count == 0) {
            pane.add(new JPanel());
        } else if (this.outputs.size() == 1) {
            pane.add(this.outputs.get(0));
        } else {
            JSplitPane splitPane = new JSplitPane(1, this.outputs.get(this.outputs.size() - 2), this.outputs.get(this.outputs.size() - 1));
            splitPane.setDividerLocation(0.5);
            splitPane.setResizeWeight(0.5);
            for (int i = this.outputs.size() - 3; i >= 0; --i) {
                JSplitPane outerPane = new JSplitPane(1, this.outputs.get(i), splitPane);
                outerPane.setDividerLocation(0.5);
                outerPane.setResizeWeight(0.5);
                splitPane = outerPane;
            }
            pane.add(splitPane);
        }
        pane.validate();
    }

    public static JavaConsole getConsole() {
        return JavaConsoleHolder.INSTANCE;
    }

    public static boolean isEnabled() {
        return JavaConsole.isEnabled(JNLPRuntime.getConfiguration());
    }

    public static boolean isEnabled(DeploymentConfiguration config) {
        return !"DISABLE".equals(config.getProperty("deployment.console.startup.mode")) && !JNLPRuntime.isHeadless();
    }

    public static boolean canShowOnStartup(boolean isApplication) {
        return JavaConsole.canShowOnStartup(isApplication, JNLPRuntime.getConfiguration());
    }

    public static boolean canShowOnStartup(boolean isApplication, DeploymentConfiguration config) {
        if (!JavaConsole.isEnabled(config)) {
            return false;
        }
        return "SHOW".equals(config.getProperty("deployment.console.startup.mode")) || "SHOW_PLUGIN_ONLY".equals(config.getProperty("deployment.console.startup.mode")) && !isApplication || "SHOW_JAVAWS_ONLY".equals(config.getProperty("deployment.console.startup.mode")) && isApplication;
    }

    private void initializeWindow() {
        if (!this.initialized) {
            this.initialize();
        }
        if (!JNLPRuntime.isHeadless()) {
            this.initializeWindow(this.lastSize, this.contentPanel);
        }
    }

    private void initializeWindow(Dimension size, JPanel content) {
        this.consoleWindow = new JDialog((Frame)null, Translator.R("DPJavaConsole"));
        this.consoleWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JavaConsole.this.lastSize = JavaConsole.this.consoleWindow.getSize();
            }
        });
        this.consoleWindow.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.refreshOutputs();
        this.consoleWindow.add(content);
        this.consoleWindow.setDefaultCloseOperation(2);
        this.consoleWindow.pack();
        if (size != null) {
            this.consoleWindow.setSize(size);
        } else {
            this.consoleWindow.setSize(new Dimension(900, 600));
        }
        this.consoleWindow.setMinimumSize(new Dimension(300, 300));
    }

    private void initialize() {
        this.contentPanel = new JPanel();
        this.outputsPanel = new JPanel();
        this.outputsPanel.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridheight = 10;
        c.weighty = 1.0;
        this.contentPanel.add((Component)this.outputsPanel, c);
        c = new GridBagConstraints();
        c.gridy = 10;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 0, 0, 0));
        this.contentPanel.add((Component)buttonPanel, c);
        JButton gcButton = new JButton(Translator.R("CONSOLErungc"));
        buttonPanel.add(gcButton);
        gcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Performing Garbage Collection....");
                System.gc();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("ButDone"));
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton finalizersButton = new JButton(Translator.R("CONSOLErunFinalizers"));
        buttonPanel.add(finalizersButton);
        finalizersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLErunningFinalizers"));
                Runtime.getRuntime().runFinalization();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("ButDone"));
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton memoryButton = new JButton(Translator.R("CONSOLEmemoryInfo"));
        buttonPanel.add(memoryButton);
        memoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton systemPropertiesButton = new JButton(Translator.R("CONSOLEsystemProperties"));
        buttonPanel.add(systemPropertiesButton);
        systemPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printSystemProperties();
                JavaConsole.this.updateModel();
            }
        });
        JButton classloadersButton = new JButton(Translator.R("CONSOLEclassLoaders"));
        buttonPanel.add(classloadersButton);
        classloadersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printClassLoaders();
                JavaConsole.this.updateModel();
            }
        });
        JButton threadListButton = new JButton(Translator.R("CONSOLEthreadList"));
        buttonPanel.add(threadListButton);
        threadListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.printThreadInfo();
                JavaConsole.this.updateModel();
            }
        });
        JLabel numberOfOutputsL = new JLabel("  Number of outputs: ");
        buttonPanel.add(numberOfOutputsL);
        this.numberOfOutputs = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        JComponent comp = this.numberOfOutputs.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.numberOfOutputs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavaConsole.this.refreshOutputs();
            }
        });
        buttonPanel.add(this.numberOfOutputs);
        JButton closeButton = new JButton(Translator.R("ButClose"));
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaConsole.this.hideConsole();
                    }
                });
            }
        });
        JButton cleanButton = new JButton(Translator.R("CONSOLEClean"));
        buttonPanel.add(cleanButton);
        cleanButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                List list = JavaConsole.this.rawData;
                synchronized (list) {
                    JavaConsole.this.rawData.clear();
                    JavaConsole.this.updateModel(true);
                }
            }
        });
        this.initialized = true;
    }

    public void showConsole() {
        this.showConsole(false);
    }

    public void showConsole(boolean modal) {
        if (!(JNLPRuntime.isHeadless() || this.consoleWindow != null && this.consoleWindow.isVisible())) {
            this.initializeWindow();
            this.consoleWindow.setModal(modal);
            this.consoleWindow.setVisible(true);
        }
    }

    public void hideConsole() {
        this.outputsPanel.removeAll();
        this.getObservable().deleteObservers();
        this.consoleWindow.setModal(false);
        this.consoleWindow.setVisible(false);
        this.consoleWindow.dispose();
    }

    public void showConsoleLater() {
        this.showConsoleLater(false);
    }

    public void showConsoleLater(final boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaConsole.getConsole().showConsole(modal);
            }
        });
    }

    public void hideConsoleLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaConsole.getConsole().hideConsole();
            }
        });
    }

    protected void printSystemProperties() {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEsystemProperties") + ":");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "");
        Properties p = System.getProperties();
        Set<Object> keys = p.keySet();
        for (Object key : keys) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, key.toString() + ": " + p.get(key));
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
    }

    public void setClassLoaderInfoProvider(ClassLoaderInfoProvider clip) {
        this.classLoaderInfoProvider = clip;
    }

    private void printClassLoaders() {
        if (this.classLoaderInfoProvider == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEnoClassLoaders"));
        } else {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEclassLoaders") + ": ");
            Set<String> loaders = this.classLoaderInfoProvider.getLoaderInfo().keySet();
            for (String loader : loaders) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, loader + "\n  codebase = " + this.classLoaderInfoProvider.getLoaderInfo().get(loader));
            }
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
        }
    }

    private void printMemoryInfo() {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----- ");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "  " + Translator.R("CONSOLEmemoryInfo") + ":");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "   " + Translator.R("CONSOLEmemoryMax") + ":   " + String.format("%1$10d", Runtime.getRuntime().maxMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "    " + Translator.R("CONSOLEmemoryTotal") + ": " + String.format("%1$10d", Runtime.getRuntime().totalMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "    " + Translator.R("CONSOLEmemoryFree") + ":  " + String.format("%1$10d", Runtime.getRuntime().freeMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
    }

    private void printThreadInfo() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> keys = map.keySet();
        for (Thread key : keys) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEthread") + " " + key.getId() + ": " + key.getName());
            for (StackTraceElement element : map.get(key)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "  " + element);
            }
        }
    }

    public static void main(String[] args) {
        JavaConsole cconsole = new JavaConsole();
        boolean toShowConsole = true;
        for (String arg : args) {
            if (!"--show-console".equals(arg)) continue;
            toShowConsole = true;
        }
        if (toShowConsole) {
            cconsole.showConsoleLater();
        }
    }

    synchronized void addMessage(MessageWithHeader m) {
        this.rawData.add(m);
        this.updateModel();
    }

    private synchronized void updateModel() {
        this.updateModel(null);
    }

    private synchronized void updateModel(Boolean force) {
        this.observable.setChanged();
        this.observable.notifyObservers(force);
    }

    private void processPluginMessage(String s) {
        PluginMessage pm = new PluginMessage(s);
        OutputController.getLogger().log(pm);
    }

    @Override
    public List<MessageWithHeader> getData() {
        return this.rawData;
    }

    @Override
    public Observable getObservable() {
        return this.observable;
    }

    public void createPluginReader(final File file) {
        OutputController.getLogger().log("Starting processing of plugin-debug-to-console " + file.getAbsolutePath());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block8: {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
                        while (true) {
                            try {
                                String s;
                                while ((s = br.readLine()) != null) {
                                    JavaConsole.this.processPluginMessage(s);
                                }
                            }
                            catch (Exception ex) {
                                OutputController.getLogger().log(ex);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception ex) {
                        OutputController.getLogger().log(ex);
                        if (br == null) break block8;
                        try {
                            br.close();
                        }
                        catch (Exception exx) {
                            OutputController.getLogger().log(exx);
                        }
                    }
                }
                OutputController.getLogger().log("Ended processing of plugin-debug-to-console " + file.getAbsolutePath());
            }
        }, "plugin-debug-to-console reader thread");
        t.setDaemon(true);
        t.start();
        OutputController.getLogger().log("Started processing of plugin-debug-to-console " + file.getAbsolutePath());
    }

    private static class JavaConsoleHolder {
        private static final JavaConsole INSTANCE = new JavaConsole();

        private JavaConsoleHolder() {
        }
    }

    public static interface ClassLoaderInfoProvider {
        public Map<String, String> getLoaderInfo();
    }

    private static class PublicObservable
    extends Observable {
        private PublicObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }
}

