/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.util.PT;
import org.jmol.api.Translator;
import org.jmol.i18n.Language;
import org.jmol.i18n.Resource;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SRequireImport(value={MessageFormat.class, Resource.class, Language.class, PT.class})
public class GT
implements Translator {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private static Language[] languageList;
    private Resource[] resources = null;
    private int resourceCount = 0;
    private boolean doTranslate = true;
    private String language;
    private static boolean allowDebug;
    static Viewer vwr;
    private static Map<String, String> htLanguages;

    static {
        allowDebug = false;
        htLanguages = new Hashtable<String, String>();
    }

    public GT() {
    }

    @Override
    public String translate(String string) {
        return GT.$(string);
    }

    public GT(Viewer viewer, String string) {
        allowDebug = true;
        this.resources = null;
        this.resourceCount = 0;
        getTextWrapper = this;
        if (string != null && string.length() == 0) {
            string = "none";
        }
        if (string != null) {
            this.language = string;
        }
        if ("none".equals(this.language)) {
            this.language = null;
        }
        if (this.language == null) {
            this.language = Resource.getLanguage();
        }
        if (this.language == null) {
            this.language = "en";
        }
        String string2 = this.language;
        String string3 = null;
        String string4 = null;
        int n = this.language.indexOf("_");
        if (n >= 0) {
            string2 = string2.substring(0, n);
            string3 = this.language;
            ++n;
            if ((n = string3.indexOf("_", n)) >= 0) {
                string3 = string3.substring(0, n);
                string4 = this.language;
            }
        }
        if ((this.language = this.getSupported(string4)) == null && (this.language = this.getSupported(string3)) == null && (this.language = this.getSupported(string2)) == null) {
            this.language = "en";
            System.out.println(String.valueOf(this.language) + " not supported -- using en");
            return;
        }
        string4 = null;
        string3 = null;
        switch (this.language.length()) {
            default: {
                string4 = this.language;
                string3 = this.language.substring(0, 5);
                string2 = this.language.substring(0, 2);
                break;
            }
            case 5: {
                string3 = this.language;
                string2 = this.language.substring(0, 2);
                break;
            }
            case 2: {
                string2 = this.language;
            }
        }
        string3 = this.getSupported(string3);
        string2 = this.getSupported(string2);
        if (string2 == string3 || "en_US".equals(string2)) {
            string2 = null;
        }
        if (string3 == string4) {
            string3 = null;
        }
        if ("en_US".equals(string3)) {
            return;
        }
        if (allowDebug && Logger.debugging) {
            Logger.debug("Instantiating gettext wrapper for " + this.language + " using files for language:" + string2 + " country:" + string3 + " variant:" + string4);
        }
        if (!ignoreApplicationBundle) {
            this.addBundles(viewer, "Jmol", string4, null, null);
        }
        this.addBundles(viewer, "JmolApplet", string4, null, null);
        if (!ignoreApplicationBundle) {
            this.addBundles(viewer, "Jmol", null, string3, null);
        }
        this.addBundles(viewer, "JmolApplet", null, string3, null);
        if (!ignoreApplicationBundle) {
            this.addBundles(viewer, "Jmol", null, null, string2);
        }
        this.addBundles(viewer, "JmolApplet", null, null, string2);
    }

    public static Language[] getLanguageList(GT gT) {
        if (languageList == null) {
            if (gT == null) {
                gT = GT.getTextWrapper();
            }
            gT.createLanguageList();
        }
        return languageList;
    }

    public static String getLanguage() {
        return GT.getTextWrapper().language;
    }

    public static void ignoreApplicationBundle() {
        ignoreApplicationBundle = true;
    }

    public static boolean setDoTranslate(boolean bl) {
        boolean bl2 = GT.getDoTranslate();
        GT.getTextWrapper().doTranslate = bl;
        return bl2;
    }

    public static boolean getDoTranslate() {
        return GT.getTextWrapper().doTranslate;
    }

    public static String $(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String o(String string, Object object) {
        if (object instanceof Object[]) {
            if (((Object[])object).length != 1) {
                return MessageFormat.format(string, (Object[])object);
            }
            object = ((Object[])object)[0];
        }
        return PT.rep(string, "{0}", object.toString());
    }

    public static String i(String string, int n) {
        return PT.rep(string, "{0}", "" + n);
    }

    public static String escapeHTML(String string) {
        int n = string.length();
        while (--n >= 0) {
            char c = string.charAt(n);
            if (c <= '\u007f') continue;
            string = String.valueOf(string.substring(0, n)) + "&#" + c + ";" + string.substring(n + 1);
        }
        return string;
    }

    private static GT getTextWrapper() {
        return getTextWrapper == null ? (getTextWrapper = new GT(null, null)) : getTextWrapper;
    }

    private synchronized void createLanguageList() {
        boolean bl = this.doTranslate;
        this.doTranslate = false;
        languageList = Language.getLanguageList();
        this.doTranslate = bl;
    }

    private String getSupported(String string) {
        if (string == null) {
            return null;
        }
        String string2 = htLanguages.get(string);
        if (string2 != null) {
            return string2.length() == 0 ? null : string2;
        }
        string2 = Language.getSupported(GT.getLanguageList(this), string);
        htLanguages.put(string, string2 == null ? "" : string2);
        return string2;
    }

    private void addBundles(Viewer viewer, String string, String string2, String string3, String string4) {
        try {
            String string5 = "org.jmol.translation." + string + ".";
            if (string2 != null) {
                this.addBundle(viewer, string5, string2);
            }
            if (string3 != null) {
                this.addBundle(viewer, string5, string3);
            }
            if (string4 != null) {
                this.addBundle(viewer, string5, string4);
            }
        }
        catch (Exception exception) {
            if (allowDebug) {
                Logger.errorEx("Some exception occurred!", exception);
            }
            this.resources = null;
            this.resourceCount = 0;
        }
    }

    private void addBundle(Viewer viewer, String string, String string2) {
        Resource resource = Resource.getResource(viewer, string, string2);
        if (resource != null) {
            if (this.resources == null) {
                this.resources = new Resource[8];
                this.resourceCount = 0;
            }
            this.resources[this.resourceCount] = resource;
            ++this.resourceCount;
            if (allowDebug) {
                Logger.debug("GT adding " + string);
            }
        }
    }

    private String getString(String string) {
        String string2 = null;
        if (this.doTranslate) {
            int n = 0;
            while (n < this.resourceCount) {
                string2 = this.resources[n].getString(string);
                if (string2 != null) {
                    string = string2;
                    break;
                }
                ++n;
            }
            if (this.resourceCount > 0 && string2 == null && allowDebug && Logger.debugging) {
                Logger.debug("No trans, using default: " + string);
            }
        }
        if (string2 == null) {
            if (string.startsWith("[")) {
                string = string.substring(string.indexOf("]") + 1);
            } else if (string.endsWith("]")) {
                string = string.substring(0, string.indexOf("["));
            }
        }
        return string;
    }
}

