# Message types for different requests & response
MSG_SUBSCRIBE = 1
MSG_SUBSCRIPTION = 2
MSG_TORRENT_HEALTH_RESPONSE = 3
MSG_CHANNEL_HEALTH_RESPONSE = 4
MSG_TORRENT_INFO_REQUEST = 5
MSG_TORRENT_INFO_RESPONSE = 6
MSG_SEARCH_REQUEST = 7
MSG_SEARCH_RESPONSE = 8
MSG_CONTENT_INFO_REQUEST = 9
MSG_CONTENT_INFO_RESPONSE = 10

MAX_SUBSCRIBERS = 10
MAX_PUBLISHERS = 10
PUBLISH_INTERVAL = 5

TORRENT_SEARCH_RESPONSE_TYPE = 0
CHANNEL_SEARCH_RESPONSE_TYPE = 1

# Search types
TYPE_TORRENT = 0
TYPE_CHANNEL = 1

# Request types
SEARCH_TORRENT_REQUEST = 11
SEARCH_TORRENT_RESPONSE = 12
SEARCH_CHANNEL_REQUEST = 13
SEARCH_CHANNEL_RESPONSE = 14

# Maximum packet payload size in bytes
MAX_PACKET_PAYLOAD_SIZE = 500

# Error definitions
ERROR_UNKNOWN_PEER = "Unknown peer! No response sent"
ERROR_UNKNOWN_RESPONSE = "Received response from non-subscribed peer. Dropping it."
ERROR_NO_CONTENT = "Nothing to publish"
