// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `FileInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IcePatch2;

/**
 * Basic information about a single file.
 *
 **/
public class LargeFileInfo implements java.lang.Cloneable,
                                      java.io.Serializable
{
    /**
     * The pathname.
     **/
    public String path;

    /**
     * The SHA-1 checksum of the file.
     **/
    public byte[] checksum;

    /**
     * The size of the compressed file in number of bytes.
     **/
    public long size;

    /**
     * The executable flag.
     **/
    public boolean executable;

    public LargeFileInfo()
    {
        this.path = "";
    }

    public LargeFileInfo(String path, byte[] checksum, long size, boolean executable)
    {
        this.path = path;
        this.checksum = checksum;
        this.size = size;
        this.executable = executable;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        LargeFileInfo r = null;
        if(rhs instanceof LargeFileInfo)
        {
            r = (LargeFileInfo)rhs;
        }

        if(r != null)
        {
            if(this.path != r.path)
            {
                if(this.path == null || r.path == null || !this.path.equals(r.path))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.checksum, r.checksum))
            {
                return false;
            }
            if(this.size != r.size)
            {
                return false;
            }
            if(this.executable != r.executable)
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int h_ = 5381;
        h_ = IceInternal.HashUtil.hashAdd(h_, "::IcePatch2::LargeFileInfo");
        h_ = IceInternal.HashUtil.hashAdd(h_, path);
        h_ = IceInternal.HashUtil.hashAdd(h_, checksum);
        h_ = IceInternal.HashUtil.hashAdd(h_, size);
        h_ = IceInternal.HashUtil.hashAdd(h_, executable);
        return h_;
    }

    public LargeFileInfo
    clone()
    {
        LargeFileInfo c = null;
        try
        {
            c = (LargeFileInfo)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    ice_writeMembers(Ice.OutputStream ostr)
    {
        ostr.writeString(this.path);
        Ice.ByteSeqHelper.write(ostr, this.checksum);
        ostr.writeLong(this.size);
        ostr.writeBool(this.executable);
    }

    public void
    ice_readMembers(Ice.InputStream istr)
    {
        this.path = istr.readString();
        this.checksum = Ice.ByteSeqHelper.read(istr);
        this.size = istr.readLong();
        this.executable = istr.readBool();
    }

    static public void
    ice_write(Ice.OutputStream ostr, LargeFileInfo v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public LargeFileInfo
    ice_read(Ice.InputStream istr)
    {
        LargeFileInfo v = new LargeFileInfo();
        v.ice_readMembers(istr);
        return v;
    }

    private static final LargeFileInfo _nullMarshalValue = new LargeFileInfo();

    public static final long serialVersionUID = 1105566963219174392L;
}
