/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.InjectUtil;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultTransformer
implements Transformer {
    private final Class<? extends ArtifactTransform> implementationClass;
    private final boolean requiresDependencies;
    private final Isolatable<Object[]> parameters;
    private final InstantiatorFactory instantiatorFactory;
    private final HashCode inputsHash;
    private final ImmutableAttributes fromAttributes;

    public DefaultTransformer(Class<? extends ArtifactTransform> implementationClass, Isolatable<Object[]> parameters, HashCode inputsHash, InstantiatorFactory instantiatorFactory, ImmutableAttributes fromAttributes) {
        this.implementationClass = implementationClass;
        this.requiresDependencies = DefaultTransformer.hasDependenciesAmongConstructorParameters(implementationClass);
        this.parameters = parameters;
        this.instantiatorFactory = instantiatorFactory;
        this.inputsHash = inputsHash;
        this.fromAttributes = fromAttributes;
    }

    private static boolean hasDependenciesAmongConstructorParameters(Class<? extends ArtifactTransform> implementation) {
        Constructor constructor = InjectUtil.selectConstructor(implementation);
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (!ArtifactTransformDependencies.class.equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresDependencies() {
        return this.requiresDependencies;
    }

    @Override
    public ImmutableAttributes getFromAttributes() {
        return this.fromAttributes;
    }

    @Override
    public List<File> transform(File primaryInput, File outputDir, ArtifactTransformDependencies dependencies) {
        ArtifactTransform transformer = this.newTransformer(dependencies);
        transformer.setOutputDirectory(outputDir);
        List outputs = transformer.transform(primaryInput);
        return DefaultTransformer.validateOutputs(primaryInput, outputDir, outputs);
    }

    private static List<File> validateOutputs(File primaryInput, File outputDir, @Nullable List<File> outputs) {
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        String inputFilePrefix = primaryInput.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            if (!output.exists()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " does not exist.");
            }
            if (output.equals(primaryInput) || output.equals(outputDir) || output.getPath().startsWith(outputDirPrefix) || output.getPath().startsWith(inputFilePrefix)) continue;
            throw new InvalidUserDataException("Transform output file " + output.getPath() + " is not a child of the transform's input file or output directory.");
        }
        return outputs;
    }

    private ArtifactTransform newTransformer(ArtifactTransformDependencies artifactTransformDependencies) {
        Instantiator instantiator;
        if (this.requiresDependencies) {
            DefaultServiceRegistry registry = new DefaultServiceRegistry();
            registry.add(ArtifactTransformDependencies.class, (Object)artifactTransformDependencies);
            instantiator = this.instantiatorFactory.inject((ServiceRegistry)registry);
        } else {
            instantiator = this.instantiatorFactory.inject();
        }
        return (ArtifactTransform)instantiator.newInstance(this.implementationClass, (Object[])this.parameters.isolate());
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return this.inputsHash;
    }

    @Override
    public Class<? extends ArtifactTransform> getImplementationClass() {
        return this.implementationClass;
    }

    public String getDisplayName() {
        return this.implementationClass.getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransformer that = (DefaultTransformer)o;
        return this.inputsHash.equals((Object)that.inputsHash);
    }

    public int hashCode() {
        return this.inputsHash.hashCode();
    }
}

