/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class RelativePathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final StringInterner stringInterner;

    public RelativePathFingerprintingStrategy(StringInterner stringInterner) {
        super("RELATIVE_PATH", NormalizedPathFingerprintCompareStrategy.INSTANCE);
        this.stringInterner = stringInterner;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<FileSystemSnapshot> roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet processedEntries = new HashSet();
        for (FileSystemSnapshot root : roots) {
            root.accept(new FileSystemSnapshotVisitor(){
                private final RelativePathStringTracker relativePathStringTracker = new RelativePathStringTracker();

                @Override
                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    boolean isRoot = this.relativePathStringTracker.isRoot();
                    this.relativePathStringTracker.enter(directorySnapshot);
                    String absolutePath = directorySnapshot.getAbsolutePath();
                    if (processedEntries.add(absolutePath)) {
                        FileSystemLocationFingerprint fingerprint = isRoot ? IgnoredPathFileSystemLocationFingerprint.DIRECTORY : new DefaultFileSystemLocationFingerprint(RelativePathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), directorySnapshot);
                        builder.put((Object)absolutePath, (Object)fingerprint);
                    }
                    return true;
                }

                @Override
                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    String absolutePath = fileSnapshot.getAbsolutePath();
                    if (processedEntries.add(absolutePath)) {
                        FileSystemLocationFingerprint fingerprint = this.relativePathStringTracker.isRoot() ? new DefaultFileSystemLocationFingerprint(fileSnapshot.getName(), fileSnapshot) : this.createFingerprint(fileSnapshot);
                        builder.put((Object)absolutePath, (Object)fingerprint);
                    }
                }

                private FileSystemLocationFingerprint createFingerprint(FileSystemLocationSnapshot snapshot) {
                    this.relativePathStringTracker.enter(snapshot);
                    DefaultFileSystemLocationFingerprint fingerprint = new DefaultFileSystemLocationFingerprint(RelativePathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), snapshot);
                    this.relativePathStringTracker.leave();
                    return fingerprint;
                }

                @Override
                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                    this.relativePathStringTracker.leave();
                }
            });
        }
        return builder.build();
    }
}

