/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.util.GradleVersion;

public class DefaultConnectionParameters
implements ConnectionParameters {
    private final File projectDir;
    private final Boolean searchUpwards;
    private final File gradleUserHomeDir;
    private final Boolean embedded;
    private final Integer daemonMaxIdleTimeValue;
    private final TimeUnit daemonMaxIdleTimeUnits;
    private final File daemonBaseDir;
    private final boolean verboseLogging;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultConnectionParameters(File projectDir, File gradleUserHomeDir, Boolean embedded, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits, File daemonBaseDir, boolean verboseLogging, Boolean searchUpwards) {
        this.projectDir = projectDir;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.embedded = embedded;
        this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
        this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
        this.daemonBaseDir = daemonBaseDir;
        this.verboseLogging = verboseLogging;
        this.searchUpwards = searchUpwards;
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getDaemonBaseDir() {
        return this.daemonBaseDir;
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    @Override
    public Boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public Integer getDaemonMaxIdleTimeValue() {
        return this.daemonMaxIdleTimeValue;
    }

    @Override
    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.daemonMaxIdleTimeUnits;
    }

    @Override
    public String getConsumerVersion() {
        return GradleVersion.current().getVersion();
    }

    @Override
    public boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    @Override
    public Boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public static class Builder {
        private File projectDir;
        private File gradleUserHomeDir;
        private Boolean embedded;
        private Integer daemonMaxIdleTimeValue;
        private TimeUnit daemonMaxIdleTimeUnits;
        private boolean verboseLogging;
        private File daemonBaseDir;
        private Boolean searchUpwards;

        protected Builder() {
        }

        public Builder setProjectDir(File projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        public Builder setGradleUserHomeDir(File gradleUserHomeDir) {
            this.gradleUserHomeDir = gradleUserHomeDir;
            return this;
        }

        public Builder setEmbedded(Boolean embedded) {
            this.embedded = embedded;
            return this;
        }

        public Builder setDaemonMaxIdleTimeValue(Integer daemonMaxIdleTimeValue) {
            this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
            return this;
        }

        public Builder setDaemonMaxIdleTimeUnits(TimeUnit daemonMaxIdleTimeUnits) {
            this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
            return this;
        }

        public Builder setVerboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public Builder setSearchUpwards(Boolean searchUpwards) {
            this.searchUpwards = searchUpwards;
            return this;
        }

        public Builder setDaemonBaseDir(File daemonBaseDir) {
            this.daemonBaseDir = daemonBaseDir;
            return this;
        }

        public DefaultConnectionParameters build() {
            return new DefaultConnectionParameters(this.projectDir, this.gradleUserHomeDir, this.embedded, this.daemonMaxIdleTimeValue, this.daemonMaxIdleTimeUnits, this.daemonBaseDir, this.verboseLogging, this.searchUpwards);
        }
    }
}

