/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.awt.Dimension;
import java.io.File;
import javax.swing.ImageIcon;
import tim.prune.data.MediaObject;

public class Photo
extends MediaObject {
    private Dimension _size = null;
    private int _rotation = 0;
    private double _bearing = -1.0;
    private byte[] _exifThumbnail = null;

    public Photo(File file) {
        super(file, null);
    }

    public Photo(byte[] byArray, String string, String string2) {
        super(byArray, string, string2);
    }

    private void calculateSize() {
        ImageIcon imageIcon = null;
        imageIcon = this._file != null ? new ImageIcon(this._file.getAbsolutePath()) : new ImageIcon(this._data);
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (n > 0 && n2 > 0) {
            this._size = new Dimension(n, n2);
        }
    }

    public Dimension getSize() {
        if (this._size == null) {
            this.calculateSize();
        }
        return this._size;
    }

    public int getWidth() {
        if (this.getSize() == null) {
            return -1;
        }
        return this._size.width;
    }

    public int getHeight() {
        if (this.getSize() == null) {
            return -1;
        }
        return this._size.height;
    }

    public byte[] getExifThumbnail() {
        return this._exifThumbnail;
    }

    public void setExifThumbnail(byte[] byArray) {
        this._exifThumbnail = byArray;
    }

    public void resetCachedData() {
        this._size = null;
    }

    public void setRotation(int n) {
        if (n >= 0 && n <= 3) {
            this._rotation = n;
        }
    }

    public void rotate(boolean bl) {
        int n = bl ? 1 : 3;
        this._rotation = (this._rotation + n) % 4;
    }

    public int getRotationDegrees() {
        return this._rotation * 90;
    }

    public ImageIcon createImageIcon() {
        if (this._file != null) {
            return new ImageIcon(this._file.getAbsolutePath());
        }
        if (this._data != null) {
            return new ImageIcon(this._data);
        }
        return null;
    }

    public void setBearing(double d) {
        this._bearing = d;
    }

    public double getBearing() {
        return this._bearing;
    }
}

