/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;

public class CarbohydrateMonomer
extends Monomer {
    private static final byte[] alphaOffsets = new byte[1];

    private CarbohydrateMonomer() {
    }

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3) {
        return new CarbohydrateMonomer().set2(chain, string, n, n2, n3, alphaOffsets);
    }

    @Override
    public boolean isCarbohydrate() {
        return true;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.CARBOHYDRATE;
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        int n = this.firstAtomIndex;
        while (n <= this.lastAtomIndex) {
            int n2 = monomer.firstAtomIndex;
            while (n2 <= monomer.lastAtomIndex) {
                Atom atom = this.chain.model.ms.at[n];
                Atom atom2 = this.chain.model.ms.at[n2];
                if (atom.getElementNumber() + atom2.getElementNumber() == 14 && (double)atom.distanceSquared(atom2) < 3.24) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    @Override
    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        int n3 = s / 2;
        if (n3 < 1200) {
            n3 = 1200;
        }
        if (atom2.sZ == 0) {
            return;
        }
        int n4 = (int)this.scaleToScreen(atom2.sZ, n3);
        if (n4 < 4) {
            n4 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n4, atom)) {
            atomArray[0] = atom2;
        }
    }

    @Override
    public boolean isConnectedPrevious() {
        if (this.monomerIndex <= 0) {
            return false;
        }
        int n = this.firstAtomIndex;
        while (n <= this.lastAtomIndex) {
            if (this.getCrossLinkGroup(n, null, null, true, false, false)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

