/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.UserLimits;

final class ServerTools {
    private ServerTools() {
    }

    static String getSQLDatetimeString(Calendar date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date.getTime());
    }

    static void print(String s) {
        ServerTools.print(s, System.out);
    }

    static void print(String s, PrintStream outputStream) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String now = dateFormat.format(new Date());
        outputStream.println(now + " " + s);
    }

    static void setCommonHeaders(HttpExchange httpExchange, String contentType, String allowOriginUrl) {
        httpExchange.getResponseHeaders().set("Content-Type", contentType);
        ServerTools.setAllowOrigin(httpExchange, allowOriginUrl);
    }

    static void setAllowOrigin(HttpExchange httpExchange, String allowOriginUrl) {
        if (allowOriginUrl != null) {
            httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", allowOriginUrl);
        }
    }

    static UserLimits getUserLimits(Map<String, String> params, HTTPServerConfig config) {
        if (params.get("token") != null) {
            return UserLimits.getLimitsFromToken(config, params.get("token"));
        }
        if (params.get("username") != null) {
            if (params.get("apiKey") != null) {
                return UserLimits.getLimitsByApiKey(config, params.get("username"), params.get("apiKey"));
            }
            if (params.get("password") != null) {
                return UserLimits.getLimitsFromUserAccount(config, params.get("username"), params.get("password"));
            }
            throw new IllegalArgumentException("With 'username' set, you also need to specify either 'apiKey' or 'password'");
        }
        return UserLimits.getDefaultLimits(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static JLanguageTool.Mode getMode(Map<String, String> params) {
        if (params.get("mode") == null) return JLanguageTool.Mode.ALL;
        String modeParam = params.get("mode");
        if ("textLevelOnly".equals(modeParam)) {
            return JLanguageTool.Mode.TEXTLEVEL_ONLY;
        }
        if ("allButTextLevelOnly".equals(modeParam)) {
            return JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY;
        }
        if (!"all".equals(modeParam)) throw new IllegalArgumentException("Mode must be one of 'textLevelOnly', 'allButTextLevelOnly', or 'all' but was: '" + modeParam + "'");
        return JLanguageTool.Mode.ALL;
    }
}

