/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.html.form;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import org.jdesktop.http.Parameter;

public class FileParameter
extends Parameter {
    private static FileNameMap MIMES;
    private String contentType;
    private String fileName;
    private boolean contentTypeSetManually = false;

    public FileParameter() {
    }

    public FileParameter(String name, File file) {
        this(name, file == null ? null : file.getAbsolutePath());
    }

    public FileParameter(String name, String fileName) {
        super(name, fileName);
        this.fileName = fileName;
        this.contentType = FileParameter.computeMimeType(fileName);
    }

    public void setContentType(String contentType) {
        String old = this.contentType;
        this.contentType = contentType == null ? "content/unknown" : contentType;
        this.contentTypeSetManually = contentType != null;
        this.firePropertyChange("contentType", old, this.contentType);
    }

    public final String getContentType() {
        return this.contentType;
    }

    public void setFilename(String name) {
        String old = this.fileName;
        this.fileName = name;
        this.firePropertyChange("filename", old, this.fileName);
        super.setValue(this.fileName);
        if (!this.contentTypeSetManually) {
            this.setContentType(FileParameter.computeMimeType(this.fileName));
        }
    }

    public final String getFilename() {
        return this.fileName;
    }

    public void setValue(String value) {
    }

    public InputStream getValueStream() {
        if (this.fileName == null) {
            return null;
        }
        try {
            return new FileInputStream(this.fileName);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public FileParameter clone() {
        FileParameter clone = new FileParameter(this.getName(), this.fileName);
        clone.contentType = this.contentType;
        return clone;
    }

    static String computeMimeType(String filename) {
        try {
            return FileParameter.getMimeMap().getContentTypeFor(filename);
        }
        catch (Exception e) {
            return "content/unknown";
        }
    }

    private static final synchronized FileNameMap getMimeMap() {
        if (MIMES == null) {
            MIMES = URLConnection.getFileNameMap();
        }
        return MIMES;
    }
}

