/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public final class QueryParserHelper {
    private QueryParserHelper() {
    }

    public static Map<String, Float> parseFieldsAndWeights(List<String> fields) {
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        for (String field : fields) {
            String fieldName;
            int boostIndex = field.indexOf(94);
            float boost = 1.0f;
            if (boostIndex != -1) {
                fieldName = field.substring(0, boostIndex);
                boost = Float.parseFloat(field.substring(boostIndex + 1, field.length()));
            } else {
                fieldName = field;
            }
            fieldsAndWeights.put(fieldName, Float.valueOf(boost));
        }
        return fieldsAndWeights;
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights) {
        return QueryParserHelper.resolveMappingFields(context, fieldsAndWeights, null);
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights, String fieldSuffix) {
        HashMap<String, Float> resolvedFields = new HashMap<String, Float>();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndWeights.entrySet()) {
            boolean allField = Regex.isMatchAllPattern(fieldEntry.getKey());
            boolean multiField = Regex.isSimpleMatchPattern(fieldEntry.getKey());
            float weight = fieldEntry.getValue() == null ? 1.0f : fieldEntry.getValue().floatValue();
            Map<String, Float> fieldMap = QueryParserHelper.resolveMappingField(context, fieldEntry.getKey(), weight, !multiField, !allField, fieldSuffix);
            resolvedFields.putAll(fieldMap);
        }
        return resolvedFields;
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField) {
        return QueryParserHelper.resolveMappingField(context, fieldOrPattern, weight, acceptAllTypes, acceptMetadataField, null);
    }

    public static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField, String fieldSuffix) {
        Collection<String> allFields = context.simpleMatchToIndexNames(fieldOrPattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            MappedFieldType fieldType;
            if (fieldSuffix != null && context.fieldMapper(fieldName + fieldSuffix) != null) {
                fieldName = fieldName + fieldSuffix;
            }
            if ((fieldType = context.getMapperService().fullName(fieldName)) == null) {
                fields.put(fieldName, Float.valueOf(weight));
                continue;
            }
            if (!acceptMetadataField && fieldType.name().startsWith("_")) continue;
            if (!acceptAllTypes) {
                try {
                    fieldType.termQuery("", context);
                }
                catch (UnsupportedOperationException | QueryShardException e) {
                    continue;
                }
                catch (IllegalArgumentException | ElasticsearchParseException runtimeException) {
                    // empty catch block
                }
            }
            fields.put(fieldName, Float.valueOf(weight));
        }
        return fields;
    }
}

