/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.aflow;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.xtal.VaspPoscarReader;
import org.jmol.util.Logger;

public class AFLOWReader
extends VaspPoscarReader {
    private String aabb;
    private boolean readPRE;
    private float fracB = Float.NaN;
    private Map<String, float[]> compositions;
    private boolean getComposition;
    private String listKey;
    private String listKeyCase;
    private int fileModelNumber;
    private boolean havePRE;
    private String titleMsg;
    private Map<String, String> keyMap = new Hashtable<String, String>();

    @Override
    protected void initializeReader() throws Exception {
        this.readPRE = this.checkFilterKey("PRE");
        String string = this.getFilter("CA=");
        if (string != null) {
            this.fracB = 1.0f - this.parseFloatStr(string);
        }
        if ((string = this.getFilter("CB=")) != null) {
            this.fracB = this.parseFloatStr(string);
        }
        this.listKeyCase = this.listKey = (string = this.getFilter("LIST=")) == null ? "HF" : string;
        this.getComposition = !Float.isNaN(this.fracB);
        this.discardLinesUntilStartsWith("[");
        this.aabb = this.line.substring(1, this.line.indexOf("]"));
        int n = PT.isUpperCase(this.aabb.charAt(1)) ? 1 : 2;
        this.defaultLabels = new String[]{this.aabb.substring(0, n), this.aabb.substring(n)};
        while (this.rd().indexOf("] REFERENCE:") >= 0) {
            this.appendLoadNote(this.line);
        }
        this.compositions = new Hashtable<String, float[]>();
        this.quiet = true;
        this.asc.bsAtoms = new BS();
        this.addJmolScript("unitcell off;axes off;");
        this.havePRE = this.line.indexOf("Structure PRE") >= 0;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (!this.havePRE) {
            this.discardLinesUntilContains("Structure PRE");
        }
        this.havePRE = false;
        if (this.line == null) {
            return false;
        }
        this.continuing &= this.readPrePost();
        return this.continuing;
    }

    private boolean readPrePost() throws Exception {
        ++this.fileModelNumber;
        this.titleMsg = "#" + (this.modelNumber + 1) + (this.getComposition ? "," + this.fileModelNumber + ", Cb=" + this.fracB : "");
        this.elementLabel = null;
        int n = this.asc.bsAtoms.cardinality();
        if (this.readPRE) {
            this.readStructure(this.titleMsg);
        } else {
            this.readElementLabelsOnly();
            this.discardLinesUntilContains("Structure POST");
            this.readStructure(this.titleMsg);
        }
        if (this.getData()) {
            this.applySymmetryAndSetTrajectory();
        } else {
            this.asc.bsAtoms.clearBits(this.asc.getLastAtomSetAtomIndex(), this.asc.ac);
            this.doCheckUnitCell = false;
        }
        this.finalizeModel();
        if (n != this.asc.bsAtoms.cardinality()) {
            Logger.info("AFLOW: file#, saved#, atoms: " + this.fileModelNumber + " " + this.modelNumber + " " + (this.asc.bsAtoms.cardinality() - n));
        }
        return !this.haveModel || this.modelNumber != this.desiredModelNumber;
    }

    private void finalizeModel() throws Exception {
        this.asc.removeLastUnselectedAtoms();
    }

    /*
     * Unable to fully structure code
     */
    private void readElementLabelsOnly() throws Exception {
        this.readLines(5);
        this.rdline();
        var1_1 = this.getTokens().length;
        this.elementLabel = new String[var1_1];
        this.rdline();
        this.line = "";
        var2_2 = null;
        var3_3 = null;
        var4_4 = 0;
        ** GOTO lbl28
        {
            block4: {
                block3: {
                    this.rdline();
                    var5_5 = this.getTokens();
                    if (var5_5.length != 4) break block3;
                    var2_2 = this.elementLabel[var4_4] = this.getElement(var5_5[3]);
                    if (this.elementLabel[var4_4] != null) break block4;
                }
                var4_4 = var1_1 + 1;
                ** GOTO lbl26
            }
            do {
                if (var2_2 == null || var2_2.equals(var3_3)) continue block0;
lbl26:
                // 2 sources

                var3_3 = var2_2;
                ++var4_4;
lbl28:
                // 2 sources

            } while (var4_4 < var1_1);
        }
        if (var2_2 == null) {
            this.elementLabel = this.defaultLabels;
        }
    }

    private boolean getData() throws Exception {
        String[] stringArray;
        Object object;
        this.discardLinesUntilContains("- DATA -");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("fileModelNumber", this.fileModelNumber);
        hashtable.put("modelNumber", this.modelNumber + 1);
        hashtable.put("AaBb", this.aabb);
        int n = 0;
        SB sB = new SB();
        float f = Float.MAX_VALUE;
        String string = "?";
        String[] stringArray2 = null;
        float f2 = 0.0f;
        while (this.rdline() != null && (n = this.line.indexOf(" # ")) >= 0) {
            float f3;
            object = this.line.substring(n + 3).trim();
            stringArray = this.line.substring(0, n).trim();
            sB.append((String)object).append("=").append((String)stringArray).append(" | ");
            if (((String)object).toUpperCase().startsWith(this.listKey)) {
                this.listKey = ((String)object).toUpperCase();
                this.listKeyCase = object;
                stringArray2 = stringArray;
                f = this.parseFloatStr((String)stringArray);
            }
            if (((String)object).equals("Ca")) {
                f3 = this.parseFloatStr((String)stringArray);
                if (!this.getComposition || !(Math.abs(1.0f - f3 - this.fracB) > 0.01f)) continue;
                return false;
            }
            if (((String)object).equals("Cb")) {
                string = stringArray;
                f2 = this.parseFloatStr((String)stringArray);
                if (!this.getComposition || !(Math.abs(f2 - this.fracB) > 0.01f)) continue;
                return false;
            }
            if (!((String)object).equals("Hf_atom [eV] (VASP)")) continue;
            f3 = this.parseFloatStr((String)stringArray);
            this.asc.setAtomSetEnergy((String)stringArray, f3);
        }
        this.asc.setAtomSetName(String.valueOf(this.titleMsg) + (this.getComposition ? "" : " Cb=" + f2) + " " + this.listKey + "=" + stringArray2);
        object = this.compositions.get(string);
        if (!this.doGetModel(++this.modelNumber, null)) {
            return false;
        }
        if (object == null) {
            float[] fArray = new float[]{0.0f, Float.MAX_VALUE, 0.0f};
            object = fArray;
            this.compositions.put(string, fArray);
        }
        Object object2 = object;
        object2[0] = object2[0] + 1.0f;
        if (f < object[1]) {
            object[1] = f;
            object[2] = (float)this.fileModelNumber;
        }
        while (this.line.indexOf("- URL -") < 0) {
            this.rdline();
        }
        sB.append("URL=" + this.rdline() + "|");
        while (this.line.indexOf("aurl=") < 0) {
            this.rdline();
        }
        sB.append(this.line);
        stringArray = PT.split(sB.toString(), " | ");
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            String[] stringArray3 = stringArray[n2].split("=");
            if (stringArray3.length < 2) continue;
            float f4 = this.parseFloatStr(stringArray3[1]);
            Object object3 = Float.isNaN(f4) ? stringArray3[1] : Float.valueOf(f4);
            hashtable.put(stringArray3[0], object3);
            String string2 = this.cleanKey(stringArray3[0]);
            if (string2 == stringArray3[0]) continue;
            hashtable.put(string2, object3);
        }
        this.asc.setCurrentModelInfo("aflowInfo", hashtable);
        return true;
    }

    private String cleanKey(String string) {
        String string2 = this.keyMap.get(string);
        if (string2 != null) {
            return string2;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        while (--n >= 0) {
            if (PT.isLetterOrDigit(cArray[n])) continue;
            cArray[n] = 95;
        }
        string2 = PT.trim(PT.rep(new String(cArray), "__", "_"), "_");
        this.keyMap.put(string, string2);
        return string2;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.alignUnitCells();
        this.listCompositions();
        this.finalizeReaderASCR();
    }

    private void listCompositions() {
        Lst<String> lst = new Lst<String>();
        for (Map.Entry<String, float[]> object2 : this.compositions.entrySet()) {
            float[] n2 = object2.getValue();
            lst.addLast(String.valueOf(object2.getKey()) + "\t" + (int)n2[0] + "\t" + (int)n2[2] + "\t" + this.listKeyCase + "\t" + n2[1]);
        }
        Object[] objectArray = new String[lst.size()];
        lst.toArray(objectArray);
        Arrays.sort(objectArray);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            this.appendLoadNote(String.valueOf(this.aabb) + "\t" + (String)objectArray[n]);
            ++n;
        }
    }

    private void alignUnitCells() {
    }
}

