/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import org.jmol.adapter.readers.quantum.SlaterReader;

abstract class MopacSlaterReader
extends SlaterReader {
    protected static final float MIN_COEF = 1.0E-4f;
    protected int[] atomicNumbers;
    private static final int[] sphericalDValues;
    private static final int[] principalQuantumNumber;
    private static final int[] npqd;

    static {
        int[] nArray = new int[15];
        nArray[1] = -2;
        nArray[3] = 1;
        nArray[5] = 1;
        nArray[6] = -2;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        sphericalDValues = nArray;
        int[] nArray2 = new int[87];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 3;
        nArray2[12] = 3;
        nArray2[13] = 3;
        nArray2[14] = 3;
        nArray2[15] = 3;
        nArray2[16] = 3;
        nArray2[17] = 3;
        nArray2[18] = 3;
        nArray2[19] = 4;
        nArray2[20] = 4;
        nArray2[21] = 4;
        nArray2[22] = 4;
        nArray2[23] = 4;
        nArray2[24] = 4;
        nArray2[25] = 4;
        nArray2[26] = 4;
        nArray2[27] = 4;
        nArray2[28] = 4;
        nArray2[29] = 4;
        nArray2[30] = 4;
        nArray2[31] = 4;
        nArray2[32] = 4;
        nArray2[33] = 4;
        nArray2[34] = 4;
        nArray2[35] = 4;
        nArray2[36] = 4;
        nArray2[37] = 5;
        nArray2[38] = 5;
        nArray2[39] = 5;
        nArray2[40] = 5;
        nArray2[41] = 5;
        nArray2[42] = 5;
        nArray2[43] = 5;
        nArray2[44] = 5;
        nArray2[45] = 5;
        nArray2[46] = 5;
        nArray2[47] = 5;
        nArray2[48] = 5;
        nArray2[49] = 5;
        nArray2[50] = 5;
        nArray2[51] = 5;
        nArray2[52] = 5;
        nArray2[53] = 5;
        nArray2[54] = 5;
        nArray2[55] = 6;
        nArray2[56] = 6;
        nArray2[57] = 6;
        nArray2[58] = 6;
        nArray2[59] = 6;
        nArray2[60] = 6;
        nArray2[61] = 6;
        nArray2[62] = 6;
        nArray2[63] = 6;
        nArray2[64] = 6;
        nArray2[65] = 6;
        nArray2[66] = 6;
        nArray2[67] = 6;
        nArray2[68] = 6;
        nArray2[69] = 6;
        nArray2[70] = 6;
        nArray2[71] = 6;
        nArray2[72] = 6;
        nArray2[73] = 6;
        nArray2[74] = 6;
        nArray2[75] = 6;
        nArray2[76] = 6;
        nArray2[77] = 6;
        nArray2[78] = 6;
        nArray2[79] = 6;
        nArray2[80] = 6;
        nArray2[81] = 6;
        nArray2[82] = 6;
        nArray2[83] = 6;
        nArray2[84] = 6;
        nArray2[85] = 6;
        nArray2[86] = 6;
        principalQuantumNumber = nArray2;
        int[] nArray3 = new int[87];
        nArray3[2] = 3;
        nArray3[10] = 3;
        nArray3[11] = 3;
        nArray3[12] = 3;
        nArray3[13] = 3;
        nArray3[14] = 3;
        nArray3[15] = 3;
        nArray3[16] = 3;
        nArray3[17] = 3;
        nArray3[18] = 4;
        nArray3[19] = 3;
        nArray3[20] = 3;
        nArray3[21] = 3;
        nArray3[22] = 3;
        nArray3[23] = 3;
        nArray3[24] = 3;
        nArray3[25] = 3;
        nArray3[26] = 3;
        nArray3[27] = 3;
        nArray3[28] = 3;
        nArray3[29] = 3;
        nArray3[30] = 4;
        nArray3[31] = 4;
        nArray3[32] = 4;
        nArray3[33] = 4;
        nArray3[34] = 4;
        nArray3[35] = 4;
        nArray3[36] = 5;
        nArray3[37] = 4;
        nArray3[38] = 4;
        nArray3[39] = 4;
        nArray3[40] = 4;
        nArray3[41] = 4;
        nArray3[42] = 4;
        nArray3[43] = 4;
        nArray3[44] = 4;
        nArray3[45] = 4;
        nArray3[46] = 4;
        nArray3[47] = 4;
        nArray3[48] = 5;
        nArray3[49] = 5;
        nArray3[50] = 5;
        nArray3[51] = 5;
        nArray3[52] = 5;
        nArray3[53] = 5;
        nArray3[54] = 6;
        nArray3[55] = 5;
        nArray3[56] = 5;
        nArray3[57] = 5;
        nArray3[58] = 5;
        nArray3[59] = 5;
        nArray3[60] = 5;
        nArray3[61] = 5;
        nArray3[62] = 5;
        nArray3[63] = 5;
        nArray3[64] = 5;
        nArray3[65] = 5;
        nArray3[66] = 5;
        nArray3[67] = 5;
        nArray3[68] = 5;
        nArray3[69] = 5;
        nArray3[70] = 5;
        nArray3[71] = 5;
        nArray3[72] = 5;
        nArray3[73] = 5;
        nArray3[74] = 5;
        nArray3[75] = 5;
        nArray3[76] = 5;
        nArray3[77] = 5;
        nArray3[78] = 5;
        nArray3[79] = 5;
        nArray3[80] = 6;
        nArray3[81] = 6;
        nArray3[82] = 6;
        nArray3[83] = 6;
        nArray3[84] = 6;
        nArray3[85] = 6;
        nArray3[86] = 7;
        npqd = nArray3;
    }

    MopacSlaterReader() {
    }

    protected void createSphericalSlaterByType(int n, int n2, String string, float f, float f2) {
        int n3 = "S Px Py Pz  Dx2-y2Dxz Dz2 Dyz Dxy".indexOf(string);
        switch (n3) {
            case 0: {
                this.addSlater(n + 1, 0, 0, 0, MopacSlaterReader.getNPQs(n2) - 1, f, f2);
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(n + 1, n3 == 2 ? 1 : 0, n3 == 5 ? 1 : 0, n3 == 8 ? 1 : 0, MopacSlaterReader.getNPQp(n2) - 2, f, f2);
                return;
            }
        }
        n3 = (n3 >> 2) * 3 - 9;
        this.addSlater(n + 1, sphericalDValues[n3++], sphericalDValues[n3++], sphericalDValues[n3++], MopacSlaterReader.getNPQd(n2) - 3, f, f2);
    }

    @Override
    protected double scaleSlater(int n, int n2, int n3, int n4, double d) {
        if (n >= 0 && n2 >= 0) {
            return super.scaleSlater(n, n2, n3, n4, d);
        }
        int n5 = Math.abs(n + n2 + n3);
        if (n5 == 3) {
            return 0.0;
        }
        return MopacSlaterReader.getSlaterConstDSpherical(n5 + n4 + 1, Math.abs(d), n, n2);
    }

    private static final int getNPQ(int n) {
        return n < principalQuantumNumber.length ? principalQuantumNumber[n] : 0;
    }

    private static final int getNPQs(int n) {
        int n2 = MopacSlaterReader.getNPQ(n);
        switch (n) {
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return n2 + 1;
            }
        }
        return n2;
    }

    private static final int getNPQp(int n) {
        int n2 = MopacSlaterReader.getNPQ(n);
        switch (n) {
            case 2: {
                return n2 + 1;
            }
        }
        return n2;
    }

    private static final int getNPQd(int n) {
        return n < npqd.length ? npqd[n] : 0;
    }
}

