/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.SB;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;

public class StateScript {
    private int modelIndex;
    private BS bsBonds;
    private BS bsAtoms1;
    private BS bsAtoms2;
    private String script1;
    private String script2;
    public boolean inDefinedStateBlock;

    StateScript(int n, String string, BS bS, BS bS2, BS bS3, String string2, boolean bl) {
        this.modelIndex = n;
        this.script1 = string;
        this.bsBonds = BSUtil.copy(bS);
        this.bsAtoms1 = BSUtil.copy(bS2);
        this.bsAtoms2 = BSUtil.copy(bS3);
        this.script2 = string2;
        this.inDefinedStateBlock = bl;
    }

    public boolean isValid() {
        return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
    }

    public String toString() {
        String string;
        if (!this.isValid()) {
            return "";
        }
        SB sB = SB.newS(this.script1);
        if (this.bsBonds != null) {
            sB.append(" ").append(Escape.eBond(this.bsBonds));
        }
        if (this.bsAtoms1 != null) {
            sB.append(" ").append(Escape.eBS(this.bsAtoms1));
        }
        if (this.bsAtoms2 != null) {
            sB.append(" ").append(Escape.eBS(this.bsAtoms2));
        }
        if (this.script2 != null) {
            sB.append(" ").append(this.script2);
        }
        if (!(string = sB.toString()).endsWith(";")) {
            string = String.valueOf(string) + ";";
        }
        return string;
    }

    public boolean isConnect() {
        return this.script1.indexOf("connect") >= 0;
    }

    public boolean deleteAtoms(int n, BS bS, BS bS2) {
        if (n == this.modelIndex) {
            return false;
        }
        if (n > this.modelIndex) {
            return true;
        }
        BSUtil.deleteBits(this.bsBonds, bS);
        BSUtil.deleteBits(this.bsAtoms1, bS2);
        BSUtil.deleteBits(this.bsAtoms2, bS2);
        return this.isValid();
    }

    public void setModelIndex(int n) {
        this.modelIndex = n;
    }
}

